/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.inventory.ContainerVacuumPump;
import me.desht.pneumaticcraft.common.tileentity.TileEntityVacuumPump;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiVacuumPump
extends GuiPneumaticContainerBase<ContainerVacuumPump, TileEntityVacuumPump> {
    public GuiVacuumPump(ContainerVacuumPump container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_VACUUM_PUMP;
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.font.func_211126_b("+", 32.0f, 47.0f, -16733696);
        this.font.func_211126_b("-", 138.0f, 47.0f, -65536);
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        super.func_146976_a(opacity, x, y);
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        float pressure = ((Float)((TileEntityVacuumPump)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((TileEntityVacuumPump)this.te).getInputSide()).map(IAirHandler::getPressure).orElseThrow(RuntimeException::new)).floatValue();
        GuiUtils.drawPressureGauge(this.font, -1.0f, 7.0f, 5.0f, 2.0f, pressure, xStart + this.field_146999_f / 5, yStart + this.field_147000_g / 5 + 4);
        float vacPressure = ((Float)((TileEntityVacuumPump)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((TileEntityVacuumPump)this.te).getVacuumSide()).map(IAirHandler::getPressure).orElseThrow(RuntimeException::new)).floatValue();
        GuiUtils.drawPressureGauge(this.font, -1.0f, 7.0f, 5.0f, -1.0f, vacPressure, xStart + this.field_146999_f * 4 / 5, yStart + this.field_147000_g / 5 + 4);
    }

    @Override
    protected PointXY getGaugeLocation() {
        return null;
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        IAirHandlerMachine inputAirHandler = (IAirHandlerMachine)((TileEntityVacuumPump)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((TileEntityVacuumPump)this.te).getInputSide()).orElseThrow(RuntimeException::new);
        IAirHandlerMachine vacuumHandler = (IAirHandlerMachine)((TileEntityVacuumPump)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((TileEntityVacuumPump)this.te).getVacuumSide()).orElseThrow(RuntimeException::new);
        String col = TextFormatting.BLACK.toString();
        pressureStatText.add(col + I18n.func_135052_a((String)"gui.tab.status.vacuumPump.inputPressure", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(inputAirHandler.getPressure(), 2)}));
        pressureStatText.add(col + I18n.func_135052_a((String)"gui.tab.status.vacuumPump.vacuumPressure", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(vacuumHandler.getPressure(), 2)}));
        pressureStatText.add(col + I18n.func_135052_a((String)"gui.tab.status.vacuumPump.inputAir", (Object[])new Object[]{String.format("%,d", inputAirHandler.getAir())}));
        pressureStatText.add(col + I18n.func_135052_a((String)"gui.tab.status.vacuumPump.vacuumAir", (Object[])new Object[]{String.format("%,d", vacuumHandler.getAir())}));
        int volume = inputAirHandler.getVolume();
        int upgrades = ((TileEntityVacuumPump)this.te).getUpgrades(EnumUpgrade.VOLUME);
        pressureStatText.add(col + I18n.func_135052_a((String)"gui.tooltip.baseVolume", (Object[])new Object[]{String.format("%,d", 2000)}));
        pressureStatText.add(col + I18n.func_135052_a((String)"gui.tooltip.effectiveVolume", (Object[])new Object[]{String.format("%,d", volume)}));
        if (volume > inputAirHandler.getBaseVolume()) {
            pressureStatText.add(col + "\u25b6" + " " + upgrades + " x " + EnumUpgrade.VOLUME.getItemStack().func_200301_q().func_150254_d());
            pressureStatText.add(col + I18n.func_135052_a((String)"gui.tooltip.effectiveVolume", (Object[])new Object[]{String.format("%,d", volume)}));
        }
        if (((TileEntityVacuumPump)this.te).turning) {
            int suction = Math.round(2.0f * ((TileEntityVacuumPump)this.te).getSpeedMultiplierFromUpgrades());
            pressureStatText.add(col + I18n.func_135052_a((String)"gui.tooltip.suction", (Object[])new Object[]{String.format("%,d", suction)}));
        }
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        float pressure = ((Float)((TileEntityVacuumPump)this.te).getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, ((TileEntityVacuumPump)this.te).getInputSide()).map(IAirHandler::getPressure).orElseThrow(RuntimeException::new)).floatValue();
        if (pressure < 2.0f) {
            textList.add("gui.tab.problems.notEnoughPressure");
            textList.add(I18n.func_135052_a((String)"gui.tab.problems.applyPressure", (Object[])new Object[]{Float.valueOf(2.0f)}));
        }
    }
}

