/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.GuiUnitProgrammer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.DroneDebugUpgradeHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.living.DebugEntry;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiDroneDebuggerOptions
extends IOptionPage.SimpleToggleableOptions<DroneDebugUpgradeHandler> {
    private static final int PROGRAMMING_MARGIN = 20;
    private static final int PROGRAMMING_START_Y = 40;
    private EntityDrone selectedDrone;
    private GuiUnitProgrammer programmerUnit;
    private int programmingStartX;
    private int programmingWidth;
    private int programmingHeight;
    private IProgWidget areaShowingWidget;
    private Button showActive;
    private Button showStart;
    private WidgetCheckBox followCheckbox;
    private static int areaShowWidgetId = -1;

    public GuiDroneDebuggerOptions(IGuiScreen screen, DroneDebugUpgradeHandler upgradeHandler) {
        super(screen, upgradeHandler);
    }

    public static void clearAreaShowWidgetId() {
        areaShowWidgetId = -1;
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        ItemStack helmet;
        if (Minecraft.func_71410_x().field_71439_g != null && !(helmet = ClientUtils.getClientPlayer().func_184582_a(EquipmentSlotType.HEAD)).func_190926_b()) {
            int entityId = NBTUtil.getInteger(helmet, "debuggingDrone");
            Entity entity = ClientUtils.getClientWorld().func_73045_a(entityId);
            if (entity instanceof EntityDrone) {
                this.selectedDrone = (EntityDrone)entity;
            }
        }
        this.showStart = new WidgetButtonExtended(30, 128, 150, 20, I18n.func_135052_a((String)"gui.progWidget.debug.showStart", (Object[])new Object[0]), b -> this.programmerUnit.gotoPiece(GuiProgrammer.findWidget(this.selectedDrone.getProgWidgets(), ProgWidgetStart.class)));
        gui.addWidget(this.showStart);
        this.showActive = new WidgetButtonExtended(30, 150, 150, 20, I18n.func_135052_a((String)"gui.progWidget.debug.showActive", (Object[])new Object[0]), b -> this.programmerUnit.gotoPiece(this.selectedDrone.getActiveWidget()));
        gui.addWidget(this.showActive);
        this.followCheckbox = new WidgetCheckBox(30, 176, -1, " " + I18n.func_135052_a((String)"gui.progWidget.debug.followActive", (Object[])new Object[0]));
        this.followCheckbox.x = 180 - this.followCheckbox.getWidth();
        gui.addWidget(this.followCheckbox);
        Screen guiScreen = this.getGuiScreen().getScreen();
        this.programmingStartX = 20;
        this.programmingWidth = guiScreen.width - 40;
        this.programmingHeight = guiScreen.height - 20 - 40;
        this.programmerUnit = new DebugInfoProgrammerUnit(this.selectedDrone != null ? this.selectedDrone.getProgWidgets() : new ArrayList(), gui.getFontRenderer(), 0, 0, guiScreen.width, guiScreen.height, new Rectangle2d(this.programmingStartX, 40, this.programmingWidth, this.programmingHeight), 0, 0, 0);
        if (this.selectedDrone != null) {
            this.programmerUnit.gotoPiece(GuiProgrammer.findWidget(this.selectedDrone.getProgWidgets(), ProgWidgetStart.class));
        }
    }

    @Override
    public void renderPre(int x, int y, float partialTicks) {
        AbstractGui.fill((int)this.programmingStartX, (int)40, (int)(this.programmingStartX + this.programmingWidth), (int)(40 + this.programmingHeight), (int)0x55000000);
    }

    @Override
    public void renderPost(int x, int y, float partialTicks) {
        int widgetId;
        DebugEntry entry;
        IProgWidget widget;
        Screen guiScreen = this.getGuiScreen().getScreen();
        int screenWidth = guiScreen.width;
        int screenHeight = guiScreen.height;
        if (this.selectedDrone != null) {
            Minecraft.func_71410_x().field_71466_p.func_175063_a("Drone name: " + this.selectedDrone.func_200200_C_().func_150254_d(), 20.0f, (float)(screenHeight - 15), -1);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("Routine: " + this.selectedDrone.getLabel(), (float)screenWidth / 2.0f, (float)(screenHeight - 15), -1);
        }
        GlStateManager.translated((double)0.0, (double)0.0, (double)300.0);
        this.programmerUnit.render(x, y, true, true);
        this.programmerUnit.renderForeground(x, y, null);
        GlStateManager.translated((double)0.0, (double)0.0, (double)-300.0);
        this.followCheckbox.render(x, y, partialTicks);
        if (this.selectedDrone == null) {
            guiScreen.drawCenteredString(Minecraft.func_71410_x().field_71466_p, "Press '" + KeyHandler.getInstance().keybindDebuggingDrone.func_197978_k() + "' on a Drone when tracked by an Entity Tracker to debug the Drone.", screenWidth / 2, screenHeight / 2, -65536);
        }
        if ((widget = this.programmerUnit.getHoveredWidget(x, y)) == null) {
            widget = this.areaShowingWidget;
        }
        ((DroneDebugUpgradeHandler)this.getUpgradeHandler()).getShowingPositions().clear();
        if (widget != null && (entry = this.selectedDrone.getDebugEntry(widgetId = this.selectedDrone.getProgWidgets().indexOf(widget))) != null && entry.hasCoords()) {
            ((DroneDebugUpgradeHandler)this.getUpgradeHandler()).getShowingPositions().add(entry.getPos());
        }
    }

    @Override
    public void tick() {
        this.showStart.active = this.selectedDrone != null && !this.selectedDrone.getProgWidgets().isEmpty();
        boolean bl = this.showActive.active = this.selectedDrone != null && this.selectedDrone.getActiveWidget() != null;
        if (this.followCheckbox.checked && this.selectedDrone != null && this.selectedDrone.getActiveWidget() != null) {
            this.programmerUnit.gotoPiece(this.selectedDrone.getActiveWidget());
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        IProgWidget widget;
        if (mouseButton == 0) {
            this.areaShowingWidget = this.programmerUnit.getHoveredWidget((int)mouseX, (int)mouseY);
        } else if (mouseButton == 1 && (widget = this.programmerUnit.getHoveredWidget((int)mouseX, (int)mouseY)) instanceof IAreaProvider) {
            ((DroneDebugUpgradeHandler)this.getUpgradeHandler()).getShownArea().clear();
            int widgetId = this.selectedDrone.getProgWidgets().indexOf(widget);
            if (areaShowWidgetId != widgetId) {
                HashSet area = Sets.newHashSet();
                ((IAreaProvider)((Object)widget)).getArea(area);
                ((DroneDebugUpgradeHandler)this.getUpgradeHandler()).getShownArea().addAll(area);
                areaShowWidgetId = widgetId;
            } else {
                GuiDroneDebuggerOptions.clearAreaShowWidgetId();
            }
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double mouseButton) {
        return this.programmerUnit.getScrollBar().mouseScrolled(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isToggleable() {
        return false;
    }

    @Override
    public boolean displaySettingsHeader() {
        return false;
    }

    private class DebugInfoProgrammerUnit
    extends GuiUnitProgrammer {
        DebugInfoProgrammerUnit(List<IProgWidget> progWidgets, FontRenderer fontRenderer, int guiLeft, int guiTop, int width, int height, Rectangle2d bounds, int translatedX, int translatedY, int lastZoom) {
            super(progWidgets, fontRenderer, guiLeft, guiTop, width, height, bounds, translatedX, translatedY, lastZoom);
            TileEntityProgrammer.updatePuzzleConnections(progWidgets);
        }

        @Override
        protected void addAdditionalInfoToTooltip(IProgWidget widget, List<ITextComponent> tooltip) {
            int widgetId = GuiDroneDebuggerOptions.this.selectedDrone.getProgWidgets().indexOf(widget);
            DebugEntry entry = GuiDroneDebuggerOptions.this.selectedDrone.getDebugEntry(widgetId);
            if (entry != null) {
                long elapsed = (System.currentTimeMillis() - entry.getReceivedTime()) / 50L;
                tooltip.add(new StringTextComponent("Last message:").func_211708_a(TextFormatting.AQUA).func_150258_a(PneumaticCraftUtils.convertTicksToMinutesAndSeconds(elapsed, true)).func_211708_a(TextFormatting.YELLOW).func_150258_a(" ago"));
                tooltip.add(new StringTextComponent("  \"").func_150257_a(PneumaticCraftUtils.xlate(entry.getMessage(), new Object[0])).func_150258_a("\"  ").func_211709_a(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.ITALIC}));
                if (entry.hasCoords()) {
                    tooltip.add(PneumaticCraftUtils.xlate("gui.progWidget.debug.hasPositions", new Object[0]).func_211708_a(TextFormatting.GREEN));
                    if (widget != GuiDroneDebuggerOptions.this.areaShowingWidget) {
                        tooltip.add(PneumaticCraftUtils.xlate("gui.progWidget.debug.clickToShow", new Object[0]).func_211708_a(TextFormatting.GREEN));
                    }
                }
            }
            if (widget instanceof IAreaProvider) {
                if (widgetId == areaShowWidgetId) {
                    tooltip.add(new StringTextComponent("Right-Click: ").func_150257_a(PneumaticCraftUtils.xlate("gui.programmer.button.stopShowingArea", new Object[0])).func_211708_a(TextFormatting.GREEN));
                } else {
                    tooltip.add(new StringTextComponent("Right-Click: ").func_150257_a(PneumaticCraftUtils.xlate("gui.programmer.button.showArea", new Object[0])).func_211708_a(TextFormatting.GREEN));
                }
            }
        }

        @Override
        protected void renderAdditionally() {
            if (GuiDroneDebuggerOptions.this.selectedDrone != null && GuiDroneDebuggerOptions.this.selectedDrone.getActiveWidget() != null) {
                this.drawBorder(GuiDroneDebuggerOptions.this.selectedDrone.getActiveWidget(), -16711936);
                if (areaShowWidgetId >= 0) {
                    this.drawBorder(GuiDroneDebuggerOptions.this.selectedDrone.getProgWidgets().get(areaShowWidgetId), -1606352992, 2);
                }
            }
        }
    }
}

