/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.client.event.ClientEventHandler;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.config.aux.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class WidgetAnimatedStat
extends Widget
implements IGuiAnimatedStat,
ITooltipProvider {
    private static final int ANIMATED_STAT_SPEED = 30;
    private static final int MIN_WIDTH_HEIGHT = 17;
    private static final int MAX_LINES = 12;
    private static final Pattern DARK_FORMATTING = Pattern.compile("\\u00A7[0123458]");
    private IGuiAnimatedStat affectingStat;
    private StatIcon statIcon;
    private final Screen gui;
    private final List<String> textList = new ArrayList<String>();
    private final List<Widget> subWidgets = new ArrayList<Widget>();
    private int affectedY;
    private int oldBaseX;
    private int oldAffectedY;
    private int oldWidth;
    private int oldHeight;
    private boolean isClicked = false;
    private int minWidth = 17;
    private int minHeight = 17;
    private int backGroundColor;
    private TintColor bgColorHi;
    private TintColor bgColorLo;
    private String title;
    private boolean leftSided;
    private boolean doneExpanding;
    private float textSize;
    private float textScale = 1.0f;
    private int curScroll;
    private int lineSpacing = 10;
    private int widgetOffsetLeft = 0;
    private int widgetOffsetRight = 0;
    private boolean bevel = false;
    private WidgetVerticalScrollbar scrollBar = null;

    public WidgetAnimatedStat(Screen gui, String title, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        super(xPos, yPos, 17, 17, title);
        this.gui = gui;
        this.affectingStat = affectingStat;
        this.backGroundColor = backGroundColor;
        this.calculateColorHighlights(this.backGroundColor);
        this.setTitle(title);
        this.statIcon = StatIcon.NONE;
        this.leftSided = leftSided;
        this.textSize = 1.0f;
        this.affectedY = this.y;
        if (affectingStat != null) {
            this.affectedY += affectingStat.getAffectedY() + affectingStat.getHeight();
        }
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor) {
        this(gui, "", 0, 0, backgroundColor, null, false);
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor, ItemStack icon) {
        this(gui, backgroundColor);
        this.statIcon = StatIcon.of(icon);
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor, String texture) {
        this(gui, backgroundColor);
        this.statIcon = StatIcon.of(PneumaticCraftUtils.RL(texture));
    }

    public WidgetAnimatedStat(Screen gui, String title, StatIcon icon, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        this(gui, title, xPos, yPos, backGroundColor, affectingStat, leftSided);
        this.statIcon = icon;
    }

    public WidgetAnimatedStat(Screen gui, String title, StatIcon icon, int backGroundColor, IGuiAnimatedStat affectingStat, ArmorHUDLayout.LayoutItem layout) {
        this(gui, title, 0, 0, backGroundColor, affectingStat, layout.isLeftSided());
        MainWindow mw = Minecraft.func_71410_x().field_195558_d;
        int x = layout.getX() == -1.0f ? mw.func_198107_o() - 2 : (int)((float)mw.func_198107_o() * layout.getX());
        this.setBaseX(x);
        this.setBaseY((int)((float)mw.func_198087_p() * layout.getY()));
        this.statIcon = icon;
    }

    @Override
    public void setParentStat(IGuiAnimatedStat stat) {
        this.affectingStat = stat;
    }

    public void addSubWidget(Widget widget) {
        this.subWidgets.add(widget);
    }

    public void removeSubWidget(Widget widget) {
        this.subWidgets.remove(widget);
    }

    public void setWidgetOffsets(int left, int right) {
        this.widgetOffsetLeft = left;
        this.widgetOffsetRight = right;
    }

    @Override
    public Rectangle2d getButtonScaledRectangle(int origX, int origY, int width, int height) {
        int scaledX = (int)((float)origX * this.textSize);
        int scaledY = (int)((float)origY * this.textSize);
        return new Rectangle2d(scaledX, scaledY, (int)((float)width * this.textSize), (int)((float)height * this.textSize));
    }

    @Override
    public void scaleTextSize(float scale) {
        this.textSize *= scale;
        this.textScale = scale;
        this.subWidgets.removeIf(w -> w == this.scrollBar);
        this.scrollBar = null;
        this.onTextChange();
    }

    @Override
    public boolean isLeftSided() {
        return this.leftSided;
    }

    @Override
    public void setLeftSided(boolean leftSided) {
        this.leftSided = leftSided;
    }

    @Override
    public IGuiAnimatedStat setText(List<String> text) {
        this.textList.clear();
        for (String line : text) {
            this.textList.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)line, (Object[])new Object[0]), (int)(26.0f / this.textScale)));
        }
        this.onTextChange();
        return this;
    }

    @Override
    public IGuiAnimatedStat setText(String text) {
        this.textList.clear();
        this.textList.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)text, (Object[])new Object[0]), (int)(26.0f / this.textScale)));
        this.onTextChange();
        return this;
    }

    @Override
    public void setTextWithoutCuttingString(List<String> text) {
        this.textList.clear();
        this.textList.addAll(text);
        this.onTextChange();
    }

    @Override
    public void appendText(List<String> text) {
        for (String line : text) {
            this.textList.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)line, (Object[])new Object[0]), (int)(26.0f / this.textScale)));
        }
        this.onTextChange();
    }

    @Override
    public void addPadding(int nRows, int nCols) {
        String s = Strings.repeat((String)" ", (int)nCols);
        this.setTextWithoutCuttingString(IntStream.range(0, nRows).mapToObj(i -> s).collect(Collectors.toList()));
    }

    @Override
    public void addPadding(List<String> text, int nRows, int nCols) {
        String s = Strings.repeat((String)" ", (int)nCols);
        List<String> l = IntStream.range(0, nRows).mapToObj(i -> s).collect(Collectors.toList());
        for (int i2 = 0; i2 < text.size() && i2 < nRows; ++i2) {
            l.set(i2, text.get(i2));
        }
        this.setTextWithoutCuttingString(l);
    }

    @Override
    public void setBackgroundColor(int backgroundColor) {
        if (backgroundColor != this.backGroundColor) {
            this.backGroundColor = backgroundColor;
            this.calculateColorHighlights(backgroundColor);
        }
    }

    @Override
    public int getBackgroundColor() {
        return this.backGroundColor;
    }

    private void calculateColorHighlights(int color) {
        if (PNCConfig.Client.guiBevel) {
            float fgR = (float)(color >> 16 & 0xFF) / 255.0f;
            float fgG = (float)(color >> 8 & 0xFF) / 255.0f;
            float fgB = (float)(color & 0xFF) / 255.0f;
            float fgA = (float)(color >> 24 & 0xFF) / 255.0f;
            TintColor c = new TintColor(fgR, fgG, fgB, fgA);
            if (this.bevel) {
                this.bgColorHi = c.brighter();
                this.bgColorLo = c.darker();
            } else {
                this.bgColorLo = this.bgColorHi = c.darker().darker();
            }
        } else {
            this.bgColorLo = this.bgColorHi = TintColor.BLACK;
        }
    }

    @Override
    public void setBeveled(boolean bevel) {
        this.bevel = bevel;
        this.calculateColorHighlights(this.backGroundColor);
    }

    private void onTextChange() {
        if (this.textList.size() > 12) {
            for (Widget widget : this.subWidgets) {
                if (widget != this.scrollBar) continue;
                return;
            }
            this.curScroll = 0;
            int h = (int)((float)(12 * this.lineSpacing - 20) * this.textSize);
            this.scrollBar = new WidgetVerticalScrollbar(this.leftSided ? -16 : 2, 20, h).setStates(this.textList.size() - 12).setListening(true);
            this.addSubWidget(this.scrollBar);
        } else {
            Iterator<Widget> iterator = this.subWidgets.iterator();
            while (iterator.hasNext()) {
                Widget widget = iterator.next();
                if (widget != this.scrollBar) continue;
                iterator.remove();
                this.curScroll = 0;
            }
        }
    }

    @Override
    public void setMinDimensionsAndReset(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.width = minWidth;
        this.height = minHeight;
    }

    @Override
    public void tickWidget() {
        this.oldBaseX = this.x;
        this.oldAffectedY = this.affectedY;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.doneExpanding = true;
        if (this.isClicked) {
            Pair<Integer, Integer> maxSize = this.calculateMaxSize();
            int maxWidth = (Integer)maxSize.getLeft();
            int maxHeight = (Integer)maxSize.getRight();
            this.width = Math.min(maxWidth, this.width + 30);
            this.height = Math.min(maxHeight, this.height + 30);
            this.doneExpanding = this.width == maxWidth && this.height == maxHeight;
            Pair<Integer, Integer> size = ClientEventHandler.getScaledScreenSize();
            if (this.isLeftSided()) {
                if (this.x >= (Integer)size.getLeft()) {
                    this.x = (Integer)size.getLeft();
                }
            } else if (this.x < 0) {
                this.x = 1;
            }
            if (this.y + this.height >= (Integer)size.getRight()) {
                this.y = (Integer)size.getRight() - this.height - 1;
            }
            if (this.doneExpanding) {
                for (Widget widget : this.subWidgets) {
                    if (widget != this.scrollBar) continue;
                    this.curScroll = ((WidgetVerticalScrollbar)widget).getState();
                    break;
                }
            }
        } else {
            this.width = Math.max(this.minWidth, this.width - 30);
            this.height = Math.max(this.minHeight, this.height - 30);
            this.doneExpanding = false;
        }
        this.affectedY = this.y;
        if (this.affectingStat != null) {
            this.affectedY += this.affectingStat.getAffectedY() + this.affectingStat.getHeight();
        }
    }

    private Pair<Integer, Integer> calculateMaxSize() {
        int maxHeight;
        int availableWidth;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        if (this.gui instanceof ContainerScreen) {
            ContainerScreen gc = (ContainerScreen)this.gui;
            availableWidth = this.leftSided ? gc.getGuiLeft() : gc.width - (gc.getGuiLeft() + gc.getXSize());
        } else {
            availableWidth = Minecraft.func_71410_x().field_195558_d.func_198107_o();
        }
        int maxWidth = fontRenderer.func_78256_a(this.title);
        for (String line : this.textList) {
            maxWidth = Math.max(maxWidth, fontRenderer.func_78256_a(line));
        }
        maxWidth += 20;
        int n = maxHeight = this.title.isEmpty() ? 6 : 16;
        if (!this.textList.isEmpty()) {
            maxHeight += Math.min(12, this.textList.size()) * this.lineSpacing;
        }
        fontRenderer.getClass();
        maxHeight -= this.lineSpacing - 9;
        float lastTextSize = this.textSize;
        if (maxWidth > availableWidth - 3) {
            this.textSize = ((float)availableWidth - 3.0f) / (float)maxWidth;
            maxWidth = (int)((float)maxWidth * this.textSize);
            maxHeight = (int)((float)maxHeight * this.textSize);
        } else {
            this.textSize = 1.0f;
        }
        if (lastTextSize != this.textSize) {
            float newTextSize = this.textSize;
            this.textSize = 1.0f;
            this.scaleTextSize(newTextSize);
        }
        return Pair.of((Object)maxWidth, (Object)maxHeight);
    }

    @Override
    public void render(int x, int y, float partialTicks) {
        if (this.visible) {
            int baseX = this.leftSided ? this.x - this.width : this.x;
            this.isHovered = x >= baseX && y >= this.affectedY && x < baseX + this.width && y < this.affectedY + this.height;
            this.renderButton(x, y, partialTicks);
        }
    }

    protected boolean clicked(double mouseX, double mouseY) {
        if (this.leftSided) {
            return this.active && this.visible && mouseX >= (double)this.x - (double)this.width && mouseX < (double)this.x && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        }
        return super.clicked(mouseX, mouseY);
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        int titleYoffset;
        float zLevel = 0.0f;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int renderBaseX = (int)((float)this.oldBaseX + (float)(this.x - this.oldBaseX) * partialTicks);
        int renderAffectedY = (int)((float)this.oldAffectedY + (float)(this.affectedY - this.oldAffectedY) * partialTicks);
        int renderWidth = (int)((float)this.oldWidth + (float)(this.width - this.oldWidth) * partialTicks);
        int renderHeight = (int)((float)this.oldHeight + (float)(this.height - this.oldHeight) * partialTicks);
        if (this.leftSided) {
            renderWidth *= -1;
        }
        AbstractGui.fill((int)renderBaseX, (int)renderAffectedY, (int)(renderBaseX + renderWidth), (int)(renderAffectedY + renderHeight), (int)this.backGroundColor);
        GlStateManager.disableTexture();
        GlStateManager.lineWidth((float)3.0f);
        GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        float[] c1 = this.leftSided ? this.bgColorLo.getComponents(null) : this.bgColorHi.getComponents(null);
        float[] c2 = this.bgColorHi.getComponents(null);
        float[] c3 = this.leftSided ? this.bgColorHi.getComponents(null) : this.bgColorLo.getComponents(null);
        float[] c4 = this.bgColorLo.getComponents(null);
        wr.func_181662_b((double)renderBaseX, (double)renderAffectedY, (double)zLevel).func_181666_a(c1[0], c1[1], c1[2], c1[3]).func_181675_d();
        wr.func_181662_b((double)(renderBaseX + renderWidth), (double)renderAffectedY, (double)zLevel).func_181666_a(c2[0], c2[1], c2[2], c2[3]).func_181675_d();
        wr.func_181662_b((double)(renderBaseX + renderWidth), (double)(renderAffectedY + renderHeight), (double)zLevel).func_181666_a(c3[0], c3[1], c3[2], c3[3]).func_181675_d();
        wr.func_181662_b((double)renderBaseX, (double)(renderAffectedY + renderHeight), (double)zLevel).func_181666_a(c4[0], c4[1], c4[2], c4[3]).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.enableTexture();
        if (this.leftSided) {
            renderWidth *= -1;
        }
        int n = titleYoffset = this.title.isEmpty() ? 3 : 12;
        if (this.doneExpanding) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)(renderBaseX + (this.leftSided ? -renderWidth : 16)), (double)renderAffectedY, (double)0.0);
            GlStateManager.scaled((double)this.textSize, (double)this.textSize, (double)this.textSize);
            GlStateManager.translated((double)(-renderBaseX - (this.leftSided ? -renderWidth : 16)), (double)(-renderAffectedY), (double)0.0);
            if (!this.title.isEmpty()) {
                fontRenderer.func_175063_a(this.title, (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + 2), 0xFFFF00);
            }
            for (int i = this.curScroll; i < this.textList.size() && i < this.curScroll + 12; ++i) {
                if (DARK_FORMATTING.matcher(this.textList.get(i)).find()) {
                    fontRenderer.func_211126_b(this.textList.get(i), (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + (i - this.curScroll) * this.lineSpacing + titleYoffset), 0xFFFFFF);
                    continue;
                }
                fontRenderer.func_175063_a(this.textList.get(i), (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + (i - this.curScroll) * this.lineSpacing + titleYoffset), 0xFFFFFF);
            }
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)(renderBaseX + (this.leftSided ? this.widgetOffsetLeft : this.widgetOffsetRight)), (double)(renderAffectedY + (titleYoffset - 10)), (double)0.0);
            GlStateManager.enableTexture();
            for (Widget widget : this.subWidgets) {
                widget.render(mouseX - renderBaseX, mouseY - renderAffectedY, partialTicks);
            }
            GlStateManager.popMatrix();
        }
        if (renderHeight > 16 && renderWidth > 16 && this.statIcon != null) {
            this.statIcon.render(renderBaseX, renderAffectedY, this.leftSided);
        }
    }

    private void toggle() {
        boolean bl = this.isClicked = !this.isClicked;
        if (this.isClicked && this.gui instanceof GuiPneumaticContainerBase) {
            List<IGuiAnimatedStat> widgets = ((GuiPneumaticContainerBase)this.gui).getStatWidgets();
            widgets.stream().filter(stat -> this != stat && stat.isLeftSided() == this.isLeftSided()).forEach(IGuiAnimatedStat::closeWindow);
            for (Widget w : this.subWidgets) {
                if (!(w instanceof TextFieldWidget)) continue;
                ((TextFieldWidget)w).func_146195_b(true);
            }
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.active && this.visible && this.getBounds().func_199315_b((int)mouseX, (int)mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isHovered()) {
            for (Widget widget : this.subWidgets) {
                if (!widget.mouseClicked(mouseX - (double)this.x, mouseY - (double)this.affectedY, button)) continue;
                return true;
            }
            this.toggle();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isHovered()) {
            for (Widget widget : this.subWidgets) {
                if (!widget.mouseReleased(mouseX - (double)this.x, mouseY - (double)this.affectedY, button)) continue;
                return true;
            }
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isHovered()) {
            Rectangle2d bounds = this.getBounds();
            for (Widget widget : this.subWidgets) {
                if (!widget.mouseDragged(mouseX - (double)bounds.func_199318_a(), mouseY - (double)bounds.func_199319_b(), button, dragX, dragY)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double x, double y, double dir) {
        Rectangle2d bounds = this.getBounds();
        for (Widget widget : this.subWidgets) {
            if (!widget.mouseScrolled(x - (double)bounds.func_199318_a(), y - (double)bounds.func_199319_b(), dir)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (Widget widget : this.subWidgets) {
            if (!widget.keyPressed(keyCode, scanCode, modifiers) && (!(widget instanceof TextFieldWidget) || !widget.isFocused() || keyCode == 256)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        for (Widget widget : this.subWidgets) {
            if (!widget.charTyped(p_charTyped_1_, p_charTyped_2_)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void closeWindow() {
        this.isClicked = false;
    }

    @Override
    public void openWindow() {
        this.isClicked = true;
    }

    @Override
    public boolean isClicked() {
        return this.isClicked;
    }

    @Override
    public int getAffectedY() {
        return this.affectedY;
    }

    @Override
    public int getBaseX() {
        return this.x;
    }

    @Override
    public int getBaseY() {
        return this.y;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setBaseY(int y) {
        this.y = y;
    }

    @Override
    public void setTitle(String title) {
        this.title = I18n.func_135052_a((String)title, (Object[])new Object[0]);
    }

    @Override
    public boolean isDoneExpanding() {
        return this.doneExpanding;
    }

    @Override
    public void setBaseX(int x) {
        this.x = x;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Rectangle2d getBounds() {
        return new Rectangle2d(this.x - (this.leftSided ? this.width : 0), this.affectedY, this.width, this.height);
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTooltip, boolean shiftPressed) {
        if (this.mouseIsHoveringOverIcon(mouseX, mouseY)) {
            curTooltip.add(this.title);
        }
        for (Widget widget : this.subWidgets) {
            if (!widget.isHovered() || !(widget instanceof ITooltipProvider)) continue;
            ((ITooltipProvider)widget).addTooltip(mouseX, mouseY, curTooltip, shiftPressed);
        }
    }

    private boolean mouseIsHoveringOverIcon(double x, double y) {
        if (this.leftSided) {
            return x <= (double)this.x && x >= (double)(this.x - 16) && y >= (double)this.affectedY && y <= (double)(this.affectedY + 16);
        }
        return x >= (double)this.x && x <= (double)(this.x + 16) && y >= (double)this.affectedY && y <= (double)(this.affectedY + 16);
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public void setTexture(ResourceLocation texture) {
        this.statIcon = StatIcon.of(texture);
    }

    public void setTexture(ItemStack itemStack) {
        this.statIcon = StatIcon.of(itemStack);
    }

    public static class StatIcon {
        public static final StatIcon NONE = new StatIcon(ItemStack.field_190927_a, null);
        private final ItemStack stack;
        private final ResourceLocation texture;

        private StatIcon(ItemStack stack, ResourceLocation texture) {
            this.stack = stack;
            this.texture = texture;
        }

        public static StatIcon of(ItemStack stack) {
            return new StatIcon(stack, null);
        }

        public static StatIcon of(Item item) {
            return new StatIcon(new ItemStack((IItemProvider)item, 1), null);
        }

        public static StatIcon of(ResourceLocation texture) {
            return new StatIcon(ItemStack.field_190927_a, texture);
        }

        void render(int x, int y, boolean leftSided) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            if (this.texture != null) {
                GuiUtils.drawTexture(this.texture, x - (leftSided ? 16 : 0), y);
            } else if (!this.stack.func_190926_b()) {
                GuiUtils.drawItemStack(this.stack, x - (leftSided ? 16 : 0), y);
            }
            GlStateManager.disableBlend();
        }
    }
}

