/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.widget.ITaggedWidget;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class WidgetButtonExtended
extends GuiButtonExt
implements ITaggedWidget,
ITooltipProvider {
    private ItemStack[] renderedStacks;
    private ResourceLocation resLoc;
    private List<String> tooltipText = new ArrayList<String>();
    private final ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
    private int invisibleHoverColor;
    private boolean thisVisible = true;
    private IconPosition iconPosition = IconPosition.MIDDLE;
    private String tag = null;

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, String buttonText, Button.IPressable pressable) {
        super(startX, startY, xSize, ySize, buttonText, pressable);
    }

    public WidgetButtonExtended(int startX, int startY, int xSize, int ySize, String buttonText) {
        this(startX, startY, xSize, ySize, buttonText, b -> {});
    }

    public WidgetButtonExtended withTag(String tag) {
        this.tag = tag;
        return this;
    }

    public void onPress() {
        super.onPress();
        if (this.tag != null && !this.tag.isEmpty()) {
            NetworkHandler.sendToServer(new PacketGuiButton(this.tag, ClientUtils.hasShiftDown()));
        }
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    public WidgetButtonExtended setVisible(boolean visible) {
        this.thisVisible = visible;
        return this;
    }

    public WidgetButtonExtended setInvisibleHoverColor(int color) {
        this.invisibleHoverColor = color;
        return this;
    }

    public WidgetButtonExtended setIconPosition(IconPosition iconPosition) {
        this.iconPosition = iconPosition;
        return this;
    }

    public WidgetButtonExtended setRenderStacks(ItemStack ... renderedStacks) {
        this.renderedStacks = renderedStacks;
        return this;
    }

    public WidgetButtonExtended setRenderedIcon(ResourceLocation resLoc) {
        this.resLoc = resLoc;
        return this;
    }

    public WidgetButtonExtended setTooltipText(List<String> tooltip) {
        this.tooltipText.clear();
        this.tooltipText.addAll(tooltip);
        return this;
    }

    public WidgetButtonExtended setTooltipText(String tooltip) {
        this.tooltipText.clear();
        if (tooltip != null && !tooltip.equals("")) {
            this.tooltipText.add(tooltip);
        }
        return this;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shift) {
        if (this.tooltipText != null) {
            curTip.addAll(this.tooltipText);
        }
    }

    public String getTooltip() {
        return this.tooltipText.size() > 0 ? this.tooltipText.get(0) : "";
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void renderButton(int x, int y, float partialTicks) {
        if (this.thisVisible) {
            super.renderButton(x, y, partialTicks);
        }
        if (this.visible) {
            if (this.renderedStacks != null) {
                int startX = this.getIconX();
                GlStateManager.enableRescaleNormal();
                RenderHelper.func_74520_c();
                for (int i = 0; i < this.renderedStacks.length; ++i) {
                    this.itemRenderer.func_180450_b(this.renderedStacks[i], startX + i * 18, this.y + 2);
                }
                RenderHelper.func_74518_a();
                GlStateManager.disableRescaleNormal();
            }
            if (this.resLoc != null) {
                GuiUtils.drawTexture(this.resLoc, this.x + this.width / 2 - 8, this.y + 2);
            }
            if (this.active && !this.thisVisible && x >= this.x && y >= this.y && x < this.x + this.width && y < this.y + this.height) {
                AbstractGui.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.invisibleHoverColor);
            }
        }
    }

    private int getIconX() {
        switch (this.iconPosition) {
            case LEFT: {
                return this.x - 1 - 18 * this.renderedStacks.length;
            }
            case RIGHT: {
                return this.x + this.width + 1;
            }
        }
        return this.x + this.width / 2 - this.renderedStacks.length * 9 + 1;
    }

    public static enum IconPosition {
        MIDDLE,
        LEFT,
        RIGHT;

    }
}

