/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.DyeColor;

public class WidgetColorSelector
extends WidgetButtonExtended {
    private boolean expanded = false;
    private DyeColor color = DyeColor.WHITE;
    private final Rectangle2d mainArea;
    private final Rectangle2d expandedArea;
    private final Consumer<WidgetColorSelector> callback;

    public WidgetColorSelector(int xIn, int yIn) {
        this(xIn, yIn, null);
    }

    public WidgetColorSelector(int xIn, int yIn, Consumer<WidgetColorSelector> callback) {
        super(xIn, yIn, 16, 16, "");
        this.mainArea = new Rectangle2d(xIn, yIn, this.width, this.height);
        this.expandedArea = new Rectangle2d(xIn, yIn + this.height, this.width * 4, this.height * 4);
        this.callback = callback;
    }

    public WidgetColorSelector withInitialColor(DyeColor color) {
        this.color = color;
        return this;
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTick) {
        super.renderButton(mouseX, mouseY, partialTick);
        WidgetColorSelector.fill((int)(this.x + 3), (int)(this.y + 3), (int)(this.x + this.width - 4), (int)(this.y + this.height - 4), (int)(0xFF000000 | this.color.getColorValue()));
        this.hLine(this.x + 3, this.x + this.width - 3, this.y + this.height - 4, -10461088);
        this.vLine(this.x + this.width - 4, this.y + 3, this.y + this.height - 3, -10461088);
        if (this.expanded) {
            GlStateManager.translated((double)0.0, (double)0.0, (double)300.0);
            WidgetColorSelector.fill((int)this.x, (int)(this.y - 1 + this.height), (int)(this.x + this.width * 4), (int)(this.y - 1 + this.height * 5), (int)-16777216);
            WidgetColorSelector.fill((int)(this.x + 1), (int)(this.y + this.height), (int)(this.x + this.width * 4 - 1), (int)(this.y - 2 + this.height * 5), (int)-8355712);
            for (DyeColor color : DyeColor.values()) {
                int dx = this.x + color.func_196059_a() % 4 * 16;
                int dy = this.y - 1 + this.height + color.func_196059_a() / 4 * 16;
                WidgetColorSelector.fill((int)(dx + 3), (int)(dy + 3), (int)(dx + 13), (int)(dy + 13), (int)(0xFF000000 | color.getColorValue()));
                this.hLine(dx + 3, dx + 13, dy + 13, -10461088);
                this.vLine(dx + 13, dy + 3, dy + 13, -10461088);
            }
            GlStateManager.translated((double)0.0, (double)0.0, (double)-300.0);
        }
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return super.clicked(mouseX, mouseY) || this.expanded && this.expandedArea.func_199315_b((int)mouseX, (int)mouseY);
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.mainArea.func_199315_b((int)mouseX, (int)mouseY)) {
            this.expanded = !this.expanded;
        } else if (this.expandedArea.func_199315_b((int)mouseX, (int)mouseY)) {
            int dx = (int)mouseX - this.expandedArea.func_199318_a();
            int dy = (int)mouseY - this.expandedArea.func_199319_b();
            int id = dx / 16 + dy / 16 * 4;
            this.color = DyeColor.func_196056_a((int)id);
            boolean bl = this.expanded = !this.expanded;
            if (this.callback != null) {
                this.callback.accept(this);
            }
        }
    }
}

