/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;

public class WidgetLabel
extends Widget
implements ITooltipProvider {
    private float scale = 1.0f;
    private int color;
    private Alignment alignment = Alignment.LEFT;
    private final List<String> tooltip = new ArrayList<String>();

    public WidgetLabel(int x, int y, String text) {
        this(x, y, text, -12566464);
    }

    public WidgetLabel(int x, int y, String text, int color) {
        super(x, y, 0, 0, text);
        this.color = color;
        this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.getMessage());
        Minecraft.func_71410_x().field_71466_p.getClass();
        this.height = 9;
    }

    public WidgetLabel setAlignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public WidgetLabel setScale(float scale) {
        this.scale = scale;
        return this;
    }

    protected boolean clicked(double mouseX, double mouseY) {
        switch (this.alignment) {
            case LEFT: {
                return super.clicked(mouseX, mouseY);
            }
            case CENTRE: {
                return super.clicked(mouseX + (double)this.width / 2.0, mouseY);
            }
            case RIGHT: {
                return super.clicked(mouseX + (double)this.width, mouseY);
            }
        }
        return false;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shift) {
        curTip.addAll(this.tooltip);
    }

    public <T extends WidgetLabel> T setTooltipText(String text) {
        this.tooltip.clear();
        if (!text.isEmpty()) {
            this.tooltip.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)text, (Object[])new Object[0]), 35));
        }
        return (T)this;
    }

    public String getTooltip() {
        return this.tooltip.isEmpty() ? "" : this.tooltip.get(0);
    }

    public WidgetLabel setColor(int color) {
        this.color = color;
        return this;
    }

    public void setMessage(String p_setMessage_1_) {
        super.setMessage(p_setMessage_1_);
        this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.getMessage());
    }

    public void renderButton(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            int drawX;
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            switch (this.alignment) {
                default: {
                    drawX = this.x;
                    break;
                }
                case CENTRE: {
                    drawX = this.x - (int)((float)(this.width / 2) * this.scale);
                    break;
                }
                case RIGHT: {
                    drawX = this.x - (int)((float)this.width * this.scale);
                }
            }
            if (this.scale != 1.0f) {
                GlStateManager.pushMatrix();
                GlStateManager.scaled((double)this.scale, (double)this.scale, (double)this.scale);
                GlStateManager.translated((double)drawX, (double)this.y, (double)0.0);
                fr.func_211126_b(this.getMessage(), (float)drawX, (float)this.y, this.color);
                GlStateManager.popMatrix();
            } else {
                fr.func_211126_b(this.getMessage(), (float)drawX, (float)this.y, this.color);
            }
        }
    }

    public static enum Alignment {
        LEFT,
        CENTRE,
        RIGHT;

    }
}

