/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.Validate;

public class WidgetRadioButton
extends Widget
implements ITooltipProvider {
    private static final int BUTTON_WIDTH = 10;
    private static final int BUTTON_HEIGHT = 10;
    public boolean checked;
    public boolean enabled = true;
    public final int color;
    private final Consumer<WidgetRadioButton> pressable;
    private final FontRenderer fontRenderer;
    private List<String> tooltip;
    public List<WidgetRadioButton> otherChoices;

    public WidgetRadioButton(int x, int y, int color, String text, Consumer<WidgetRadioButton> pressable) {
        super(x, y, text);
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.tooltip = new ArrayList<String>();
        this.width = 10 + this.fontRenderer.func_78256_a(this.getMessage());
        this.height = 10;
        this.color = color;
        this.pressable = pressable;
    }

    public WidgetRadioButton(int x, int y, int color, String text) {
        this(x, y, color, text, null);
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        this.drawCircle(this.x + 5, this.y + 5, 5, this.enabled ? -6250336 : -6710887);
        this.drawCircle(this.x + 5, this.y + 5, 4, this.enabled ? -14671840 : -5592406);
        if (this.checked) {
            this.drawCircle(this.x + 5, this.y + 5, 1, this.enabled ? -1 : -5592406);
        }
        String string = I18n.func_135052_a((String)this.getMessage(), (Object[])new Object[0]);
        float f = this.x + 1 + 10;
        float f2 = (float)this.y + 5.0f;
        this.fontRenderer.getClass();
        this.fontRenderer.func_211126_b(string, f, f2 - 9.0f / 2.0f, this.enabled ? this.color : -7829368);
    }

    private void drawCircle(int x, int y, int radius, int color) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.enableBlend();
        GlStateManager.disableTexture();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.color4f((float)f1, (float)f2, (float)f3, (float)f);
        wr.func_181668_a(6, DefaultVertexFormats.field_181705_e);
        int points = 12;
        for (int i = 0; i < points; ++i) {
            double sin = Math.sin((double)i / (double)points * Math.PI * 2.0);
            double cos = Math.cos((double)i / (double)points * Math.PI * 2.0);
            wr.func_181662_b((double)x + sin * (double)radius, (double)y + cos * (double)radius, 0.0).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
    }

    public Rectangle2d getBounds() {
        return new Rectangle2d(this.x, this.y, 10 + this.fontRenderer.func_78256_a(this.getMessage()), 10);
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.enabled) {
            Validate.notNull(this.otherChoices, (String)"A radio button needs more than one choice! You need to set the GuiRadioButton#otherChoices field!", (Object[])new Object[0]);
            for (WidgetRadioButton radioButton : this.otherChoices) {
                radioButton.checked = false;
            }
            this.checked = true;
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
        }
    }

    public void setTooltip(String tooltip) {
        this.setTooltip(Collections.singletonList(tooltip));
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTooltip, boolean shiftPressed) {
        curTooltip.addAll(this.tooltip);
    }
}

