/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.LazyOptional;

public class WidgetTemperature
extends Widget
implements ITooltipProvider {
    private int[] scales;
    protected final LazyOptional<IHeatExchangerLogic> logic;
    private final int minTemp;
    private final int maxTemp;

    public WidgetTemperature(int x, int y, int minTemp, int maxTemp, LazyOptional<IHeatExchangerLogic> logic, int ... scales) {
        super(x, y, 13, 50, "");
        this.scales = scales;
        this.logic = logic;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp - 273;
    }

    public void setScales(int ... scales) {
        this.scales = scales;
    }

    public int[] getScales() {
        return this.scales;
    }

    public void setTemperature(double temp) {
        this.logic.ifPresent(h -> h.setTemperature(temp));
    }

    public void renderButton(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            GlStateManager.disableLighting();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.WIDGET_TEMPERATURE);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AbstractGui.blit((int)(this.x + 6), (int)this.y, (float)6.0f, (float)0.0f, (int)7, (int)50, (int)18, (int)50);
            int h = this.height - 2;
            int temp = (Integer)this.logic.map(IHeatExchangerLogic::getTemperatureAsInt).orElseThrow(RuntimeException::new);
            int barLength = (temp - this.minTemp) * h / this.maxTemp;
            barLength = MathHelper.func_76125_a((int)barLength, (int)0, (int)h);
            AbstractGui.blit((int)(this.x + 7), (int)(this.y + 1 + h - barLength), (float)13.0f, (float)(h - barLength), (int)5, (int)barLength, (int)18, (int)50);
            for (int scale : this.scales) {
                if (scale == 0) continue;
                int scaleY = h - (scale - this.minTemp) * h / this.maxTemp;
                int v = scaleY < 0 ? 6 : (scaleY > 48 ? 12 : 0);
                AbstractGui.blit((int)this.x, (int)(this.y - 1 + MathHelper.func_76125_a((int)scaleY, (int)0, (int)h)), (float)0.0f, (float)v, (int)6, (int)6, (int)18, (int)50);
            }
        }
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shift) {
        int temp = (Integer)this.logic.map(IHeatExchangerLogic::getTemperatureAsInt).orElseThrow(RuntimeException::new);
        curTip.add(HeatUtil.formatHeatString(temp).func_150254_d());
    }
}

