/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.Validate;

public class WidgetVerticalScrollbar
extends Widget {
    public float currentScroll;
    private int states;
    private boolean listening;
    private boolean dragging;

    public WidgetVerticalScrollbar(int x, int y, int height) {
        super(x, y, 14, height, "");
    }

    public WidgetVerticalScrollbar setStates(int states) {
        this.states = states;
        return this;
    }

    public WidgetVerticalScrollbar setCurrentState(int state) {
        Validate.isTrue((state >= 0 && state <= this.states ? 1 : 0) != 0, (String)("State " + state + " out of range! Valid range [1 - " + this.states + "] inclusive"), (Object[])new Object[0]);
        this.currentScroll = (float)state / (float)this.states;
        return this;
    }

    public boolean mouseScrolled(double x, double y, double dir) {
        if (this.active && this.listening) {
            double wheel = MathHelper.func_151237_a((double)(-dir), (double)-1.0, (double)1.0);
            this.currentScroll = MathHelper.func_76131_a((float)(this.currentScroll + (float)wheel / (float)this.states), (float)0.0f, (float)1.0f);
            return true;
        }
        return false;
    }

    public void onClick(double x, double y) {
        this.currentScroll = (float)(y - 7.0 - (double)this.y) / (float)(this.height - 17);
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        this.dragging = true;
    }

    public void onRelease(double x, double y) {
        this.dragging = false;
    }

    protected void onDrag(double x, double y, double dx, double dy) {
        this.dragging = true;
        this.currentScroll = (float)(y - 7.0 - (double)this.y) / (float)(this.height - 17);
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
    }

    public WidgetVerticalScrollbar setListening(boolean listening) {
        this.listening = listening;
        return this;
    }

    public int getState() {
        float scroll = this.currentScroll;
        return MathHelper.func_76125_a((int)((int)((scroll += 0.5f / (float)this.states) * (float)this.states)), (int)0, (int)this.states);
    }

    public void renderButton(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.WIDGET_VERTICAL_SCROLLBAR);
            WidgetVerticalScrollbar.blit((int)this.x, (int)this.y, (float)12.0f, (float)0.0f, (int)this.width, (int)1, (int)26, (int)15);
            for (int i = 0; i < this.height - 2; ++i) {
                WidgetVerticalScrollbar.blit((int)this.x, (int)(this.y + 1 + i), (float)12.0f, (float)1.0f, (int)this.width, (int)1, (int)26, (int)15);
            }
            WidgetVerticalScrollbar.blit((int)this.x, (int)(this.y + this.height - 1), (float)12.0f, (float)14.0f, (int)this.width, (int)1, (int)26, (int)15);
            if (!this.active) {
                GlStateManager.color4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
            }
            WidgetVerticalScrollbar.blit((int)(this.x + 1), (int)(this.y + 1 + (int)((float)(this.height - 17) * this.currentScroll)), (float)0.0f, (float)0.0f, (int)12, (int)15, (int)26, (int)15);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public boolean isDragging() {
        return this.dragging;
    }
}

