/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model.custom;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.render.fluid.FluidItemRenderInfoProvider;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.common.item.IFluidRendered;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fluids.IFluidTank;

public class FluidItemModel
implements IDynamicBakedModel {
    private final IBakedModel bakedBaseModel;
    private final ItemOverrideList overrideList = new FluidOverridesList(this);
    private final VertexFormat format;
    private List<TankRenderInfo> tanksToRender;

    private FluidItemModel(VertexFormat format, IBakedModel bakedBaseModel) {
        this.format = format;
        this.bakedBaseModel = bakedBaseModel;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> res = new ArrayList<BakedQuad>(this.bakedBaseModel.getQuads(state, side, rand, extraData));
        if (this.tanksToRender != null) {
            for (TankRenderInfo info : this.tanksToRender) {
                ImmutableList vecs;
                IFluidTank tank = info.getTank();
                if (tank.getFluid().isEmpty()) continue;
                Fluid f = tank.getFluid().getFluid();
                TextureAtlasSprite still = Minecraft.func_71410_x().func_147117_R().func_110572_b(f.getAttributes().getStill(tank.getFluid()).toString());
                int color = f.getAttributes().getColor(tank.getFluid());
                float[] cols = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
                AxisAlignedBB bounds = this.getRenderBounds(tank, info.getBounds());
                float bx1 = (float)(bounds.field_72340_a * 16.0);
                float bx2 = (float)(bounds.field_72336_d * 16.0);
                float by1 = (float)(bounds.field_72338_b * 16.0);
                float by2 = (float)(bounds.field_72337_e * 16.0);
                float bz1 = (float)(bounds.field_72339_c * 16.0);
                float bz2 = (float)(bounds.field_72334_f * 16.0);
                if (info.shouldRender(Direction.DOWN)) {
                    vecs = ImmutableList.of((Object)new Vec3d(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c), (Object)new Vec3d(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f), (Object)new Vec3d(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f), (Object)new Vec3d(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c));
                    res.add(this.createQuad((List<Vec3d>)vecs, cols, still, Direction.DOWN, bx1, bx2, bz1, bz2));
                }
                if (info.shouldRender(Direction.UP)) {
                    vecs = ImmutableList.of((Object)new Vec3d(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c), (Object)new Vec3d(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f), (Object)new Vec3d(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f), (Object)new Vec3d(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c));
                    res.add(this.createQuad((List<Vec3d>)vecs, cols, still, Direction.UP, bx1, bx2, bz1, bz2));
                }
                if (info.shouldRender(Direction.NORTH)) {
                    vecs = ImmutableList.of((Object)new Vec3d(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c), (Object)new Vec3d(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c), (Object)new Vec3d(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c), (Object)new Vec3d(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c));
                    res.add(this.createQuad((List<Vec3d>)vecs, cols, still, Direction.NORTH, bx1, bx2, by1, by2));
                }
                if (info.shouldRender(Direction.SOUTH)) {
                    vecs = ImmutableList.of((Object)new Vec3d(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f), (Object)new Vec3d(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f), (Object)new Vec3d(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f), (Object)new Vec3d(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f));
                    res.add(this.createQuad((List<Vec3d>)vecs, cols, still, Direction.SOUTH, bx1, bx2, by1, by2));
                }
                if (info.shouldRender(Direction.WEST)) {
                    vecs = ImmutableList.of((Object)new Vec3d(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c), (Object)new Vec3d(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c), (Object)new Vec3d(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f), (Object)new Vec3d(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f));
                    res.add(this.createQuad((List<Vec3d>)vecs, cols, still, Direction.WEST, bz1, bz2, by1, by2));
                }
                if (!info.shouldRender(Direction.EAST)) continue;
                vecs = ImmutableList.of((Object)new Vec3d(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f), (Object)new Vec3d(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f), (Object)new Vec3d(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c), (Object)new Vec3d(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c));
                res.add(this.createQuad((List<Vec3d>)vecs, cols, still, Direction.EAST, bz1, bz2, by1, by2));
            }
        }
        return res;
    }

    private AxisAlignedBB getRenderBounds(IFluidTank tank, AxisAlignedBB tankBounds) {
        float percent = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double tankHeight = tankBounds.field_72337_e - tankBounds.field_72338_b;
        double y1 = tankBounds.field_72338_b;
        double y2 = tankBounds.field_72338_b + tankHeight * (double)percent;
        if (tank.getFluid().getFluid().getAttributes().getDensity() < 0) {
            double yOff = tankBounds.field_72337_e - y2;
            y1 += yOff;
            y2 += yOff;
        }
        return new AxisAlignedBB(tankBounds.field_72340_a, y1, tankBounds.field_72339_c, tankBounds.field_72336_d, y2, tankBounds.field_72334_f);
    }

    private BakedQuad createQuad(List<Vec3d> vecs, float[] cols, TextureAtlasSprite sprite, Direction face, float u1, float u2, float v1, float v2) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(sprite);
        Vec3d normal = new Vec3d(face.func_176730_m());
        this.putVertex(builder, cols, normal, vecs.get((int)0).field_72450_a, vecs.get((int)0).field_72448_b, vecs.get((int)0).field_72449_c, sprite, u1, v1);
        this.putVertex(builder, cols, normal, vecs.get((int)1).field_72450_a, vecs.get((int)1).field_72448_b, vecs.get((int)1).field_72449_c, sprite, u1, v2);
        this.putVertex(builder, cols, normal, vecs.get((int)2).field_72450_a, vecs.get((int)2).field_72448_b, vecs.get((int)2).field_72449_c, sprite, u2, v2);
        this.putVertex(builder, cols, normal, vecs.get((int)3).field_72450_a, vecs.get((int)3).field_72448_b, vecs.get((int)3).field_72449_c, sprite, u2, v1);
        builder.setQuadOrientation(face);
        return builder.build();
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, float[] cols, Vec3d normal, double x, double y, double z, TextureAtlasSprite sprite, float u, float v) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{cols[1], cols[2], cols[3], cols[0]});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        u = sprite.func_94214_a((double)u);
                        v = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public boolean func_177555_b() {
        return this.bakedBaseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedBaseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.bakedBaseModel.func_188618_c();
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        return this.bakedBaseModel.getParticleTexture(data);
    }

    public TextureAtlasSprite func_177554_e() {
        return this.bakedBaseModel.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    private class FluidOverridesList
    extends ItemOverrideList {
        private final FluidItemModel modelIn;

        FluidOverridesList(FluidItemModel modelIn) {
            this.modelIn = modelIn;
        }

        @Nullable
        public IBakedModel func_209581_a(IBakedModel original, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
            if (stack.func_77973_b() instanceof IFluidRendered) {
                FluidItemRenderInfoProvider infoProvider = ((IFluidRendered)stack.func_77973_b()).getFluidItemRenderer();
                this.modelIn.tanksToRender = infoProvider.getTanksToRender(stack);
            }
            return this.modelIn;
        }
    }

    public static enum Loader implements IModelLoader<Geometry>
    {
        INSTANCE;


        public void func_195410_a(IResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)modelContents, (String)"base_model"), BlockModel.class);
            return new Geometry(baseModel);
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry> {
        private final BlockModel baseModel;

        Geometry(BlockModel baseModel) {
            this.baseModel = baseModel;
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format, ItemOverrideList overrides) {
            return new FluidItemModel(format, this.baseModel.bake(bakery, spriteGetter, sprite, format));
        }

        public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
            return this.baseModel.func_209559_a(modelGetter, missingTextureErrors);
        }
    }
}

