/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model.custom;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberGlass;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class PressureGlassModel
implements IDynamicBakedModel {
    private static final int TEXTURE_COUNT = 47;
    private static final TextureAtlasSprite[] SPRITE_CACHE = new TextureAtlasSprite[47];
    private final VertexFormat format;
    private final Function<ResourceLocation, TextureAtlasSprite> spriteGetter;
    private static final BakedQuad[][] QUAD_CACHE = new BakedQuad[6][];
    private static final List<List<Vec3d>> VECS;

    private PressureGlassModel(VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> spriteGetter) {
        this.format = format;
        this.spriteGetter = spriteGetter;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side == null || extraData == EmptyModelData.INSTANCE) {
            return Collections.emptyList();
        }
        ModelProperty<Integer> prop = TileEntityPressureChamberGlass.DIR_PROPS.get(side.func_176745_a());
        int textureIndex = extraData.hasProperty(prop) ? (Integer)extraData.getData(TileEntityPressureChamberGlass.DIR_PROPS.get(side.func_176745_a())) : 0;
        return Collections.singletonList(this.getCachedQuad(textureIndex, side));
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getSprite(0);
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, Vec3d normal, double x, double y, double z, TextureAtlasSprite sprite, float u, float v) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        u = sprite.func_94214_a((double)u);
                        v = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private BakedQuad getCachedQuad(int textureIndex, Direction side) {
        if (QUAD_CACHE[side.func_176745_a()][textureIndex] == null) {
            PressureGlassModel.QUAD_CACHE[side.func_176745_a()][textureIndex] = this.createQuad(VECS.get(side.func_176745_a()), this.getSprite(textureIndex), side);
        }
        return QUAD_CACHE[side.func_176745_a()][textureIndex];
    }

    private TextureAtlasSprite getSprite(int textureIndex) {
        if (SPRITE_CACHE[textureIndex] == null) {
            PressureGlassModel.SPRITE_CACHE[textureIndex] = this.spriteGetter.apply(new ResourceLocation("pneumaticcraft:block/pressure_chamber/windows/window_" + (textureIndex + 1)));
        }
        return SPRITE_CACHE[textureIndex];
    }

    private BakedQuad createQuad(List<Vec3d> vecs, TextureAtlasSprite sprite, Direction face) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(sprite);
        Vec3d normal = new Vec3d(face.func_176730_m());
        this.putVertex(builder, normal, vecs.get((int)0).field_72450_a, vecs.get((int)0).field_72448_b, vecs.get((int)0).field_72449_c, sprite, 0.0f, 0.0f);
        this.putVertex(builder, normal, vecs.get((int)1).field_72450_a, vecs.get((int)1).field_72448_b, vecs.get((int)1).field_72449_c, sprite, 0.0f, 16.0f);
        this.putVertex(builder, normal, vecs.get((int)2).field_72450_a, vecs.get((int)2).field_72448_b, vecs.get((int)2).field_72449_c, sprite, 16.0f, 16.0f);
        this.putVertex(builder, normal, vecs.get((int)3).field_72450_a, vecs.get((int)3).field_72448_b, vecs.get((int)3).field_72449_c, sprite, 16.0f, 0.0f);
        builder.setQuadOrientation(face);
        return builder.build();
    }

    static {
        for (int i = 0; i < 6; ++i) {
            PressureGlassModel.QUAD_CACHE[i] = new BakedQuad[47];
        }
        VECS = new ArrayList<List<Vec3d>>();
        VECS.add((List<Vec3d>)ImmutableList.of((Object)new Vec3d(1.0, 0.0, 0.0), (Object)new Vec3d(1.0, 0.0, 1.0), (Object)new Vec3d(0.0, 0.0, 1.0), (Object)new Vec3d(0.0, 0.0, 0.0)));
        VECS.add((List<Vec3d>)ImmutableList.of((Object)new Vec3d(0.0, 1.0, 0.0), (Object)new Vec3d(0.0, 1.0, 1.0), (Object)new Vec3d(1.0, 1.0, 1.0), (Object)new Vec3d(1.0, 1.0, 0.0)));
        VECS.add((List<Vec3d>)ImmutableList.of((Object)new Vec3d(1.0, 1.0, 0.0), (Object)new Vec3d(1.0, 0.0, 0.0), (Object)new Vec3d(0.0, 0.0, 0.0), (Object)new Vec3d(0.0, 1.0, 0.0)));
        VECS.add((List<Vec3d>)ImmutableList.of((Object)new Vec3d(0.0, 1.0, 1.0), (Object)new Vec3d(0.0, 0.0, 1.0), (Object)new Vec3d(1.0, 0.0, 1.0), (Object)new Vec3d(1.0, 1.0, 1.0)));
        VECS.add((List<Vec3d>)ImmutableList.of((Object)new Vec3d(0.0, 1.0, 0.0), (Object)new Vec3d(0.0, 0.0, 0.0), (Object)new Vec3d(0.0, 0.0, 1.0), (Object)new Vec3d(0.0, 1.0, 1.0)));
        VECS.add((List<Vec3d>)ImmutableList.of((Object)new Vec3d(1.0, 1.0, 1.0), (Object)new Vec3d(1.0, 0.0, 1.0), (Object)new Vec3d(1.0, 0.0, 0.0), (Object)new Vec3d(1.0, 1.0, 0.0)));
    }

    private static class Geometry
    implements IModelGeometry<Geometry> {
        private Geometry() {
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format, ItemOverrideList overrides) {
            return new PressureGlassModel(format, spriteGetter);
        }

        public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
            ArrayList<ResourceLocation> res = new ArrayList<ResourceLocation>();
            for (int i = 0; i < 47; ++i) {
                res.add(new ResourceLocation("pneumaticcraft:block/pressure_chamber/windows/window_" + (i + 1)));
            }
            return res;
        }
    }

    public static enum Loader implements IModelLoader<Geometry>
    {
        INSTANCE;


        public void func_195410_a(IResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new Geometry();
        }
    }
}

