/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.entity.living.EntityDroneBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public class RenderLaser {
    public void render(float partialTicks, EntityDroneBase drone, double x1, double y1, double z1, double x2, double y2, double z2) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        double laserLength = PneumaticCraftUtils.distBetween(x1, y1, z1, x2, y2, z2);
        double laserSize = 0.4;
        GlStateManager.disableLighting();
        GlStateManager.disableCull();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.translated((double)x1, (double)y1, (double)z1);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        float f3 = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double rotYaw = Math.atan2(dx, dz) * 180.0 / Math.PI;
        double rotPitch = 90.0f - (float)(Math.atan2(dy, f3) * 180.0 / Math.PI);
        GlStateManager.rotated((double)((float)rotYaw), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)((float)rotPitch), (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.scaled((double)laserSize, (double)laserSize, (double)laserSize);
        GlStateManager.translated((double)0.0, (double)0.6, (double)0.0);
        GlStateManager.rotated((double)(((float)drone.field_70173_aa + partialTicks) * 200.0f), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.pushMatrix();
        GlStateManager.scaled((double)1.0, (double)(laserLength / laserSize), (double)1.0);
        textureManager.func_110577_a(Textures.RENDER_LASER);
        this.renderQuad(drone.getLaserColor());
        textureManager.func_110577_a(Textures.RENDER_LASER_OVERLAY);
        this.renderQuad(drone.getLaserColor());
        GlStateManager.popMatrix();
        GlStateManager.rotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        textureManager.func_110577_a(Textures.RENDER_LASER_START);
        this.renderQuad(drone.getLaserColor());
        textureManager.func_110577_a(Textures.RENDER_LASER_START_OVERLAY);
        this.renderQuad(drone.getLaserColor());
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
        GlStateManager.enableLighting();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderQuad(int color) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderUtils.glColorHex(color);
        wr.func_181662_b(-0.5, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        wr.func_181662_b(-0.5, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        wr.func_181662_b(0.5, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        wr.func_181662_b(0.5, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

