/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import me.desht.pneumaticcraft.client.render.RenderProgressingLine;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public enum RenderMinigunTracers {
    INSTANCE;


    public static RenderMinigunTracers instance() {
        return INSTANCE;
    }

    public boolean shouldRender(Minigun minigun) {
        return minigun.isMinigunActivated() && minigun.getMinigunSpeed() == 0.4 && minigun.isGunAimedAtTarget() && minigun.getAttackTarget() != null;
    }

    public void render(Minigun minigun, double x, double y, double z, double gunRadius) {
        LivingEntity attackTarget = minigun.getAttackTarget();
        if (this.shouldRender(minigun)) {
            GlStateManager.pushMatrix();
            GlStateManager.scaled((double)1.0, (double)1.0, (double)1.0);
            GlStateManager.translated((double)(-x), (double)(-y), (double)(-z));
            GlStateManager.disableTexture();
            GL11.glEnable((int)2852);
            RenderUtils.glColorHex(0xFF000000 | minigun.getAmmoColor());
            Vec3d vec = new Vec3d(attackTarget.field_70165_t - x, attackTarget.field_70163_u - y, attackTarget.field_70161_v - z).func_72432_b();
            RenderProgressingLine minigunFire = new RenderProgressingLine().setProgress(1.0f);
            Random rand = attackTarget.func_130014_f_().field_73012_v;
            minigunFire.startX = x + vec.field_72450_a * gunRadius;
            minigunFire.startY = y + vec.field_72448_b * gunRadius;
            minigunFire.startZ = z + vec.field_72449_c * gunRadius;
            for (int i = 0; i < 5; ++i) {
                int stipple = 0xFFFF & ~(2 << rand.nextInt(16));
                GL11.glLineStipple((int)4, (short)((short)stipple));
                minigunFire.endX = attackTarget.field_70165_t + rand.nextDouble() * 0.8 - 0.4;
                minigunFire.endY = attackTarget.field_70163_u + (double)(attackTarget.func_213302_cg() / 2.0f) + rand.nextDouble() * 0.8 - 0.4;
                minigunFire.endZ = attackTarget.field_70161_v + rand.nextDouble() * 0.8 - 0.4;
                minigunFire.render();
            }
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2852);
            GlStateManager.enableTexture();
            GlStateManager.popMatrix();
        }
    }
}

