/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import me.desht.pneumaticcraft.client.gui.GuiSecurityStationBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RenderProgressingLine {
    public double startX;
    public double startY;
    public double startZ;
    public double endX;
    public double endY;
    public double endZ;
    protected float progress = 0.0f;

    public RenderProgressingLine() {
    }

    public RenderProgressingLine(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
    }

    public RenderProgressingLine(double startX, double startY, double endX, double endY) {
        this(startX, startY, 0.0, endX, endY, 0.0);
    }

    public RenderProgressingLine(RenderProgressingLine copy) {
        this(copy.startX, copy.startY, copy.startZ, copy.endX, copy.endY, copy.endZ);
        this.progress = copy.progress;
    }

    public boolean hasLineSameProperties(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        return Math.abs(startX - this.startX) < 0.01 && Math.abs(startY - this.startY) < 0.01 && Math.abs(startZ - this.startZ) < 0.01 && Math.abs(endX - this.endX) < 0.01 && Math.abs(endY - this.endY) < 0.01 && Math.abs(endZ - this.endZ) < 0.01;
    }

    public float getProgress() {
        return this.progress;
    }

    public RenderProgressingLine setProgress(float progress) {
        this.progress = progress;
        return this;
    }

    public boolean incProgress(float increment) {
        this.progress += increment;
        if (this.progress > 1.0f) {
            this.progress = 1.0f;
            return true;
        }
        if (this.progress < 0.0f) {
            this.progress = 0.0f;
            return true;
        }
        return false;
    }

    public boolean incProgressByDistance(double distance) {
        double totalDistance = Math.sqrt(Math.pow(this.endX - this.startX, 2.0) + Math.pow(this.endY - this.startY, 2.0) + Math.pow(this.endZ - this.startZ, 2.0));
        this.progress = (float)((double)this.progress + distance / totalDistance);
        if (this.progress > 1.0f) {
            this.progress = 1.0f;
            return true;
        }
        if (this.progress < 0.0f) {
            this.progress = 0.0f;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render() {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        wr.func_181662_b(this.startX, this.startY, this.startZ).func_181675_d();
        wr.func_181662_b(this.startX + (this.endX - this.startX) * (double)this.progress, this.startY + (this.endY - this.startY) * (double)this.progress, this.startZ + (this.endZ - this.startZ) * (double)this.progress).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInterpolated(RenderProgressingLine prev, float partialTick) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        wr.func_181662_b(MathHelper.func_219803_d((double)partialTick, (double)this.startX, (double)prev.startX), MathHelper.func_219803_d((double)partialTick, (double)this.startY, (double)prev.startY), MathHelper.func_219803_d((double)partialTick, (double)this.startZ, (double)prev.startZ)).func_181675_d();
        wr.func_181662_b(MathHelper.func_219803_d((double)partialTick, (double)this.startX, (double)prev.startX) + (MathHelper.func_219803_d((double)partialTick, (double)this.endX, (double)prev.endX) - MathHelper.func_219803_d((double)partialTick, (double)this.startX, (double)prev.startX)) * (double)this.progress, MathHelper.func_219803_d((double)partialTick, (double)this.startY, (double)prev.startY) + (MathHelper.func_219803_d((double)partialTick, (double)this.startY, (double)prev.startY) - MathHelper.func_219803_d((double)partialTick, (double)this.endY, (double)prev.endY)) * (double)this.progress, MathHelper.func_219803_d((double)partialTick, (double)this.startZ, (double)prev.startZ) + (MathHelper.func_219803_d((double)partialTick, (double)this.endZ, (double)prev.endZ) - MathHelper.func_219803_d((double)partialTick, (double)this.startZ, (double)prev.startZ)) * (double)this.progress).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public int getPointedSlotNumber(GuiSecurityStationBase gui) {
        Slot slot = gui.getSlotAtPosition((int)this.endX, (int)this.endY);
        return slot != null ? slot.field_75222_d : 0;
    }
}

