/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.desht.pneumaticcraft.client.render.RenderProgressingLine;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;

public class RenderRangeLines {
    private final List<RenderProgressingLine> rangeLines = new ArrayList<RenderProgressingLine>();
    private int rangeLinesTimer = 0;
    private final int color;
    private final BlockPos pos;

    public RenderRangeLines(int color) {
        this(color, null);
    }

    public RenderRangeLines(int color, BlockPos pos) {
        this.color = color;
        this.pos = pos;
    }

    public void resetRendering(double range) {
        this.rangeLinesTimer = 120;
        this.rangeLines.clear();
        double renderRange = range + 0.5;
        int i = 0;
        while ((double)i < range * 16.0 + 8.0) {
            this.rangeLines.add(new RenderProgressingLine(-renderRange + (double)i / 8.0, -renderRange + 1.0, -renderRange, -renderRange + (double)i / 8.0, renderRange + 1.0, -renderRange));
            this.rangeLines.add(new RenderProgressingLine(renderRange - (double)i / 8.0, -renderRange + 1.0, renderRange, renderRange - (double)i / 8.0, renderRange + 1.0, renderRange));
            this.rangeLines.add(new RenderProgressingLine(-renderRange, -renderRange + 1.0, renderRange - (double)i / 8.0, -renderRange, renderRange + 1.0, renderRange - (double)i / 8.0));
            this.rangeLines.add(new RenderProgressingLine(renderRange, -renderRange + 1.0, -renderRange + (double)i / 8.0, renderRange, renderRange + 1.0, -renderRange + (double)i / 8.0));
            this.rangeLines.add(new RenderProgressingLine(-renderRange, -renderRange + (double)i / 8.0 + 1.0, -renderRange, -renderRange, -renderRange + (double)i / 8.0 + 1.0, renderRange));
            this.rangeLines.add(new RenderProgressingLine(renderRange, -renderRange + (double)i / 8.0 + 1.0, -renderRange, renderRange, -renderRange + (double)i / 8.0 + 1.0, renderRange));
            this.rangeLines.add(new RenderProgressingLine(-renderRange, renderRange - (double)i / 8.0 + 1.0, -renderRange, renderRange, renderRange - (double)i / 8.0 + 1.0, -renderRange));
            this.rangeLines.add(new RenderProgressingLine(-renderRange, -renderRange + (double)i / 8.0 + 1.0, renderRange, renderRange, -renderRange + (double)i / 8.0 + 1.0, renderRange));
            this.rangeLines.add(new RenderProgressingLine(renderRange - (double)i / 8.0, -renderRange + 1.0, -renderRange, renderRange - (double)i / 8.0, -renderRange + 1.0, renderRange));
            this.rangeLines.add(new RenderProgressingLine(renderRange - (double)i / 8.0, renderRange + 1.0, -renderRange, renderRange - (double)i / 8.0, renderRange + 1.0, renderRange));
            this.rangeLines.add(new RenderProgressingLine(-renderRange, -renderRange + 1.0, -renderRange + (double)i / 8.0, renderRange, -renderRange + 1.0, -renderRange + (double)i / 8.0));
            this.rangeLines.add(new RenderProgressingLine(-renderRange, renderRange + 1.0, -renderRange + (double)i / 8.0, renderRange, renderRange + 1.0, -renderRange + (double)i / 8.0));
            ++i;
        }
    }

    public boolean isCurrentlyRendering() {
        return this.rangeLines.size() > 0;
    }

    public void update() {
        if (this.rangeLinesTimer > 0) {
            --this.rangeLinesTimer;
            for (RenderProgressingLine line : this.rangeLines) {
                if (!(line.getProgress() > 0.005f) && Minecraft.func_71410_x().field_71441_e.field_73012_v.nextInt(15) != 0) continue;
                line.incProgress(0.025f);
            }
        } else {
            Iterator<RenderProgressingLine> iterator = this.rangeLines.iterator();
            while (iterator.hasNext()) {
                RenderProgressingLine line = iterator.next();
                if (line.getProgress() > 0.005f) {
                    line.incProgress(0.025f);
                }
                if (Minecraft.func_71410_x().field_71441_e.field_73012_v.nextInt(8) != 0) continue;
                iterator.remove();
            }
        }
    }

    public void render() {
        if (this.rangeLines.isEmpty()) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        RenderUtils.glColorHex(this.color);
        PlayerEntity player = ClientUtils.getClientPlayer();
        if (this.pos != null) {
            GlStateManager.translated((double)((double)this.pos.func_177958_n() - player.field_70165_t + 0.5), (double)((double)this.pos.func_177956_o() - player.field_70163_u + 0.5), (double)((double)this.pos.func_177952_p() - player.field_70161_v + 0.5));
        }
        GlStateManager.lineWidth((float)2.0f);
        for (RenderProgressingLine line : this.rangeLines) {
            line.render();
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
        GlStateManager.enableTexture();
        GlStateManager.popMatrix();
    }
}

