/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.area;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.render.area.AreaRenderer;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.DroneDebugUpgradeHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemCamoApplicator;
import me.desht.pneumaticcraft.common.item.ItemGPSAreaTool;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AreaRenderManager {
    private static final AreaRenderManager INSTANCE = new AreaRenderManager();
    private final Map<BlockPos, AreaRenderer> showHandlers = new HashMap<BlockPos, AreaRenderer>();
    private World world;
    private DroneDebugUpgradeHandler droneDebugger;
    private List<BlockPos> cachedPositionProviderData;
    private List<AreaRenderer> cachedPositionProviderShowers;
    private AreaRenderer camoPositionShower;
    private BlockPos lastPlayerPos;
    private int lastItemHashCode = 0;

    public static AreaRenderManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(-TileEntityRendererDispatcher.field_147554_b), (double)(-TileEntityRendererDispatcher.field_147555_c), (double)(-TileEntityRendererDispatcher.field_147552_d));
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        for (AreaRenderer handler : this.showHandlers.values()) {
            handler.render();
        }
        this.maybeRenderPositionProvider((PlayerEntity)player);
        this.maybeRenderCamo((PlayerEntity)player);
        this.maybeRenderDroneDebug((PlayerEntity)player);
        this.maybeRenderAreaTool((PlayerEntity)player);
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        PlayerEntity player = ClientUtils.getClientPlayer();
        if (player != null) {
            if (player.field_70170_p != this.world) {
                this.world = player.field_70170_p;
                this.showHandlers.clear();
            } else if (event.phase == TickEvent.Phase.END) {
                this.showHandlers.keySet().removeIf(pos -> PneumaticCraftUtils.distBetweenSq(pos, player.func_180425_c()) < 1024.0 && this.world.func_175623_d(pos));
            }
        }
    }

    private void maybeRenderAreaTool(PlayerEntity player) {
        ItemStack curItem = this.getHeldPositionProvider(player);
        if (curItem.func_77973_b() instanceof ItemGPSAreaTool) {
            BlockPos p1 = ItemGPSAreaTool.getGPSLocation(player.func_130014_f_(), curItem, 0);
            BlockPos p2 = ItemGPSAreaTool.getGPSLocation(player.func_130014_f_(), curItem, 1);
            new AreaRenderer(Collections.singleton(p1), -520134560, true).render();
            new AreaRenderer(Collections.singleton(p2), -530514080, true).render();
        }
    }

    private void maybeRenderDroneDebug(PlayerEntity player) {
        ItemStack helmet = player.func_184582_a(EquipmentSlotType.HEAD);
        if (helmet.func_77973_b() == ModItems.PNEUMATIC_HELMET.get()) {
            if (this.droneDebugger == null) {
                this.droneDebugger = HUDHandler.instance().getSpecificRenderer(DroneDebugUpgradeHandler.class);
            }
            Set<BlockPos> posSet = this.droneDebugger.getShowingPositions();
            Set<BlockPos> areaSet = this.droneDebugger.getShownArea();
            new AreaRenderer(posSet, -1862336512, true).render();
            new AreaRenderer(areaSet, 1078001568, true).render();
        }
    }

    private ItemStack getHeldPositionProvider(PlayerEntity player) {
        if (player.func_184614_ca().func_77973_b() instanceof IPositionProvider) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() instanceof IPositionProvider) {
            return player.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    private void maybeRenderPositionProvider(PlayerEntity player) {
        ItemStack curItem = this.getHeldPositionProvider(player);
        if (curItem.func_77973_b() instanceof IPositionProvider && curItem.func_77942_o()) {
            int thisHash = curItem.func_77978_p().hashCode();
            if (thisHash != this.lastItemHashCode) {
                this.lastItemHashCode = thisHash;
                IPositionProvider positionProvider = (IPositionProvider)curItem.func_77973_b();
                List<BlockPos> posList = positionProvider.getStoredPositions(player.func_130014_f_(), curItem);
                Int2ObjectOpenHashMap colorsToPositions = new Int2ObjectOpenHashMap();
                for (int i = 0; i < posList.size(); ++i) {
                    int renderColor = positionProvider.getRenderColor(i);
                    if (posList.get(i) == null || renderColor == 0) continue;
                    HashSet<BlockPos> positionsForColor = (HashSet<BlockPos>)colorsToPositions.get(renderColor);
                    if (positionsForColor == null) {
                        positionsForColor = new HashSet<BlockPos>();
                        colorsToPositions.put(renderColor, positionsForColor);
                    }
                    positionsForColor.add(posList.get(i));
                }
                this.cachedPositionProviderData = posList;
                this.cachedPositionProviderShowers = new ArrayList<AreaRenderer>(colorsToPositions.size());
                colorsToPositions.int2ObjectEntrySet().forEach(entry -> this.cachedPositionProviderShowers.add(new AreaRenderer((Set)entry.getValue(), entry.getIntKey(), positionProvider.disableDepthTest())));
            }
            this.cachedPositionProviderShowers.forEach(AreaRenderer::render);
        }
    }

    private void maybeRenderCamo(PlayerEntity player) {
        if (!(player.func_184614_ca().func_77973_b() instanceof ItemCamoApplicator)) {
            return;
        }
        if (this.lastPlayerPos == null || this.camoPositionShower == null || player.func_70092_e((double)this.lastPlayerPos.func_177958_n(), (double)this.lastPlayerPos.func_177956_o(), (double)this.lastPlayerPos.func_177952_p()) > 9.0) {
            this.lastPlayerPos = player.func_180425_c();
            Set<BlockPos> s = Minecraft.func_71410_x().field_71441_e.field_147482_g.stream().filter(te -> te instanceof ICamouflageableTE && te.func_174877_v().func_177951_i((Vec3i)this.lastPlayerPos) < 144.0).map(TileEntity::func_174877_v).collect(Collectors.toSet());
            this.camoPositionShower = new AreaRenderer(s, 1619034367, 0.75, true, true);
        }
        if (this.camoPositionShower != null) {
            this.camoPositionShower.render();
        }
    }

    public AreaRenderer showArea(BlockPos[] area, int color, TileEntity areaShower) {
        return this.showArea(new HashSet<BlockPos>(Arrays.asList(area)), color, areaShower);
    }

    public AreaRenderer showArea(Set<BlockPos> area, int color, TileEntity areaShower) {
        if (areaShower == null) {
            return null;
        }
        this.removeHandlers(areaShower);
        AreaRenderer handler = new AreaRenderer(area, color, false);
        this.showHandlers.put(new BlockPos(areaShower.func_174877_v().func_177958_n(), areaShower.func_174877_v().func_177956_o(), areaShower.func_174877_v().func_177952_p()), handler);
        return handler;
    }

    public boolean isShowing(TileEntity te) {
        return this.showHandlers.containsKey(new BlockPos(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p()));
    }

    public void removeHandlers(TileEntity te) {
        this.showHandlers.remove(new BlockPos(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p()));
    }
}

