/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.area;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Set;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;

public class AreaRenderer {
    private final Set<BlockPos> showingPositions;
    private final int color;
    private final double size;
    private final int renderList;
    private final boolean disableDepthTest;
    private final boolean drawShapes;
    private static final ISelectionContext SELECTION_CONTEXT = new ISelectionContext(){

        public boolean func_216376_b() {
            return false;
        }

        public boolean func_216378_a(VoxelShape shape, BlockPos pos, boolean p_216378_3_) {
            return false;
        }

        public boolean func_216375_a(Item itemIn) {
            return false;
        }
    };

    AreaRenderer(Set<BlockPos> area, int color, double size, boolean disableDepthTest, boolean drawShapes) {
        this.showingPositions = area;
        this.color = color;
        this.size = size;
        this.disableDepthTest = disableDepthTest;
        this.drawShapes = drawShapes;
        this.renderList = this.compileRenderList();
    }

    AreaRenderer(Set<BlockPos> area, int color, boolean disableDepthTest) {
        this(area, color, 0.5, disableDepthTest, false);
    }

    private int compileRenderList() {
        int renderList = GlStateManager.genLists((int)1);
        GlStateManager.newList((int)renderList, (int)4864);
        if (this.disableDepthTest) {
            GlStateManager.disableDepthTest();
        }
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        RenderUtils.glColorHex(this.color);
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (BlockPos pos : this.showingPositions) {
            this.doRender(wr, pos);
        }
        Tessellator.func_178181_a().func_78381_a();
        wr.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        RenderUtils.glColorHex(0x404040, 128);
        for (BlockPos pos : this.showingPositions) {
            this.doRender(wr, pos);
        }
        wr.func_178969_c(0.0, 0.0, 0.0);
        Tessellator.func_178181_a().func_78381_a();
        if (this.disableDepthTest) {
            GlStateManager.enableDepthTest();
        }
        GlStateManager.endList();
        return renderList;
    }

    private void doRender(BufferBuilder wr, BlockPos pos) {
        if (this.drawShapes) {
            wr.func_178969_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            BlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos);
            VoxelShape shape = state.func_215700_a((IBlockReader)Minecraft.func_71410_x().field_71441_e, pos, SELECTION_CONTEXT);
            shape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
                wr.func_181662_b(x1, y1, z1).func_181675_d();
                wr.func_181662_b(x1, y2, z1).func_181675_d();
                wr.func_181662_b(x2, y2, z1).func_181675_d();
                wr.func_181662_b(x2, y1, z1).func_181675_d();
                wr.func_181662_b(x2, y1, z2).func_181675_d();
                wr.func_181662_b(x2, y2, z2).func_181675_d();
                wr.func_181662_b(x1, y2, z2).func_181675_d();
                wr.func_181662_b(x1, y1, z2).func_181675_d();
                wr.func_181662_b(x1, y1, z1).func_181675_d();
                wr.func_181662_b(x1, y1, z2).func_181675_d();
                wr.func_181662_b(x1, y2, z2).func_181675_d();
                wr.func_181662_b(x1, y2, z1).func_181675_d();
                wr.func_181662_b(x2, y2, z1).func_181675_d();
                wr.func_181662_b(x2, y2, z2).func_181675_d();
                wr.func_181662_b(x2, y1, z2).func_181675_d();
                wr.func_181662_b(x2, y1, z1).func_181675_d();
                wr.func_181662_b(x1, y1, z1).func_181675_d();
                wr.func_181662_b(x2, y1, z1).func_181675_d();
                wr.func_181662_b(x2, y1, z2).func_181675_d();
                wr.func_181662_b(x1, y1, z2).func_181675_d();
                wr.func_181662_b(x1, y2, z2).func_181675_d();
                wr.func_181662_b(x2, y2, z2).func_181675_d();
                wr.func_181662_b(x2, y2, z1).func_181675_d();
                wr.func_181662_b(x1, y2, z1).func_181675_d();
            });
        } else {
            double start = (1.0 - this.size) / 2.0;
            wr.func_178969_c((double)pos.func_177958_n() + start, (double)pos.func_177956_o() + start, (double)pos.func_177952_p() + start);
            wr.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
            wr.func_181662_b(0.0, this.size, 0.0).func_181675_d();
            wr.func_181662_b(this.size, this.size, 0.0).func_181675_d();
            wr.func_181662_b(this.size, 0.0, 0.0).func_181675_d();
            wr.func_181662_b(this.size, 0.0, this.size).func_181675_d();
            wr.func_181662_b(this.size, this.size, this.size).func_181675_d();
            wr.func_181662_b(0.0, this.size, this.size).func_181675_d();
            wr.func_181662_b(0.0, 0.0, this.size).func_181675_d();
            wr.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
            wr.func_181662_b(0.0, 0.0, this.size).func_181675_d();
            wr.func_181662_b(0.0, this.size, this.size).func_181675_d();
            wr.func_181662_b(0.0, this.size, 0.0).func_181675_d();
            wr.func_181662_b(this.size, this.size, 0.0).func_181675_d();
            wr.func_181662_b(this.size, this.size, this.size).func_181675_d();
            wr.func_181662_b(this.size, 0.0, this.size).func_181675_d();
            wr.func_181662_b(this.size, 0.0, 0.0).func_181675_d();
            wr.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
            wr.func_181662_b(this.size, 0.0, 0.0).func_181675_d();
            wr.func_181662_b(this.size, 0.0, this.size).func_181675_d();
            wr.func_181662_b(0.0, 0.0, this.size).func_181675_d();
            wr.func_181662_b(0.0, this.size, this.size).func_181675_d();
            wr.func_181662_b(this.size, this.size, this.size).func_181675_d();
            wr.func_181662_b(this.size, this.size, 0.0).func_181675_d();
            wr.func_181662_b(0.0, this.size, 0.0).func_181675_d();
        }
    }

    public void render() {
        GlStateManager.callList((int)this.renderList);
    }
}

