/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.model.entity.ModelDrone;
import me.desht.pneumaticcraft.client.render.RenderLaser;
import me.desht.pneumaticcraft.client.render.RenderMinigunTracers;
import me.desht.pneumaticcraft.client.render.RenderProgressingLine;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.entity.living.EntityDroneBase;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderDrone
extends MobRenderer<EntityDroneBase, ModelDrone> {
    public static final IRenderFactory<EntityDroneBase> REGULAR_FACTORY = RenderDrone::new;
    public static final IRenderFactory<EntityDroneBase> LOGISTICS_FACTORY = manager -> new RenderDrone(manager, -65536);
    public static final IRenderFactory<EntityDroneBase> HARVESTING_FACTORY = manager -> new RenderDrone(manager, -16752382);
    public static final IRenderFactory<EntityDroneBase> GUARD_FACTORY = manager -> new RenderDrone(manager, -11829282);
    public static final IRenderFactory<EntityDroneBase> COLLECTOR_FACTORY = manager -> new RenderDrone(manager, -3487193);
    public static final IRenderFactory<EntityDroneBase> AMADRONE_FACTORY = manager -> new RenderDrone(manager, Short.MIN_VALUE);
    private final RenderLaser laserRenderer = new RenderLaser();

    private RenderDrone(EntityRendererManager manager) {
        super(manager, (EntityModel)new ModelDrone(), 0.0f);
    }

    private RenderDrone(EntityRendererManager manager, int frameColor) {
        super(manager, (EntityModel)new ModelDrone(frameColor), 0.0f);
    }

    private void renderDrone(EntityDroneBase drone, double x, double y, double z, float yaw, float partialTicks) {
        if (drone.func_110143_aJ() <= 0.0f) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)((float)x), (double)((float)y), (double)((float)z));
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)0.76f, (double)0.0);
        GlStateManager.scaled((double)0.5, (double)-0.5, (double)-0.5);
        this.func_180548_c((Entity)drone);
        ((ModelDrone)this.func_217764_d()).setLivingAnimations(drone, 0.0f, 0.0f, partialTicks);
        ((ModelDrone)this.func_217764_d()).render(drone, 0.0f, 0.0f, 0.0f, 0.0f, partialTicks, 0.0625f);
        GlStateManager.popMatrix();
        this.renderExtras(drone, x, y, z, partialTicks);
        GlStateManager.popMatrix();
    }

    protected ResourceLocation getEntityTexture(EntityDroneBase par1Entity) {
        return Textures.MODEL_DRONE;
    }

    public void doRender(EntityDroneBase drone, double par2, double par4, double par6, float par8, float par9) {
        this.renderDrone(drone, par2, par4, par6, par8, par9);
        this.func_177067_a((LivingEntity)drone, par2, par4, par6);
    }

    protected boolean canRenderName(EntityDroneBase drone) {
        return super.func_177070_b((MobEntity)drone) && (drone.func_94059_bO() || drone.func_145818_k_() && drone == this.field_76990_c.field_147941_i);
    }

    private void renderExtras(EntityDroneBase droneBase, double x, double y, double z, float partialTicks) {
        BlockPos diggingPos = droneBase.getDugBlock();
        if (diggingPos != null) {
            this.laserRenderer.render(partialTicks, droneBase, 0.0, droneBase.getLaserOffsetY(), 0.0, (double)diggingPos.func_177958_n() + 0.5 - droneBase.field_70165_t, (double)diggingPos.func_177956_o() + 0.45 - droneBase.field_70163_u, (double)diggingPos.func_177952_p() + 0.5 - droneBase.field_70161_v);
        }
        if (droneBase instanceof EntityDrone) {
            ItemStack held;
            EntityDrone drone = (EntityDrone)droneBase;
            this.renderTargetLine(drone, partialTicks);
            if (drone.hasMinigun()) {
                this.renderMinigunTracers(drone, partialTicks);
            }
            if (!((held = drone.getDroneHeldItem()).func_190926_b() || held.func_77973_b() instanceof ItemGunAmmo && drone.hasMinigun())) {
                this.renderHeldItem(held);
            }
        }
    }

    private void renderTargetLine(EntityDrone drone, float partialTicks) {
        RenderProgressingLine targetLine = drone.getTargetLine();
        RenderProgressingLine oldTargetLine = drone.getOldTargetLine();
        if (targetLine != null && oldTargetLine != null) {
            GlStateManager.pushMatrix();
            GlStateManager.scaled((double)1.0, (double)-1.0, (double)1.0);
            GlStateManager.disableTexture();
            GlStateManager.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            targetLine.renderInterpolated(oldTargetLine, partialTicks);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableTexture();
            GlStateManager.popMatrix();
        }
    }

    private void renderMinigunTracers(EntityDrone drone, float partialTicks) {
        double x1 = drone.field_70142_S + (drone.field_70165_t - drone.field_70142_S) * (double)partialTicks;
        double y1 = drone.field_70137_T + (drone.field_70163_u - drone.field_70137_T) * (double)partialTicks;
        double z1 = drone.field_70136_U + (drone.field_70161_v - drone.field_70136_U) * (double)partialTicks;
        RenderMinigunTracers.instance().render(drone.getMinigun(), x1, y1, z1, 0.6);
    }

    private void renderHeldItem(@Nonnull ItemStack droneHeldItem) {
        double yOffset = -0.2f;
        if (droneHeldItem.func_77973_b() instanceof ToolItem || droneHeldItem.func_77973_b() instanceof SwordItem || droneHeldItem.func_77973_b() instanceof HoeItem) {
            GlStateManager.rotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
            yOffset = 0.2f;
        }
        GlStateManager.translated((double)0.0, (double)yOffset, (double)0.0);
        double scaleFactor = droneHeldItem.func_77973_b() instanceof BlockItem ? (double)0.7f : 0.5;
        GlStateManager.scaled((double)scaleFactor, (double)scaleFactor, (double)scaleFactor);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(droneHeldItem, ItemCameraTransforms.TransformType.FIXED);
    }
}

