/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.projectile.EntityVortex;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.DefaultRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderEntityVortex
extends DefaultRenderer {
    private static final int CIRCLE_POINTS = 200;
    private static final double RADIUS = 0.5;
    public static final IRenderFactory<EntityVortex> FACTORY = RenderEntityVortex::new;

    private RenderEntityVortex(EntityRendererManager manager) {
        super(manager);
    }

    private void renderVortex(EntityVortex entity, double x, double y, double z, float var1, float partialTicks) {
        if (!entity.hasRenderOffsetX()) {
            entity.setRenderOffsetX(this.calculateXoffset());
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.disableTexture();
        GlStateManager.color4f((float)0.8f, (float)0.8f, (float)0.8f, (float)0.7f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.rotated((double)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks), (double)0.0, (double)0.0, (double)1.0);
        GlStateManager.rotated((double)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks), (double)0.0, (double)1.0, (double)0.0);
        for (int i = 0; i < 200; ++i) {
            float angleRadians = (float)i / 200.0f * 2.0f * (float)Math.PI;
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)(0.5 * (double)MathHelper.func_76126_a((float)angleRadians)), (double)(0.5 * (double)MathHelper.func_76134_b((float)angleRadians)), (double)0.0);
            this.renderGust(entity.getRenderOffsetX());
            GlStateManager.popMatrix();
        }
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableBlend();
        GlStateManager.enableTexture();
        GlStateManager.popMatrix();
    }

    private float calculateXoffset() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        HandSide hs = player.func_184591_cq();
        if (player.func_184614_ca().func_77973_b() != ModItems.VORTEX_CANNON.get()) {
            hs = hs.func_188468_a();
        }
        return hs == HandSide.RIGHT ? -4.0f : 16.0f;
    }

    private void renderGust(float xOffset) {
        int b0 = 0;
        float f6 = 0.0f;
        float f7 = 0.15625f;
        float f8 = (float)(5 + b0 * 10) / 16.0f;
        float f9 = (float)(10 + b0 * 10) / 16.0f;
        float f10 = 0.05625f;
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.rotated((double)45.0, (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.scaled((double)f10, (double)f10, (double)f10);
        GlStateManager.translated((double)xOffset, (double)0.0, (double)0.0);
        GlStateManager.normal3f((float)f10, (float)0.0f, (float)0.0f);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b(-7.0, -2.0, -2.0).func_187315_a((double)f6, (double)f8).func_181675_d();
        wr.func_181662_b(-7.0, -2.0, 2.0).func_187315_a((double)f7, (double)f8).func_181675_d();
        wr.func_181662_b(-7.0, 2.0, 2.0).func_187315_a((double)f7, (double)f9).func_181675_d();
        wr.func_181662_b(-7.0, 2.0, -2.0).func_187315_a((double)f6, (double)f9).func_181675_d();
        double start = 0.0;
        double end = 0.0625;
        wr.func_181662_b(-7.0, -2.0, -2.0).func_187315_a(start, start).func_181675_d();
        wr.func_181662_b(-7.0, -2.0, 2.0).func_187315_a(start, end).func_181675_d();
        wr.func_181662_b(-7.0, 2.0, 2.0).func_187315_a(end, end).func_181675_d();
        wr.func_181662_b(-7.0, 2.0, -2.0).func_187315_a(end, start).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.normal3f((float)(-f10), (float)0.0f, (float)0.0f);
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b(-7.0, 2.0, -2.0).func_187315_a((double)f6, (double)f8).func_181675_d();
        wr.func_181662_b(-7.0, 2.0, 2.0).func_187315_a((double)f7, (double)f8).func_181675_d();
        wr.func_181662_b(-7.0, -2.0, 2.0).func_187315_a((double)f7, (double)f9).func_181675_d();
        wr.func_181662_b(-7.0, -2.0, -2.0).func_187315_a((double)f6, (double)f9).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public void func_76986_a(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        this.renderVortex((EntityVortex)par1Entity, par2, par4, par6, par8, par9);
    }

    protected ResourceLocation func_110775_a(Entity par1Entity) {
        return Textures.VORTEX;
    }
}

