/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.render.entity.RenderSemiblockBase;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderLogisticsFrame
extends RenderSemiblockBase<EntityLogisticsFrame> {
    public static final IRenderFactory<EntityLogisticsFrame> FACTORY = RenderLogisticsFrame::new;
    private static final double FRAME_WIDTH = 0.03125;
    private static final AxisAlignedBB DEFAULT_BOX = new AxisAlignedBB(0.03125, 0.03125, 0.03125, 0.96875, 0.96875, 0.96875);

    private RenderLogisticsFrame(EntityRendererManager rendererManager) {
        super(rendererManager);
    }

    public void doRender(EntityLogisticsFrame entity, double x, double y, double z, float entityYaw, float partialTicks) {
        int alpha = entity.getAlpha();
        if (alpha == 0) {
            return;
        }
        if (alpha < 255) {
            GlStateManager.enableBlend();
        }
        RenderUtils.glColorHex((alpha << 24 | 0xFFFFFF) & entity.getColor());
        GlStateManager.disableTexture();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(x - 0.5), (double)y, (double)(z - 0.5));
        if (entity.getTimeSinceHit() > 0) {
            this.wobble(entity, partialTicks);
        }
        AxisAlignedBB b = entity.getBlockBounds();
        RenderUtils.renderFrame(b, 0.03125 + entity.antiZfight);
        this.drawSideHighlight(entity, b, partialTicks);
        GlStateManager.popMatrix();
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean func_188295_H_() {
        return false;
    }

    public void renderMultipass(EntityLogisticsFrame entity, double x, double y, double z, float entityYaw, float partialTicks) {
    }

    private void drawSideHighlight(EntityLogisticsFrame entity, AxisAlignedBB aabb, float partialTicks) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        double dist = Minecraft.func_71410_x().field_71439_g.func_70068_e((Entity)entity);
        GlStateManager.lineWidth((float)(dist > 64.0 ? (dist > 256.0 ? 1.0f : 2.0f) : 3.0f));
        GlStateManager.disableLighting();
        wr.func_181668_a(2, DefaultVertexFormats.field_181705_e);
        double d = 0.06 + 0.005 * (double)MathHelper.func_76126_a((float)(((float)entity.field_70173_aa + partialTicks) / 10.0f));
        double minX = aabb.field_72340_a + d;
        double minY = aabb.field_72338_b + d;
        double minZ = aabb.field_72339_c + d;
        double maxX = aabb.field_72336_d - d;
        double maxY = aabb.field_72337_e - d;
        double maxZ = aabb.field_72334_f - d;
        switch (entity.getFacing()) {
            case DOWN: {
                wr.func_181662_b(minX, aabb.field_72338_b - 0.02, minZ).func_181675_d();
                wr.func_181662_b(maxX, aabb.field_72338_b - 0.02, minZ).func_181675_d();
                wr.func_181662_b(maxX, aabb.field_72338_b - 0.02, maxZ).func_181675_d();
                wr.func_181662_b(minX, aabb.field_72338_b - 0.02, maxZ).func_181675_d();
                break;
            }
            case UP: {
                wr.func_181662_b(minX, aabb.field_72337_e + 0.02, maxZ).func_181675_d();
                wr.func_181662_b(maxX, aabb.field_72337_e + 0.02, maxZ).func_181675_d();
                wr.func_181662_b(maxX, aabb.field_72337_e + 0.02, minZ).func_181675_d();
                wr.func_181662_b(minX, aabb.field_72337_e + 0.02, minZ).func_181675_d();
                break;
            }
            case NORTH: {
                wr.func_181662_b(maxX, minY, aabb.field_72339_c - 0.02).func_181675_d();
                wr.func_181662_b(minX, minY, aabb.field_72339_c - 0.02).func_181675_d();
                wr.func_181662_b(minX, maxY, aabb.field_72339_c - 0.02).func_181675_d();
                wr.func_181662_b(maxX, maxY, aabb.field_72339_c - 0.02).func_181675_d();
                break;
            }
            case SOUTH: {
                wr.func_181662_b(maxX, maxY, aabb.field_72334_f + 0.02).func_181675_d();
                wr.func_181662_b(minX, maxY, aabb.field_72334_f + 0.02).func_181675_d();
                wr.func_181662_b(minX, minY, aabb.field_72334_f + 0.02).func_181675_d();
                wr.func_181662_b(maxX, minY, aabb.field_72334_f + 0.02).func_181675_d();
                break;
            }
            case WEST: {
                wr.func_181662_b(aabb.field_72340_a - 0.02, minY, minZ).func_181675_d();
                wr.func_181662_b(aabb.field_72340_a - 0.02, minY, maxZ).func_181675_d();
                wr.func_181662_b(aabb.field_72340_a - 0.02, maxY, maxZ).func_181675_d();
                wr.func_181662_b(aabb.field_72340_a - 0.02, maxY, minZ).func_181675_d();
                break;
            }
            case EAST: {
                wr.func_181662_b(aabb.field_72336_d + 0.02, maxY, minZ).func_181675_d();
                wr.func_181662_b(aabb.field_72336_d + 0.02, maxY, maxZ).func_181675_d();
                wr.func_181662_b(aabb.field_72336_d + 0.02, minY, maxZ).func_181675_d();
                wr.func_181662_b(aabb.field_72336_d + 0.02, minY, minZ).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.enableLighting();
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityLogisticsFrame entityLogisticsFrame) {
        return null;
    }
}

