/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.render.entity.RenderSemiblockBase;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityTransferGadget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderTransferGadget
extends RenderSemiblockBase<EntityTransferGadget> {
    public static final IRenderFactory<EntityTransferGadget> FACTORY = RenderTransferGadget::new;
    private final Map<AxisAlignedBB, Integer> renderListCache = new HashMap<AxisAlignedBB, Integer>();

    private RenderTransferGadget(EntityRendererManager rendererManager) {
        super(rendererManager);
    }

    public void doRender(EntityTransferGadget entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (entity.isAir() || entity.renderingOffset == null) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.setProfile((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
        AxisAlignedBB aabb = entity.func_174813_aQ();
        this.setupColour(entity);
        Vec3d offset = entity.renderingOffset;
        if (entity.getTimeSinceHit() > 0) {
            this.wobble(entity, partialTicks);
        }
        GlStateManager.translated((double)(x - entity.field_70165_t + offset.func_82615_a()), (double)(y - entity.field_70163_u + offset.func_82617_b()), (double)(z - entity.field_70161_v + offset.func_82616_c()));
        int renderList = this.renderListCache.computeIfAbsent(aabb, this::compileRenderList);
        GlStateManager.callList((int)renderList);
        GlStateManager.disableBlend();
        GlStateManager.unsetProfile((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
        GlStateManager.enableTexture();
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void setupColour(EntityTransferGadget entity) {
        EntityTransferGadget.EnumInputOutput io = entity.getIOMode();
        if (io == EntityTransferGadget.EnumInputOutput.INPUT) {
            GlStateManager.color4f((float)0.0f, (float)0.0f, (float)1.0f, (float)0.75f);
        } else {
            GlStateManager.color4f((float)1.0f, (float)0.3f, (float)0.0f, (float)0.75f);
        }
    }

    private int compileRenderList(AxisAlignedBB aabb) {
        int renderList = GlStateManager.genLists((int)1);
        GlStateManager.newList((int)renderList, (int)4864);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.endList();
        return renderList;
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityTransferGadget entityTransferGadget) {
        return null;
    }
}

