/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.IKeyListener;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiHelmetMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.LauncherTracker;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.DroneDebugUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.HackUpgradeHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPneumaticKick;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HUDHandler
implements IKeyListener {
    private static final int PROGRESS_BAR_HEIGHT = 17;
    private long lastArmorInitSound;
    private boolean sentForceInitPacket = false;
    private final List<ArmorMessage> messageList = new ArrayList<ArmorMessage>();
    private final boolean[] gaveEmptyWarning = new boolean[4];
    private final boolean[] gaveNearlyEmptyWarning = new boolean[4];
    private static final HUDHandler INSTANCE = new HUDHandler();

    public static HUDHandler instance() {
        return INSTANCE;
    }

    public <T extends IUpgradeRenderHandler> T getSpecificRenderer(Class<T> clazz) {
        return UpgradeRenderHandlerList.instance().getRenderHandler(clazz);
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!WidgetKeybindCheckBox.getCoreComponents().checked || mc.field_71474_y.field_74319_N) {
            return;
        }
        ClientPlayerEntity player = mc.field_71439_g;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(-TileEntityRendererDispatcher.field_147554_b), (double)(-TileEntityRendererDispatcher.field_147555_c), (double)(-TileEntityRendererDispatcher.field_147552_d));
        ItemStack helmetStack = player.func_184582_a(EquipmentSlotType.HEAD);
        CommonArmorHandler comHudHandler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player);
        if (helmetStack.func_77973_b() instanceof ItemPneumaticArmor && comHudHandler.getArmorPressure(EquipmentSlotType.HEAD) > 0.0f) {
            for (EquipmentSlotType slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                if (!comHudHandler.isArmorReady(slot)) continue;
                GlStateManager.disableTexture();
                List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot);
                for (int i = 0; i < renderHandlers.size(); ++i) {
                    if (!comHudHandler.isUpgradeRendererInserted(slot, i) || !WidgetKeybindCheckBox.fromKeyBindingName((String)renderHandlers.get((int)i).getUpgradeID()).checked) continue;
                    renderHandlers.get(i).render3D(event.getPartialTicks());
                }
                GlStateManager.enableTexture();
            }
        }
        GlStateManager.popMatrix();
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END && !mc.field_71474_y.field_74319_N && mc.field_71439_g != null) {
            this.render2D(event.renderTickTime);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            PlayerEntity player = event.player;
            if (player == mc.field_71439_g && player.field_70170_p.field_72995_K) {
                boolean armorEquipped = false;
                CommonArmorHandler comHudHandler = CommonArmorHandler.getHandlerForPlayer();
                for (EquipmentSlotType slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                    if (!ItemPneumaticArmor.isPneumaticArmorPiece(player, slot)) continue;
                    this.update((PlayerEntity)mc.field_71439_g, slot, comHudHandler);
                    armorEquipped = true;
                }
                if (armorEquipped) {
                    this.ensureArmorInit(player, comHudHandler);
                    this.updateLauncherTracker();
                    this.messageList.forEach(message -> message.getStat().tickWidget());
                    this.messageList.removeIf(message -> message == null || --message.lifeSpan <= 0);
                } else {
                    this.messageList.clear();
                    this.sentForceInitPacket = false;
                }
            }
        }
    }

    private void ensureArmorInit(PlayerEntity player, CommonArmorHandler comHudHandler) {
        if (!ItemPneumaticArmor.isPneumaticArmorPiece(player, EquipmentSlotType.HEAD) && !this.sentForceInitPacket) {
            boolean state = WidgetKeybindCheckBox.getCoreComponents().checked;
            if (state) {
                comHudHandler.setUpgradeRenderEnabled(EquipmentSlotType.HEAD, (byte)0, true);
                NetworkHandler.sendToServer(new PacketToggleArmorFeature(0, true, EquipmentSlotType.HEAD));
            }
            this.sentForceInitPacket = true;
        }
    }

    private void updateLauncherTracker() {
        if (LauncherTracker.INSTANCE.getLauncherProgress() > 0) {
            if (!KeyHandler.getInstance().keybindLauncher.func_151470_d()) {
                LauncherTracker.INSTANCE.trigger();
            } else {
                LauncherTracker.INSTANCE.chargeLauncher();
            }
        }
    }

    private void render2D(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (mc.field_71462_r == null && ItemPneumaticArmor.isPlayerWearingAnyPneumaticArmor((PlayerEntity)player)) {
            ItemStack armorStack;
            MainWindow mw = mc.field_195558_d;
            GlStateManager.depthMask((boolean)false);
            GlStateManager.disableCull();
            GlStateManager.disableTexture();
            GlStateManager.pushMatrix();
            GlStateManager.clear((int)256, (boolean)Minecraft.field_142025_a);
            GlStateManager.color4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.8f);
            CommonArmorHandler comHudHandler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player);
            boolean anyArmorInInit = false;
            for (Object slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                armorStack = player.func_184582_a(slot);
                if (!(armorStack.func_77973_b() instanceof ItemPneumaticArmor) || comHudHandler.isArmorReady((EquipmentSlotType)slot)) continue;
                anyArmorInInit = true;
                break;
            }
            for (Object slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                armorStack = player.func_184582_a(slot);
                if (!(armorStack.func_77973_b() instanceof ItemPneumaticArmor) || comHudHandler.getArmorPressure((EquipmentSlotType)slot) < 1.0E-4f) continue;
                if (anyArmorInInit) {
                    this.gaveEmptyWarning[slot.func_188454_b()] = false;
                    this.gaveNearlyEmptyWarning[slot.func_188454_b()] = false;
                    if (comHudHandler.isArmorEnabled()) {
                        int xLeft = mw.func_198107_o() / 2;
                        int yOffset = 10 + (3 - slot.func_188454_b()) * 17;
                        float progress = (float)comHudHandler.getTicksSinceEquipped((EquipmentSlotType)slot) * 100.0f / (float)comHudHandler.getStartupTime((EquipmentSlotType)slot);
                        progress = Math.min(100.0f, progress + partialTicks);
                        RenderProgressBar.render((double)mw.func_198107_o() / 2.0, yOffset, mw.func_198107_o() - 10, yOffset + 17 - 1, -90.0, progress, -1426079744, -1442775296);
                        GlStateManager.enableTexture();
                        GuiUtils.drawItemStack(armorStack, xLeft + 2, yOffset);
                    }
                }
                if (!comHudHandler.isArmorReady((EquipmentSlotType)slot)) continue;
                String itemName = armorStack.func_200301_q().func_150254_d();
                float pressure = comHudHandler.getArmorPressure((EquipmentSlotType)slot);
                if (pressure < 0.05f && !this.gaveEmptyWarning[slot.func_188454_b()]) {
                    this.addMessage(new ArmorMessage(I18n.func_135052_a((String)"pneumaticHelmet.message.outOfAir", (Object[])new Object[]{itemName}), 100, 0x70FF0000));
                    this.gaveEmptyWarning[slot.func_188454_b()] = true;
                }
                if (pressure > 0.2f && pressure < 0.5f && !this.gaveNearlyEmptyWarning[slot.func_188454_b()]) {
                    this.addMessage(new ArmorMessage(I18n.func_135052_a((String)"pneumaticHelmet.message.almostOutOfAir", (Object[])new Object[]{itemName}), 60, 1895792640));
                    this.gaveNearlyEmptyWarning[slot.func_188454_b()] = true;
                }
                if (!WidgetKeybindCheckBox.getCoreComponents().checked) continue;
                List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot((EquipmentSlotType)slot);
                for (int i = 0; i < renderHandlers.size(); ++i) {
                    IUpgradeRenderHandler upgradeRenderHandler = renderHandlers.get(i);
                    if (!comHudHandler.isUpgradeRendererInserted((EquipmentSlotType)slot, i) || !comHudHandler.isUpgradeRendererEnabled((EquipmentSlotType)slot, i)) continue;
                    IGuiAnimatedStat stat = upgradeRenderHandler.getAnimatedStat();
                    if (stat != null) {
                        stat.render(-1, -1, partialTicks);
                    }
                    upgradeRenderHandler.render2D(partialTicks, pressure > 0.0f);
                }
            }
            if (LauncherTracker.INSTANCE.getLauncherProgress() > 0) {
                LauncherTracker.INSTANCE.render(mw, partialTicks);
            }
            for (ArmorMessage message : this.messageList) {
                message.renderMessage(partialTicks);
            }
            GlStateManager.popMatrix();
            GlStateManager.enableCull();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.enableTexture();
            if (comHudHandler.isArmorEnabled() && anyArmorInInit) {
                for (Object slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                    if (!ItemPneumaticArmor.isPneumaticArmorPiece((PlayerEntity)player, slot) || !(comHudHandler.getArmorPressure((EquipmentSlotType)slot) > 0.0f)) continue;
                    String text = Math.min(100, comHudHandler.getTicksSinceEquipped((EquipmentSlotType)slot) * 100 / comHudHandler.getStartupTime((EquipmentSlotType)slot)) + "%";
                    mc.field_71466_p.func_175063_a(text, (float)mw.func_198107_o() * 0.75f - 8.0f, (float)(14 + 17 * (3 - slot.func_188454_b())), 0xFFFF40);
                }
            }
        }
    }

    private void update(PlayerEntity player, EquipmentSlotType slot, CommonArmorHandler comHudHandler) {
        int i;
        boolean armorEnabled = WidgetKeybindCheckBox.getCoreComponents().checked;
        List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(slot);
        if (comHudHandler.getTicksSinceEquipped(slot) == 0) {
            for (IUpgradeRenderHandler handler : UpgradeRenderHandlerList.instance().getHandlersForSlot(slot)) {
                handler.reset();
            }
            for (i = 0; i < renderHandlers.size(); ++i) {
                boolean state = armorEnabled && WidgetKeybindCheckBox.fromKeyBindingName((String)renderHandlers.get((int)i).getUpgradeID()).checked;
                comHudHandler.setUpgradeRenderEnabled(slot, (byte)i, state);
                NetworkHandler.sendToServer(new PacketToggleArmorFeature((byte)i, state, slot));
            }
        }
        if (comHudHandler.getTicksSinceEquipped(slot) > comHudHandler.getStartupTime(slot) && armorEnabled) {
            for (i = 0; i < renderHandlers.size(); ++i) {
                IUpgradeRenderHandler upgradeRenderHandler = renderHandlers.get(i);
                if (!comHudHandler.isUpgradeRendererInserted(slot, i) || !comHudHandler.isUpgradeRendererEnabled(slot, i)) continue;
                IGuiAnimatedStat stat = upgradeRenderHandler.getAnimatedStat();
                if (stat != null) {
                    if (comHudHandler.getArmorPressure(slot) > upgradeRenderHandler.getMinimumPressure()) {
                        stat.openWindow();
                    } else {
                        stat.closeWindow();
                    }
                    stat.tickWidget();
                }
                upgradeRenderHandler.update(player, comHudHandler.getUpgradeCount(slot, EnumUpgrade.RANGE));
            }
        }
        for (i = 0; i < renderHandlers.size(); ++i) {
            if (comHudHandler.getTicksSinceEquipped(slot) != comHudHandler.getStartupTime(slot) / (renderHandlers.size() + 2) * (i + 1)) continue;
            this.playArmorInitSound(player, (SoundEvent)ModSounds.HUD_INIT.get(), 0.5f + (float)(i + 1) / (float)(renderHandlers.size() + 2) * 0.5f);
            boolean upgradeEnabled = comHudHandler.isUpgradeRendererInserted(slot, i);
            this.addMessage(new ArmorMessage(I18n.func_135052_a((String)("pneumaticHelmet.upgrade." + renderHandlers.get(i).getUpgradeID()), (Object[])new Object[0]) + (upgradeEnabled ? " installed" : " not installed"), 80, upgradeEnabled ? 0x7000AA00 : 1895792640));
        }
        String itemName = player.func_184582_a(slot).func_200301_q().func_150254_d();
        if (comHudHandler.getTicksSinceEquipped(slot) == 1) {
            this.playArmorInitSound(player, (SoundEvent)ModSounds.HUD_INIT.get(), 0.5f);
            this.addMessage(new ArmorMessage(I18n.func_135052_a((String)"pneumaticHelmet.message.initStarted", (Object[])new Object[]{itemName}), 50, 0x7000AA00));
        }
        if (comHudHandler.getTicksSinceEquipped(slot) == comHudHandler.getStartupTime(slot)) {
            this.playArmorInitSound(player, (SoundEvent)ModSounds.HUD_INIT_COMPLETE.get(), 1.0f);
            this.addMessage(new ArmorMessage(I18n.func_135052_a((String)"pneumaticHelmet.message.initComplete", (Object[])new Object[]{itemName}), 50, 0x7000AA00));
        }
    }

    private void playArmorInitSound(PlayerEntity player, SoundEvent sound, float pitch) {
        long when = player.field_70170_p.func_82737_E();
        if (when - this.lastArmorInitSound >= 30L) {
            player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, SoundCategory.PLAYERS, 0.2f, pitch, true);
        }
        this.lastArmorInitSound = when;
    }

    public void addFeatureToggleMessage(String key, boolean enabled) {
        HUDHandler.instance().addMessage(I18n.func_135052_a((String)("pneumaticHelmet.message." + (enabled ? "enable" : "disable") + "Setting"), (Object[])new Object[]{I18n.func_135052_a((String)key, (Object[])new Object[0])}), Collections.emptyList(), 60, 0x7000AA00);
    }

    public void addFeatureToggleMessage(IUpgradeRenderHandler handler, String key, boolean enabled) {
        String msg = I18n.func_135052_a((String)("pneumaticHelmet.upgrade." + handler.getUpgradeID()), (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("pneumaticHelmet.upgrade." + key), (Object[])new Object[0]);
        HUDHandler.instance().addMessage(I18n.func_135052_a((String)("pneumaticHelmet.message." + (enabled ? "enable" : "disable") + "Setting"), (Object[])new Object[]{msg}), Collections.emptyList(), 60, 0x7000AA00);
    }

    public void addMessage(String title, List<String> message, int duration, int backColor) {
        this.addMessage(new ArmorMessage(title, message, duration, backColor));
    }

    public void addMessage(ArmorMessage message) {
        if (this.messageList.size() > 0) {
            message.setDependingMessage(this.messageList.get(this.messageList.size() - 1).getStat());
        }
        this.messageList.add(message);
    }

    @Override
    public void onKeyPress(KeyBinding key) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_195544_aj()) {
            if (key == KeyHandler.getInstance().keybindOpenOptions) {
                if (ItemPneumaticArmor.isPlayerWearingAnyPneumaticArmor((PlayerEntity)mc.field_71439_g)) {
                    mc.func_147108_a((Screen)GuiHelmetMainScreen.getInstance());
                }
            } else if (key == KeyHandler.getInstance().keybindHack && HackUpgradeHandler.enabledForPlayer((PlayerEntity)mc.field_71439_g)) {
                this.getSpecificRenderer(BlockTrackUpgradeHandler.class).hack();
                this.getSpecificRenderer(EntityTrackUpgradeHandler.class).hack();
            } else if (key == KeyHandler.getInstance().keybindDebuggingDrone && DroneDebugUpgradeHandler.enabledForPlayer(ClientUtils.getClientPlayer())) {
                this.getSpecificRenderer(EntityTrackUpgradeHandler.class).selectAsDebuggingTarget();
            } else if (key == KeyHandler.getInstance().keybindKick && CommonArmorHandler.getHandlerForPlayer().getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.DISPENSER) > 0) {
                NetworkHandler.sendToServer(new PacketPneumaticKick());
            } else if (key == KeyHandler.getInstance().keybindLauncher && !mc.field_71439_g.func_184592_cb().func_190926_b() && LauncherTracker.INSTANCE.isPlayerOKToLaunch()) {
                LauncherTracker.INSTANCE.startCharging();
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(GuiScreenEvent.MouseScrollEvent.Post event) {
        boolean isCaptured = this.getSpecificRenderer(BlockTrackUpgradeHandler.class).scroll(event);
        if (!isCaptured) {
            isCaptured = this.getSpecificRenderer(EntityTrackUpgradeHandler.class).scroll(event);
        }
        if (isCaptured) {
            event.setCanceled(true);
        }
    }

    public void onResolutionChanged() {
        for (EquipmentSlotType slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
            for (IUpgradeRenderHandler handler : UpgradeRenderHandlerList.instance().getHandlersForSlot(slot)) {
                handler.onResolutionChanged();
            }
        }
    }
}

