/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.hacking.IHacking;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryList;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.tags.NetworkTagCollection;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class PneumaticHelmetRegistry
implements IPneumaticHelmetRegistry {
    private static final PneumaticHelmetRegistry INSTANCE = new PneumaticHelmetRegistry();
    public final List<Class<? extends IEntityTrackEntry>> entityTrackEntries = new ArrayList<Class<? extends IEntityTrackEntry>>();
    public final Map<Class<? extends Entity>, Class<? extends IHackableEntity>> hackableEntities = new HashMap<Class<? extends Entity>, Class<? extends IHackableEntity>>();
    private final Map<Block, Class<? extends IHackableBlock>> hackableBlocks = new HashMap<Block, Class<? extends IHackableBlock>>();
    private final Map<Block, Class<? extends IHackableBlock>> hackableTaggedBlocks = new HashMap<Block, Class<? extends IHackableBlock>>();
    public final Set<Block> allHackableBlocks = new HashSet<Block>();
    public final Map<String, Class<? extends IHackableEntity>> stringToEntityHackables = new HashMap<String, Class<? extends IHackableEntity>>();
    public final Map<String, Class<? extends IHackableBlock>> stringToBlockHackables = new HashMap<String, Class<? extends IHackableBlock>>();
    private final Map<ResourceLocation, Class<? extends IHackableBlock>> pendingBlockTags = new HashMap<ResourceLocation, Class<? extends IHackableBlock>>();

    public static PneumaticHelmetRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerEntityTrackEntry(Class<? extends IEntityTrackEntry> entry) {
        if (entry == null) {
            throw new NullPointerException("Can't register null!");
        }
        this.entityTrackEntries.add(entry);
    }

    @Override
    public void addHackable(Class<? extends Entity> entityClazz, Class<? extends IHackableEntity> iHackable) {
        if (entityClazz == null) {
            throw new NullPointerException("Entity class is null!");
        }
        if (iHackable == null) {
            throw new NullPointerException("IHackableEntity is null!");
        }
        if (Entity.class.isAssignableFrom(iHackable)) {
            Log.warning("Entities that implement IHackableEntity shouldn't be registered as hackable! Registering entity: " + entityClazz.getCanonicalName(), new Object[0]);
        } else {
            try {
                IHackableEntity hackableEntity = iHackable.newInstance();
                if (hackableEntity.getId() != null) {
                    this.stringToEntityHackables.put(hackableEntity.getId(), iHackable);
                }
                this.hackableEntities.put(entityClazz, iHackable);
            }
            catch (InstantiationException e) {
                Log.error("Not able to register hackable entity: " + iHackable.getName() + ". Does the class have a parameterless constructor?", new Object[0]);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                Log.error("Not able to register hackable entity: " + iHackable.getName() + ". Is the class a public class?", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addHackable(Block block, Class<? extends IHackableBlock> iHackable) {
        if (block == null) {
            throw new NullPointerException("Block is null! class = " + iHackable);
        }
        if (iHackable == null) {
            throw new NullPointerException("IHackableBlock is null! block = " + block.getRegistryName());
        }
        if (Block.class.isAssignableFrom(iHackable)) {
            Log.warning("Blocks that implement IHackableBlock shouldn't be registered as hackable! Registering block: " + block.getRegistryName(), new Object[0]);
        } else {
            try {
                IHackableBlock hackableBlock = iHackable.newInstance();
                if (hackableBlock.getId() != null) {
                    this.stringToBlockHackables.put(hackableBlock.getId(), iHackable);
                }
                this.hackableBlocks.put(block, iHackable);
            }
            catch (InstantiationException e) {
                Log.error("Not able to register hackable block: " + iHackable.getName() + ". Does the class have a parameterless constructor?", new Object[0]);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                Log.error("Not able to register hackable block: " + iHackable.getName() + ". Is the class a public class?", new Object[0]);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addHackable(Tag<Block> blockTag, Class<? extends IHackableBlock> iHackable) {
        this.pendingBlockTags.put(blockTag.func_199886_b(), iHackable);
    }

    public void resolveBlockTags(NetworkTagCollection<Block> blocks) {
        this.hackableTaggedBlocks.clear();
        this.pendingBlockTags.forEach((id, hackable) -> blocks.func_199910_a(id).func_199885_a().forEach(block -> this.hackableTaggedBlocks.put((Block)block, (Class<? extends IHackableBlock>)hackable)));
        this.allHackableBlocks.clear();
        this.allHackableBlocks.addAll(this.hackableBlocks.keySet());
        this.allHackableBlocks.addAll(this.hackableTaggedBlocks.keySet());
    }

    @Override
    public List<IHackableEntity> getCurrentEntityHacks(Entity entity) {
        return (List)entity.getCapability(PNCCapabilities.HACKING_CAPABILITY).map(IHacking::getCurrentHacks).orElse(Collections.emptyList());
    }

    @Override
    public void registerBlockTrackEntry(IBlockTrackEntry entry) {
        BlockTrackEntryList.instance.trackList.add((Object)entry);
    }

    @Override
    public void registerRenderHandler(IUpgradeRenderHandler renderHandler) {
        Validate.notNull((Object)renderHandler, (String)"Render handler can't be null!", (Object[])new Object[0]);
        UpgradeRenderHandlerList.instance().addUpgradeRenderer(renderHandler);
    }

    public Class<? extends IHackableBlock> getHackableBlock(Block block) {
        return this.hackableBlocks.getOrDefault(block, this.hackableTaggedBlocks.get(block));
    }
}

