/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderBlockHighlight;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackUpgradeHandler;
import me.desht.pneumaticcraft.common.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockStart;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;

public class RenderBlockTarget {
    private final World world;
    private final BlockPos pos;
    private final RenderBlockHighlight highlightRenderer = new RenderBlockHighlight();
    public int ticksExisted = 0;
    public final WidgetAnimatedStat stat;
    private final PlayerEntity player;
    public List<String> textList = new ArrayList<String>();
    private int hackTime;
    private final BlockTrackUpgradeHandler blockTracker;
    private TileEntity te;
    private int nEntries;

    public RenderBlockTarget(World world, PlayerEntity player, BlockPos pos, TileEntity te, BlockTrackUpgradeHandler blockTracker) {
        this.world = world;
        this.player = player;
        this.pos = pos;
        this.te = te;
        this.blockTracker = blockTracker;
        String title = world.func_180495_p(pos).func_177230_c().func_149739_a();
        BlockState state = world.func_180495_p(pos);
        ItemStack stack = state.func_177230_c().getPickBlock(state, Minecraft.func_71410_x().field_71476_x, (IBlockReader)world, pos, player);
        if (!stack.func_190926_b()) {
            title = stack.func_200301_q().func_150254_d();
        }
        this.stat = new WidgetAnimatedStat(null, title, WidgetAnimatedStat.StatIcon.of(stack), 20, -20, 0x3000AA00, null, false);
        this.stat.setMinDimensionsAndReset(0, 0);
    }

    public void setTileEntity(TileEntity te) {
        this.te = te;
    }

    public boolean isTargetStillValid() {
        return this.nEntries > 0;
    }

    private List<IBlockTrackEntry> getApplicableEntries() {
        return BlockTrackEntryList.instance.getEntriesForCoordinate((IBlockReader)this.world, this.pos, this.te);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public double getDistanceToEntity(Entity entity) {
        return Math.sqrt(entity.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5));
    }

    public void maybeRefreshFromServer(List<IBlockTrackEntry> applicableTrackEntries) {
        for (IBlockTrackEntry entry : applicableTrackEntries) {
            entry.getServerUpdatePositions(this.te).forEach(p -> NetworkHandler.sendToServer(new PacketDescriptionPacketRequest((BlockPos)p)));
        }
    }

    public void update() {
        if (this.te != null && this.te.func_145837_r()) {
            this.te = null;
        }
        this.stat.tickWidget();
        List<IBlockTrackEntry> applicableTrackEntries = this.getApplicableEntries();
        this.nEntries = applicableTrackEntries.size();
        if (this.world.func_82737_E() % 100L == 7L) {
            this.maybeRefreshFromServer(applicableTrackEntries);
        }
        if (!this.world.func_175623_d(this.pos)) {
            this.textList = new ArrayList<String>();
            if (this.ticksExisted > 120) {
                this.stat.closeWindow();
                for (IBlockTrackEntry entry : applicableTrackEntries) {
                    if (this.blockTracker.countBlockTrackersOfType(entry) > entry.spamThreshold()) continue;
                    this.stat.openWindow();
                    break;
                }
                if (this.isPlayerLookingAtTarget()) {
                    this.stat.openWindow();
                    this.addBlockTrackInfo(this.textList, applicableTrackEntries);
                }
                this.stat.setText(this.textList);
            } else if (this.ticksExisted < -30) {
                this.stat.closeWindow();
                this.stat.setText(this.textList);
            }
        }
        if (this.hackTime > 0) {
            IHackableBlock hackableBlock = HackableHandler.getHackableForCoord((IBlockReader)this.world, this.pos, this.player);
            this.hackTime = hackableBlock != null ? ++this.hackTime : 0;
        }
    }

    public void render(float partialTicks) {
        double x = (double)this.pos.func_177958_n() + 0.5;
        double y = (double)this.pos.func_177956_o() + 0.5;
        double z = (double)this.pos.func_177952_p() + 0.5;
        GlStateManager.disableTexture();
        GlStateManager.pushMatrix();
        GlStateManager.clear((int)256, (boolean)Minecraft.field_142025_a);
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        if (!this.world.func_175623_d(this.pos)) {
            this.highlightRenderer.render(this.world, this.pos, partialTicks);
        }
        float targetAcquireProgress = ((float)this.ticksExisted + partialTicks) / 1.2f;
        GlStateManager.rotated((double)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78735_i), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78732_j), (double)1.0, (double)0.0, (double)0.0);
        if (this.ticksExisted <= 120 && this.ticksExisted > 50) {
            RenderProgressBar.render(0.0, 0.4, 1.8, 0.9, 0.0, targetAcquireProgress, -788529408, -805241088);
        }
        GlStateManager.enableTexture();
        if (!this.world.func_175623_d(this.pos)) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            GlStateManager.color4f((float)0.5f, (float)1.0f, (float)0.5f, (float)0.5f);
            if (this.ticksExisted > 120) {
                GlStateManager.scaled((double)0.02, (double)0.02, (double)0.02);
                this.stat.render(-1, -1, partialTicks);
            } else if (this.ticksExisted > 50) {
                GlStateManager.scaled((double)0.02, (double)0.02, (double)0.02);
                fontRenderer.func_211126_b("Acquiring Target...", 0.0f, 0.0f, 0x7F7F7F);
                fontRenderer.func_211126_b((int)targetAcquireProgress + "%", 37.0f, 28.0f, 12032);
            } else if (this.ticksExisted < -30) {
                GlStateManager.scaled((double)0.03, (double)0.03, (double)0.03);
                this.stat.render(-1, -1, partialTicks);
                fontRenderer.func_211126_b("Lost Target!", 0.0f, 0.0f, 0xFF0000);
            }
        }
        GlStateManager.popMatrix();
    }

    private boolean isInitialized() {
        return this.ticksExisted >= 120;
    }

    private void addBlockTrackInfo(List<String> textList, List<IBlockTrackEntry> entries) {
        entries.forEach(e -> e.addInformation(this.world, this.pos, this.te, this.isPlayerLookingAtTarget() ? this.blockTracker.getFocusedFace() : null, textList));
    }

    private boolean isPlayerLookingAtTarget() {
        return this.pos.equals((Object)this.blockTracker.getFocusedPos());
    }

    public void hack() {
        IHackableBlock block;
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && (block = HackableHandler.getHackableForCoord((IBlockReader)this.world, this.pos, this.player)) != null && (this.hackTime == 0 || this.hackTime > block.getHackTime((IBlockReader)this.world, this.pos, this.player))) {
            NetworkHandler.sendToServer(new PacketHackingBlockStart(this.pos));
        }
    }

    public void onHackConfirmServer() {
        this.hackTime = 1;
    }

    public int getHackTime() {
        return this.hackTime;
    }

    public boolean scroll(GuiScreenEvent.MouseScrollEvent.Post event) {
        if (this.isInitialized() && this.isPlayerLookingAtTarget()) {
            return this.stat.mouseScrolled(event.getMouseX(), event.getMouseY(), event.getScrollDelta());
        }
        return false;
    }
}

