/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderCoordWireframe;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RenderDroneAI {
    private final EntityDrone drone;
    private final List<Pair<RenderCoordWireframe, Integer>> blackListWireframes = new ArrayList<Pair<RenderCoordWireframe, Integer>>();
    private float progress = 0.0f;
    private BlockPos oldPos;
    private BlockPos pos;

    public RenderDroneAI(EntityDrone drone) {
        this.drone = drone;
        this.update();
    }

    public void update() {
        BlockPos lastPos = this.pos;
        this.pos = this.drone.getTargetedBlock();
        if (this.pos != null) {
            if (lastPos == null) {
                this.oldPos = this.pos;
            } else if (!this.pos.equals((Object)lastPos)) {
                this.progress = 0.0f;
                this.oldPos = lastPos;
            }
        } else {
            this.oldPos = null;
        }
        this.progress = Math.min((float)Math.PI, this.progress + 0.1f);
        Iterator<Pair<RenderCoordWireframe, Integer>> iterator = this.blackListWireframes.iterator();
        while (iterator.hasNext()) {
            Pair<RenderCoordWireframe, Integer> wireframe = iterator.next();
            ++((RenderCoordWireframe)wireframe.getKey()).ticksExisted;
            wireframe.setValue((Object)((Integer)wireframe.getValue() - 1));
            if ((Integer)wireframe.getValue() > 0) continue;
            iterator.remove();
        }
    }

    public void render(float partialTicks) {
        IProgWidget activeWidget;
        for (Pair<RenderCoordWireframe, Integer> wireframe : this.blackListWireframes) {
            ((RenderCoordWireframe)wireframe.getKey()).render(partialTicks);
        }
        if (ItemPneumaticArmor.isPlayerDebuggingEntity(ClientUtils.getClientPlayer(), (Entity)this.drone) && (activeWidget = this.drone.getActiveWidget()) != null) {
            double z;
            double y;
            double x;
            if (this.pos != null) {
                x = this.getInterpolated(this.pos.func_177958_n(), this.oldPos.func_177958_n(), partialTicks);
                y = this.getInterpolated(this.pos.func_177956_o(), this.oldPos.func_177956_o(), partialTicks);
                z = this.getInterpolated(this.pos.func_177952_p(), this.oldPos.func_177952_p(), partialTicks);
            } else {
                x = MathHelper.func_219803_d((double)partialTicks, (double)this.drone.field_70169_q, (double)this.drone.field_70165_t);
                y = MathHelper.func_219803_d((double)partialTicks, (double)this.drone.field_70167_r, (double)this.drone.field_70163_u) + 0.5;
                z = MathHelper.func_219803_d((double)partialTicks, (double)this.drone.field_70166_s, (double)this.drone.field_70161_v);
            }
            GlStateManager.enableTexture();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)x, (double)(y + 0.5), (double)z);
            GlStateManager.scaled((double)0.01, (double)0.01, (double)0.01);
            GlStateManager.rotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
            GlStateManager.rotated((double)(180.0f + Minecraft.func_71410_x().func_175598_ae().field_78735_i), (double)0.0, (double)1.0, (double)0.0);
            activeWidget.render();
            GlStateManager.popMatrix();
            GlStateManager.disableBlend();
        }
    }

    private double getInterpolated(double newPos, double oldPos, float partialTicks) {
        double cosProgress = 0.5 - 0.5 * (double)MathHelper.func_76134_b((float)((float)Math.min(Math.PI, (double)(this.progress + partialTicks * 0.1f))));
        return oldPos + (newPos - oldPos) * cosProgress;
    }

    public void addBlackListEntry(World world, BlockPos pos) {
        this.blackListWireframes.add((Pair<RenderCoordWireframe, Integer>)new MutablePair((Object)new RenderCoordWireframe(world, pos), (Object)60));
    }
}

