/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiDroneDebuggerOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderDroneAI;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderTargetCircle;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.entity_tracker.EntityTrackHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityStart;
import me.desht.pneumaticcraft.common.network.PacketUpdateDebuggingDrone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.GuiScreenEvent;

public class RenderEntityTarget {
    public final Entity entity;
    private final RenderTargetCircle circle1;
    private final RenderTargetCircle circle2;
    public int ticksExisted = 0;
    private float oldSize;
    private final WidgetAnimatedStat stat;
    private boolean didMakeLockSound;
    public boolean isLookingAtTarget;
    private List<String> textList = new ArrayList<String>();
    private final List<IEntityTrackEntry> trackEntries;
    private int hackTime;

    public RenderEntityTarget(Entity entity) {
        this.entity = entity;
        this.trackEntries = EntityTrackHandler.getTrackersForEntity(entity);
        this.circle1 = new RenderTargetCircle();
        this.circle2 = new RenderTargetCircle();
        this.stat = new WidgetAnimatedStat(null, entity.func_145748_c_().func_150254_d(), WidgetAnimatedStat.StatIcon.NONE, 20, -20, 0x3000AA00, null, false);
        this.stat.setMinDimensionsAndReset(0, 0);
    }

    public RenderDroneAI getDroneAIRenderer() {
        for (IEntityTrackEntry tracker : this.trackEntries) {
            if (!(tracker instanceof EntityTrackHandler.EntityTrackEntryDrone)) continue;
            return ((EntityTrackHandler.EntityTrackEntryDrone)tracker).getDroneAIRenderer();
        }
        throw new IllegalStateException("[RenderTarget] Drone entity, but no drone AI Renderer?");
    }

    public void update() {
        this.stat.tickWidget();
        this.stat.setTitle(this.entity.func_145748_c_().func_150254_d());
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (this.ticksExisted >= 30 && !this.didMakeLockSound) {
            this.didMakeLockSound = true;
            player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)ModSounds.HUD_ENTITY_LOCK.get(), SoundCategory.PLAYERS, 0.1f, 1.0f, true);
        }
        boolean tagged = ItemPneumaticArmor.isPlayerDebuggingEntity((PlayerEntity)player, this.entity);
        this.circle1.setRenderingAsTagged(tagged);
        this.circle2.setRenderingAsTagged(tagged);
        this.circle1.update();
        this.circle2.update();
        for (IEntityTrackEntry tracker : this.trackEntries) {
            tracker.update(this.entity);
        }
        this.isLookingAtTarget = this.isPlayerLookingAtTarget();
        if (this.hackTime > 0) {
            IHackableEntity hackableEntity = HackableHandler.getHackableForEntity(this.entity, ClientUtils.getClientPlayer());
            this.hackTime = hackableEntity != null ? ++this.hackTime : 0;
        }
    }

    public boolean isInitialized() {
        return this.ticksExisted > 120;
    }

    public void render(float partialTicks, boolean justRenderWhenHovering) {
        float blue;
        float green;
        float red;
        for (IEntityTrackEntry tracker : this.trackEntries) {
            tracker.render(this.entity, partialTicks);
        }
        double x = this.entity.field_70169_q + (this.entity.field_70165_t - this.entity.field_70169_q) * (double)partialTicks;
        double y = this.entity.field_70167_r + (this.entity.field_70163_u - this.entity.field_70167_r) * (double)partialTicks + (double)this.entity.func_213302_cg() / 2.0;
        double z = this.entity.field_70166_s + (this.entity.field_70161_v - this.entity.field_70166_s) * (double)partialTicks;
        GlStateManager.depthMask((boolean)false);
        GlStateManager.disableDepthTest();
        GlStateManager.disableCull();
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.pushMatrix();
        GlStateManager.clear((int)256, (boolean)Minecraft.field_142025_a);
        float alpha = 0.5f;
        if (this.entity instanceof EntityDrone) {
            red = 1.0f;
            green = 1.0f;
            blue = 0.0f;
        } else if (this.entity instanceof IMob) {
            red = 1.0f;
            green = 0.0f;
            blue = 0.0f;
        } else if (this.entity instanceof HangingEntity) {
            red = 0.0f;
            green = 1.0f;
            blue = 1.0f;
        } else {
            red = 0.0f;
            green = 1.0f;
            blue = 0.0f;
        }
        float size = this.entity.func_213302_cg() * 0.5f;
        if (this.ticksExisted < 60) {
            size += 5.0f - (float)Math.abs(this.ticksExisted) * 0.083f;
            alpha = (float)Math.abs(this.ticksExisted) * 0.005f;
        }
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.rotated((double)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78735_i), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78732_j), (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.color4f((float)red, (float)green, (float)blue, (float)alpha);
        float renderSize = this.oldSize + (size - this.oldSize) * partialTicks;
        this.circle1.render(renderSize, partialTicks);
        this.circle2.render((double)renderSize + 0.2, partialTicks);
        float targetAcquireProgress = ((float)this.ticksExisted + partialTicks - 50.0f) / 0.7f;
        if (this.ticksExisted <= 120 && this.ticksExisted > 50) {
            RenderProgressBar.render(0.0, 0.4, 1.8, 0.9, 0.0, targetAcquireProgress, -788529408, -805241088);
        }
        GlStateManager.enableTexture();
        FontRenderer fontRenderer = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
        GlStateManager.scaled((double)0.02, (double)0.02, (double)0.02);
        GlStateManager.color4f((float)red, (float)green, (float)blue, (float)alpha);
        if (this.ticksExisted > 120) {
            if (justRenderWhenHovering && !this.isLookingAtTarget) {
                this.stat.closeWindow();
            } else {
                this.stat.openWindow();
            }
            this.textList = new ArrayList<String>();
            for (IEntityTrackEntry tracker : this.trackEntries) {
                tracker.addInfo(this.entity, this.textList, this.isLookingAtTarget);
            }
            this.stat.setText(this.textList);
            this.stat.render(-1, -1, partialTicks);
        } else if (this.ticksExisted > 50) {
            fontRenderer.func_211126_b("Acquiring Target...", 0.0f, 0.0f, 0x7F7F7F);
            fontRenderer.func_211126_b((int)targetAcquireProgress + "%", 37.0f, 28.0f, 12032);
        } else if (this.ticksExisted < -30) {
            this.stat.closeWindow();
            this.stat.render(-1, -1, partialTicks);
            fontRenderer.func_211126_b("Lost Target!", 0.0f, 0.0f, 0xFF0000);
        }
        GlStateManager.popMatrix();
        GlStateManager.enableCull();
        GlStateManager.enableDepthTest();
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        this.oldSize = size;
    }

    public List<String> getEntityText() {
        return this.textList;
    }

    private boolean isPlayerLookingAtTarget() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Vec3d vec3 = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec31 = new Vec3d(this.entity.field_70165_t - player.field_70165_t, this.entity.func_174813_aQ().field_72338_b + (double)(this.entity.func_213302_cg() / 2.0f) - (player.field_70163_u + (double)player.func_70047_e()), this.entity.field_70161_v - player.field_70161_v);
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        return d1 > 1.0 - 0.05 / d0;
    }

    public void hack() {
        IHackableEntity hackable;
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && (hackable = HackableHandler.getHackableForEntity(this.entity, ClientUtils.getClientPlayer())) != null && (this.hackTime == 0 || this.hackTime > hackable.getHackTime(this.entity, ClientUtils.getClientPlayer()))) {
            NetworkHandler.sendToServer(new PacketHackingEntityStart(this.entity));
        }
    }

    public void selectAsDebuggingTarget() {
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && this.entity instanceof EntityDrone) {
            GuiDroneDebuggerOptions.clearAreaShowWidgetId();
            if (ItemPneumaticArmor.isPlayerDebuggingEntity(ClientUtils.getClientPlayer(), this.entity)) {
                NetworkHandler.sendToServer(new PacketUpdateDebuggingDrone(-1));
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.SCI_FI.get(), 1.0f, 2.0f);
            } else {
                NetworkHandler.sendToServer(new PacketUpdateDebuggingDrone(this.entity.func_145782_y()));
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.HUD_ENTITY_LOCK.get(), 1.0f, 2.0f);
            }
        }
    }

    public void onHackConfirmServer() {
        this.hackTime = 1;
    }

    public int getHackTime() {
        return this.hackTime;
    }

    public boolean scroll(GuiScreenEvent.MouseScrollEvent.Post event) {
        if (this.isInitialized() && this.isPlayerLookingAtTarget()) {
            return this.stat.mouseScrolled(event.getMouseX(), event.getMouseY(), event.getScrollDelta());
        }
        return false;
    }
}

