/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class RenderSearchItemBlock {
    private final BlockPos pos;
    private final World world;
    private long lastCheck = 0L;
    private int cachedAmount;

    public RenderSearchItemBlock(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public int getSearchedItemCount() {
        if (this.world.func_82737_E() - this.lastCheck >= 20L) {
            this.cachedAmount = 0;
            IOHelper.getInventoryForTE(this.world.func_175625_s(this.pos)).ifPresent(handler -> {
                int itemCount = 0;
                Item searchedItem = ItemPneumaticArmor.getSearchedItem(ClientUtils.getWornArmor(EquipmentSlotType.HEAD));
                if (searchedItem != null) {
                    for (int l = 0; l < handler.getSlots(); ++l) {
                        if (handler.getStackInSlot(l).func_190926_b()) continue;
                        itemCount += RenderSearchItemBlock.getSearchedItemCount(handler.getStackInSlot(l), searchedItem);
                    }
                }
                this.cachedAmount = itemCount;
            });
            this.lastCheck = this.world.func_82737_E();
        }
        return this.cachedAmount;
    }

    public static int getSearchedItemCount(ItemStack stack, Item item) {
        int itemCount = 0;
        if (stack.func_77973_b() == item) {
            itemCount += stack.func_190916_E();
        }
        List<ItemStack> inventoryItems = PneumaticCraftUtils.getStacksInItem(stack);
        for (ItemStack s : inventoryItems) {
            itemCount += RenderSearchItemBlock.getSearchedItemCount(s, item);
        }
        return itemCount;
    }

    public void renderSearchBlock(int totalCount, float partialTicks) {
        RenderSearchItemBlock.renderSearch((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, this.getSearchedItemCount(), totalCount, partialTicks);
    }

    public static void renderSearch(double x, double y, double z, int itemCount, int totalCount, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        float f = ((float)(mc.field_71441_e.func_82737_E() & 0x1FL) + partialTicks) / 5.092f;
        GlStateManager.color4f((float)0.0f, (float)1.0f, (float)0.0f, (float)(0.65f + MathHelper.func_76126_a((float)f) * 0.15f));
        GlStateManager.rotated((double)(180.0f - mc.func_175598_ae().field_78735_i), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)(180.0f - mc.func_175598_ae().field_78732_j), (double)1.0, (double)0.0, (double)0.0);
        double ratio = (double)itemCount / (double)totalCount;
        double diff = (1.0 - ratio) / 1.5;
        double size = 1.0 - diff;
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b(-size, size, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        wr.func_181662_b(-size, -size, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        wr.func_181662_b(size, -size, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        wr.func_181662_b(size, size, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.popMatrix();
    }
}

