/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public class RenderTargetCircle {
    private double oldRotationAngle;
    private double rotationAngle = 0.0;
    private double rotationSpeed = 0.0;
    private double rotationAcceleration = 0.0;
    private final Random rand = new Random();
    private boolean renderAsTagged;

    RenderTargetCircle() {
    }

    void setRenderingAsTagged(boolean tagged) {
        this.renderAsTagged = tagged;
    }

    public void update() {
        this.oldRotationAngle = this.rotationAngle;
        if (this.rand.nextInt(15) == 0) {
            this.rotationAcceleration = (this.rand.nextDouble() - 0.5) / 2.5;
        }
        this.rotationSpeed += this.rotationAcceleration;
        double maxSpeed = 8.0;
        if (this.rotationSpeed >= maxSpeed) {
            this.rotationSpeed = maxSpeed;
        }
        if (this.rotationSpeed <= -maxSpeed) {
            this.rotationSpeed = -maxSpeed;
        }
        this.rotationAngle += this.rotationSpeed;
    }

    public void render(double size, float partialTicks) {
        double renderRotationAngle = this.oldRotationAngle + (this.rotationAngle - this.oldRotationAngle) * (double)partialTicks;
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GL11.glEnable((int)2848);
        GlStateManager.rotated((double)((float)renderRotationAngle), (double)0.0, (double)0.0, (double)1.0);
        for (int j = 0; j < 2; ++j) {
            int i;
            wr.func_181668_a(5, DefaultVertexFormats.field_181705_e);
            for (i = 0; i < 125; ++i) {
                wr.func_181662_b(PneumaticCraftUtils.cos[i] * size, PneumaticCraftUtils.sin[i] * size, 0.0).func_181675_d();
                wr.func_181662_b(PneumaticCraftUtils.cos[i] * (size + 0.1), PneumaticCraftUtils.sin[i] * (size + 0.1), 0.0).func_181675_d();
            }
            Tessellator.func_178181_a().func_78381_a();
            if (this.renderAsTagged) {
                GlStateManager.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                wr.func_181668_a(2, DefaultVertexFormats.field_181705_e);
                for (i = 0; i < 125; ++i) {
                    wr.func_181662_b(PneumaticCraftUtils.cos[i] * size, PneumaticCraftUtils.sin[i] * size, 0.0).func_181675_d();
                }
                for (i = 124; i >= 0; --i) {
                    wr.func_181662_b(PneumaticCraftUtils.cos[i] * (size + 0.1), PneumaticCraftUtils.sin[i] * (size + 0.1), 0.0).func_181675_d();
                }
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)0.0f, (float)0.5f);
            }
            GlStateManager.rotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        }
        GL11.glDisable((int)2848);
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
    }
}

