/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.google.common.base.Strings;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiAirConditionerOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.common.config.aux.ArmorHUDLayout;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AirConUpgradeHandler
extends IUpgradeRenderHandler.SimpleToggleableRenderHandler {
    private static final int MAX_AC = 20;
    public static int deltaTemp;
    private static int currentAC;
    @OnlyIn(value=Dist.CLIENT)
    private WidgetAnimatedStat acStat;

    @Override
    public String getUpgradeID() {
        return "airConditioning";
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[]{EnumUpgrade.AIR_CONDITIONING};
    }

    @Override
    public int getMaxInstallableUpgrades(EnumUpgrade upgrade) {
        return 4;
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.CHEST;
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new GuiAirConditionerOptions(screen, this);
    }

    @Override
    public void update(PlayerEntity player, int rangeUpgrades) {
        super.update(player, rangeUpgrades);
        if ((player.field_70170_p.func_82737_E() & 3L) == 0L) {
            if (currentAC < deltaTemp) {
                ++currentAC;
            } else if (currentAC > deltaTemp) {
                --currentAC;
            }
        }
        if (this.acStat.isClicked()) {
            int ac = MathHelper.func_76125_a((int)currentAC, (int)-20, (int)20);
            String bar = (ac < 0 ? TextFormatting.BLUE : TextFormatting.GOLD) + Strings.repeat((String)"|", (int)Math.abs(ac)) + TextFormatting.DARK_GRAY + Strings.repeat((String)"|", (int)(20 - Math.abs(ac)));
            this.acStat.setTitle(TextFormatting.YELLOW + "A/C: " + bar);
            this.acStat.setBackgroundColor(ac < 0 ? 805339391 : (ac == 0 ? 0x3000AA00 : 822071296));
        }
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.acStat == null) {
            this.acStat = new WidgetAnimatedStat(null, "", WidgetAnimatedStat.StatIcon.NONE, 0x3000AA00, null, ArmorHUDLayout.INSTANCE.airConStat);
            this.acStat.setMinDimensionsAndReset(0, 0);
        }
        return this.acStat;
    }

    @Override
    public void onResolutionChanged() {
        this.acStat = null;
    }

    static {
        currentAC = 0;
    }
}

