/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiCoordinateTrackerOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderCoordWireframe;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderNavigator;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.ai.EntityPathNavigateDrone;
import me.desht.pneumaticcraft.common.config.ClientConfig;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModEntities;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketCoordTrackUpdate;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CoordTrackUpgradeHandler
implements IUpgradeRenderHandler {
    public static final int SEARCH_RANGE = 150;
    private RenderCoordWireframe coordTracker;
    private RenderNavigator navigator;
    public boolean isListeningToCoordTrackerSetting = false;
    public boolean pathEnabled;
    public boolean wirePath;
    public boolean xRayEnabled;
    public ClientConfig.PathUpdateSetting pathUpdateSetting = ClientConfig.PathUpdateSetting.NORMAL;
    private int pathCalculateCooldown;
    private int noPathCooldown;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getUpgradeID() {
        return "coordinateTracker";
    }

    @Override
    public void initConfig() {
        this.pathEnabled = PNCConfig.Client.Armor.pathEnabled;
        this.wirePath = PNCConfig.Client.Armor.wirePath;
        this.xRayEnabled = PNCConfig.Client.Armor.xRayEnabled;
        this.pathUpdateSetting = PNCConfig.Client.Armor.pathUpdateSetting;
    }

    @Override
    public void saveToConfig() {
        ConfigHelper.updateCoordTracker(this.pathEnabled, this.wirePath, this.xRayEnabled, this.pathUpdateSetting);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void update(PlayerEntity player, int rangeUpgrades) {
        if (this.coordTracker != null) {
            ++this.coordTracker.ticksExisted;
        } else {
            BlockPos pos = ItemPneumaticArmor.getCoordTrackerPos(ClientUtils.getWornArmor(EquipmentSlotType.HEAD), player.field_70170_p);
            if (pos != null) {
                this.coordTracker = new RenderCoordWireframe(player.field_70170_p, pos);
                this.navigator = new RenderNavigator(this.coordTracker.world, this.coordTracker.pos);
            }
        }
        if (this.noPathCooldown > 0) {
            --this.noPathCooldown;
        }
        if (this.navigator != null && PNCConfig.Client.Armor.pathEnabled && this.noPathCooldown == 0 && --this.pathCalculateCooldown <= 0) {
            this.navigator.updatePath();
            if (!this.navigator.tracedToDestination()) {
                this.noPathCooldown = 100;
            }
            this.pathCalculateCooldown = PNCConfig.Client.Armor.pathUpdateSetting.getTicks();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render3D(float partialTicks) {
        if (this.coordTracker != null) {
            if (Minecraft.func_71410_x().field_71439_g.field_70170_p.func_201675_m().func_186058_p() != this.coordTracker.world.func_201675_m().func_186058_p()) {
                return;
            }
            this.coordTracker.render(partialTicks);
            if (PNCConfig.Client.Armor.pathEnabled && this.navigator != null) {
                this.navigator.render(PNCConfig.Client.Armor.wirePath, PNCConfig.Client.Armor.xRayEnabled, partialTicks);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render2D(float partialTicks, boolean upgradeEnabled) {
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[]{EnumUpgrade.COORDINATE_TRACKER};
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, PlayerEntity player) {
        return 1.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void reset() {
        this.coordTracker = null;
        this.navigator = null;
    }

    @SubscribeEvent
    public boolean onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().field_72995_K && this.isListeningToCoordTrackerSetting) {
            this.isListeningToCoordTrackerSetting = false;
            Direction dir = event.getFace();
            if (dir == null) {
                return false;
            }
            this.reset();
            ItemStack stack = event.getPlayer().func_184582_a(EquipmentSlotType.HEAD);
            if (!stack.func_190926_b()) {
                GlobalPos gPos = GlobalPos.func_218179_a((DimensionType)event.getWorld().func_201675_m().func_186058_p(), (BlockPos)event.getPos().func_177972_a(dir));
                ItemPneumaticArmor.setCoordTrackerPos(stack, gPos);
                NetworkHandler.sendToServer(new PacketCoordTrackUpdate(event.getEntity().field_70170_p, event.getPos().func_177972_a(dir)));
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public EnumNavigationResult navigateToSurface(PlayerEntity player) {
        BlockPos pathPos;
        PathPoint pathPoint;
        int i;
        World world = player.field_70170_p;
        BlockPos navigatingPos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos((Entity)player));
        MobEntity e = PneumaticCraftUtils.createDummyEntity(player);
        Path path = e.func_70661_as().func_179680_a(navigatingPos, 0);
        if (path != null) {
            for (i = 0; i < path.func_75874_d(); ++i) {
                pathPoint = path.func_75877_a(i);
                pathPos = new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
                if (!world.func_175710_j(pathPos)) continue;
                this.coordTracker = new RenderCoordWireframe(world, pathPos);
                this.navigator = new RenderNavigator(world, pathPos);
                return EnumNavigationResult.EASY_PATH;
            }
        }
        if ((path = CoordTrackUpgradeHandler.getDronePath(player, navigatingPos)) != null) {
            for (i = 0; i < path.func_75874_d(); ++i) {
                pathPoint = path.func_75877_a(i);
                pathPos = new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
                if (!world.func_175710_j(pathPos)) continue;
                this.coordTracker = new RenderCoordWireframe(world, pathPos);
                this.navigator = new RenderNavigator(world, pathPos);
                return EnumNavigationResult.DRONE_PATH;
            }
        }
        return EnumNavigationResult.NO_PATH;
    }

    public static Path getDronePath(PlayerEntity player, BlockPos pos) {
        World world = player.field_70170_p;
        EntityDrone drone = new EntityDrone((EntityType<? extends EntityDrone>)((EntityType)ModEntities.DRONE.get()), world);
        drone.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        return new EntityPathNavigateDrone(drone, world).func_179680_a(pos, 0);
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new GuiCoordinateTrackerOptions(screen, this);
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.HEAD;
    }

    @Override
    public WidgetAnimatedStat getAnimatedStat() {
        return null;
    }

    public static enum EnumNavigationResult {
        NO_PATH,
        EASY_PATH,
        DRONE_PATH;

    }
}

