/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiHelmetMainOptions;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiHelmetMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.common.config.aux.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MainHelmetHandler
implements IUpgradeRenderHandler {
    private WidgetAnimatedStat powerStat;
    public WidgetAnimatedStat testMessageStat;

    @Override
    public String getUpgradeID() {
        return "coreComponents";
    }

    @Override
    public void update(PlayerEntity player, int rangeUpgrades) {
        List<String> l = Arrays.stream(UpgradeRenderHandlerList.ARMOR_SLOTS).map(slot -> this.getPressureStr(player, (EquipmentSlotType)slot)).collect(Collectors.toList());
        this.powerStat.setText(l);
    }

    private String getPressureStr(PlayerEntity player, EquipmentSlotType slot) {
        if (!ItemPneumaticArmor.isPneumaticArmorPiece(player, slot)) {
            return "-";
        }
        float pressure = CommonArmorHandler.getHandlerForPlayer(player).getArmorPressure(slot);
        TextFormatting colour = pressure < 0.5f ? TextFormatting.RED : (pressure < 2.0f ? TextFormatting.GOLD : (pressure < 4.0f ? TextFormatting.YELLOW : TextFormatting.GREEN));
        return colour.toString() + String.format("%5.2f", Float.valueOf(pressure));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render3D(float partialTicks) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render2D(float partialTicks, boolean helmetEnabled) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.powerStat == null) {
            this.powerStat = new WidgetAnimatedStat(null, "", WidgetAnimatedStat.StatIcon.NONE, 0x3000AA00, null, ArmorHUDLayout.INSTANCE.powerStat);
            this.powerStat.setLineSpacing(15);
            this.powerStat.setWidgetOffsets(-18, 0);
            for (EquipmentSlotType slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                WidgetButtonExtended pressureButton = new WidgetButtonExtended(0, 5 + (3 - slot.func_188454_b()) * 15, 18, 18, "");
                ItemStack stack = GuiHelmetMainScreen.ARMOR_STACKS[slot.func_188454_b()];
                pressureButton.setVisible(false);
                pressureButton.setRenderStacks(stack);
                this.powerStat.addSubWidget((Widget)pressureButton);
            }
            this.powerStat.setMinDimensionsAndReset(0, 0);
            this.powerStat.openWindow();
        }
        return this.powerStat;
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[0];
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, PlayerEntity player) {
        return 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void reset() {
        this.powerStat = null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new GuiHelmetMainOptions(screen, this);
    }

    @Override
    public float getMinimumPressure() {
        return -1.0f;
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.HEAD;
    }

    @Override
    public void onResolutionChanged() {
        this.powerStat = null;
    }
}

