/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiSearchUpgradeOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderSearchItemBlock;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.aux.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SearchUpgradeHandler
implements IUpgradeRenderHandler {
    private int totalSearchedItemCount;
    private int itemSearchCount;
    private int ticksExisted;
    private final Map<ItemEntity, Integer> searchedItems = new HashMap<ItemEntity, Integer>();
    private final Map<BlockPos, RenderSearchItemBlock> trackedInventories = new HashMap<BlockPos, RenderSearchItemBlock>();
    @OnlyIn(value=Dist.CLIENT)
    private WidgetAnimatedStat searchInfo;
    private ItemStack searchedStack = ItemStack.field_190927_a;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getUpgradeID() {
        return "itemSearcher";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void update(PlayerEntity player, int rangeUpgrades) {
        ++this.ticksExisted;
        if ((this.ticksExisted & 0xF) == 0) {
            int blockSearchCount = this.trackInventoryCounts(rangeUpgrades);
            this.searchedItems.entrySet().removeIf(e -> !((ItemEntity)e.getKey()).func_70089_S());
            this.totalSearchedItemCount = this.itemSearchCount + blockSearchCount;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render3D(float partialTicks) {
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableTexture();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.disableDepthTest();
        GlStateManager.disableCull();
        GlStateManager.enableBlend();
        GlStateManager.clear((int)256, (boolean)Minecraft.field_142025_a);
        GlStateManager.blendFunc((int)770, (int)771);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.GLOW_RESOURCE);
        this.searchedItems.forEach((item, value) -> {
            float height = MathHelper.func_76126_a((float)(((float)item.func_174872_o() + partialTicks) / 10.0f + item.field_70290_d)) * 0.1f + 0.2f;
            RenderSearchItemBlock.renderSearch(item.field_70142_S + (item.field_70165_t - item.field_70142_S) * (double)partialTicks, item.field_70137_T + (item.field_70163_u - item.field_70137_T) * (double)partialTicks + (double)height, item.field_70136_U + (item.field_70161_v - item.field_70136_U) * (double)partialTicks, value, this.totalSearchedItemCount, partialTicks);
        });
        this.trackedInventories.values().forEach(entry -> entry.renderSearchBlock(this.totalSearchedItemCount, partialTicks));
        GlStateManager.enableCull();
        GlStateManager.enableDepthTest();
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture();
        GlStateManager.disableRescaleNormal();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render2D(float partialTicks, boolean helmetEnabled) {
        Item item = ItemPneumaticArmor.getSearchedItem(ClientUtils.getWornArmor(EquipmentSlotType.HEAD));
        ArrayList<String> textList = new ArrayList<String>();
        if (item == null) {
            textList.add("press '" + KeyHandler.getInstance().keybindOpenOptions.func_151464_g() + "' to configure");
        } else {
            if (this.searchedStack.func_77973_b() != item) {
                this.searchedStack = new ItemStack((IItemProvider)item);
            }
            textList.add(this.searchedStack.func_200301_q() + " (" + this.totalSearchedItemCount + " found)");
        }
        this.searchInfo.setText(textList);
    }

    @Override
    public EnumUpgrade[] getRequiredUpgrades() {
        return new EnumUpgrade[]{EnumUpgrade.SEARCH};
    }

    private int trackInventoryCounts(int rangeUpgrades) {
        int blockSearchCount = 0;
        int blockTrackRange = 30 + Math.min(rangeUpgrades, 5) * 5;
        int blockTrackRangeSq = blockTrackRange * blockTrackRange;
        PlayerEntity player = ClientUtils.getClientPlayer();
        ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, RenderSearchItemBlock> entry : this.trackedInventories.entrySet()) {
            int nItems;
            int n = nItems = entry.getKey().func_177951_i((Vec3i)player.func_180425_c()) < (double)blockTrackRangeSq ? entry.getValue().getSearchedItemCount() : 0;
            if (nItems == 0) {
                toRemove.add(entry.getKey());
            }
            blockSearchCount += nItems;
        }
        toRemove.forEach(this.trackedInventories::remove);
        return blockSearchCount;
    }

    void trackItemEntities(PlayerEntity player, int rangeUpgrades, boolean handlerEnabled) {
        this.searchedItems.clear();
        this.itemSearchCount = 0;
        if (!handlerEnabled) {
            return;
        }
        Item searchedItem = ItemPneumaticArmor.getSearchedItem(ClientUtils.getWornArmor(EquipmentSlotType.HEAD));
        List items = player.field_70170_p.func_217357_a(ItemEntity.class, EntityTrackUpgradeHandler.getAABBFromRange(player, rangeUpgrades));
        for (ItemEntity itemEntity : items) {
            if (itemEntity.func_92059_d().func_190926_b() || searchedItem == null) continue;
            if (itemEntity.func_92059_d().func_77973_b() == searchedItem) {
                this.searchedItems.put(itemEntity, itemEntity.func_92059_d().func_190916_E());
                this.itemSearchCount += itemEntity.func_92059_d().func_190916_E();
                continue;
            }
            List<ItemStack> inventoryItems = PneumaticCraftUtils.getStacksInItem(itemEntity.func_92059_d());
            int itemCount = 0;
            for (ItemStack inventoryItem : inventoryItems) {
                if (inventoryItem.func_77973_b() != searchedItem) continue;
                itemCount += inventoryItem.func_190916_E();
            }
            if (itemCount <= 0) continue;
            this.searchedItems.put(itemEntity, itemCount);
            this.itemSearchCount += itemCount;
        }
    }

    void checkInventoryForItems(TileEntity te, Direction face, boolean handlerEnabled) {
        if (!handlerEnabled) {
            this.trackedInventories.clear();
        } else {
            Item searchedItem = ItemPneumaticArmor.getSearchedItem(ClientUtils.getWornArmor(EquipmentSlotType.HEAD));
            if (searchedItem != null) {
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).ifPresent(handler -> {
                    if (this.checkForItems((IItemHandler)handler, searchedItem)) {
                        this.trackedInventories.put(te.func_174877_v(), new RenderSearchItemBlock(te.func_145831_w(), te.func_174877_v()));
                    }
                });
            }
        }
    }

    private boolean checkForItems(IItemHandler handler, Item item) {
        for (int l = 0; l < handler.getSlots(); ++l) {
            int items;
            if (handler.getStackInSlot(l).func_190926_b() || (items = RenderSearchItemBlock.getSearchedItemCount(handler.getStackInSlot(l), item)) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void reset() {
        this.trackedInventories.clear();
        this.searchedItems.clear();
        this.ticksExisted = 0;
        this.searchInfo = null;
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, PlayerEntity player) {
        return 1.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new GuiSearchUpgradeOptions(screen, this);
    }

    @Override
    public EquipmentSlotType getEquipmentSlot() {
        return EquipmentSlotType.HEAD;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetAnimatedStat getAnimatedStat() {
        if (this.searchInfo == null) {
            WidgetAnimatedStat.StatIcon icon = WidgetAnimatedStat.StatIcon.of(EnumUpgrade.SEARCH.getItemStack());
            this.searchInfo = new WidgetAnimatedStat(null, "Currently searching for:", icon, 0x3000AA00, null, ArmorHUDLayout.INSTANCE.itemSearchStat);
            this.searchInfo.setMinDimensionsAndReset(0, 0);
        }
        return this.searchInfo;
    }

    @Override
    public void onResolutionChanged() {
        this.searchInfo = null;
    }
}

