/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;

public class RenderUtils {
    public static void glColorHex(int color, float brightness) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float div = 255.0f / brightness;
        float red = (float)(color >> 16 & 0xFF) / div;
        float green = (float)(color >> 8 & 0xFF) / div;
        float blue = (float)(color & 0xFF) / div;
        GlStateManager.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glColorHex(int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glColorHex(int color, int alpha) {
        RenderUtils.glColorHex(color | alpha << 24);
    }

    public static void render3DArrow() {
        double cos;
        double sin;
        int i;
        GlStateManager.disableTexture();
        double arrowTipLength = 0.2;
        double arrowTipRadius = 0.25;
        double baseLength = 0.3;
        double baseRadius = 0.15;
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(9, DefaultVertexFormats.field_181705_e);
        for (i = PneumaticCraftUtils.sin.length - 1; i >= 0; --i) {
            sin = PneumaticCraftUtils.sin[i] * baseRadius;
            cos = PneumaticCraftUtils.cos[i] * baseRadius;
            wr.func_181662_b(sin, 0.0, cos).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        wr.func_181668_a(9, DefaultVertexFormats.field_181705_e);
        for (i = PneumaticCraftUtils.sin.length - 1; i >= 0; --i) {
            sin = PneumaticCraftUtils.sin[i] * arrowTipRadius;
            cos = PneumaticCraftUtils.cos[i] * arrowTipRadius;
            wr.func_181662_b(sin, baseLength, cos).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        wr.func_181668_a(8, DefaultVertexFormats.field_181705_e);
        for (i = PneumaticCraftUtils.sin.length - 1; i >= 0; --i) {
            sin = PneumaticCraftUtils.sin[i] * baseRadius;
            cos = PneumaticCraftUtils.cos[i] * baseRadius;
            wr.func_181662_b(sin, 0.0, cos).func_181675_d();
            wr.func_181662_b(sin, baseLength, cos).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        wr.func_181668_a(6, DefaultVertexFormats.field_181705_e);
        wr.func_181662_b(0.0, baseLength + arrowTipLength, 0.0).func_181675_d();
        for (i = 0; i < PneumaticCraftUtils.sin.length; ++i) {
            sin = PneumaticCraftUtils.sin[i] * arrowTipRadius;
            cos = PneumaticCraftUtils.cos[i] * arrowTipRadius;
            wr.func_181662_b(sin, baseLength, cos).func_181675_d();
        }
        wr.func_181662_b(0.0, baseLength, arrowTipRadius).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.enableTexture();
    }

    public static void renderFrame(AxisAlignedBB aabb, double fw) {
        RenderUtils.renderOffsetAABB(new AxisAlignedBB(aabb.field_72340_a + fw, aabb.field_72338_b - fw, aabb.field_72339_c - fw, aabb.field_72336_d - fw, aabb.field_72338_b + fw, aabb.field_72339_c + fw));
        RenderUtils.renderOffsetAABB(new AxisAlignedBB(aabb.field_72340_a + fw, aabb.field_72337_e - fw, aabb.field_72339_c - fw, aabb.field_72336_d - fw, aabb.field_72337_e + fw, aabb.field_72339_c + fw));
        RenderUtils.renderOffsetAABB(new AxisAlignedBB(aabb.field_72340_a + fw, aabb.field_72338_b - fw, aabb.field_72334_f - fw, aabb.field_72336_d - fw, aabb.field_72338_b + fw, aabb.field_72334_f + fw));
        RenderUtils.renderOffsetAABB(new AxisAlignedBB(aabb.field_72340_a + fw, aabb.field_72337_e - fw, aabb.field_72334_f - fw, aabb.field_72336_d - fw, aabb.field_72337_e + fw, aabb.field_72334_f + fw));
        RenderUtils.renderOffsetAABB(new AxisAlignedBB(aabb.field_72340_a - fw, aabb.field_72338_b - fw, aabb.field_72339_c + fw, aabb.field_72340_a + fw, aabb.field_72338_b + fw, aabb.field_72334_f - fw));
        RenderUtils.renderOffsetAABB(new AxisAlignedBB(aabb.field_72340_a - fw, aabb.field_72337_e - fw, aabb.field_72339_c + fw, aabb.field_72340_a + fw, aabb.field_72337_e + fw, aabb.field_72334_f - fw));
        RenderUtils.renderOffsetAABB(new AxisAlignedBB(aabb.field_72336_d - fw, aabb.field_72338_b - fw, aabb.field_72339_c + fw, aabb.field_72336_d + fw, aabb.field_72338_b + fw, aabb.field_72334_f - fw));
        RenderUtils.renderOffsetAABB(new AxisAlignedBB(aabb.field_72336_d - fw, aabb.field_72337_e - fw, aabb.field_72339_c + fw, aabb.field_72336_d + fw, aabb.field_72337_e + fw, aabb.field_72334_f - fw));
        RenderUtils.renderOffsetAABB(new AxisAlignedBB(aabb.field_72340_a - fw, aabb.field_72338_b - fw, aabb.field_72339_c - fw, aabb.field_72340_a + fw, aabb.field_72337_e + fw, aabb.field_72339_c + fw));
        RenderUtils.renderOffsetAABB(new AxisAlignedBB(aabb.field_72336_d - fw, aabb.field_72338_b - fw, aabb.field_72339_c - fw, aabb.field_72336_d + fw, aabb.field_72337_e + fw, aabb.field_72339_c + fw));
        RenderUtils.renderOffsetAABB(new AxisAlignedBB(aabb.field_72340_a - fw, aabb.field_72338_b - fw, aabb.field_72334_f - fw, aabb.field_72340_a + fw, aabb.field_72337_e + fw, aabb.field_72334_f + fw));
        RenderUtils.renderOffsetAABB(new AxisAlignedBB(aabb.field_72336_d - fw, aabb.field_72338_b - fw, aabb.field_72334_f - fw, aabb.field_72336_d + fw, aabb.field_72337_e + fw, aabb.field_72334_f + fw));
    }

    private static void renderOffsetAABB(AxisAlignedBB aabb) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181708_h);
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        wr.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static double rotateMatrixForDirection(Direction facing) {
        float yRotation;
        switch (facing) {
            case UP: {
                yRotation = 0.0f;
                GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GlStateManager.translated((double)0.0, (double)-1.0, (double)-1.0);
                break;
            }
            case DOWN: {
                yRotation = 0.0f;
                GlStateManager.rotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                GlStateManager.translated((double)0.0, (double)-1.0, (double)1.0);
                break;
            }
            case NORTH: {
                yRotation = 0.0f;
                break;
            }
            case EAST: {
                yRotation = 90.0f;
                break;
            }
            case SOUTH: {
                yRotation = 180.0f;
                break;
            }
            default: {
                yRotation = 270.0f;
            }
        }
        GlStateManager.rotated((double)yRotation, (double)0.0, (double)1.0, (double)0.0);
        return yRotation;
    }

    public static void renderItemAt(ItemStack stack, double x, double y, double z) {
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableLighting();
        GlStateManager.translated((double)x, (double)y, (double)z);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.GROUND);
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableLighting();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }
}

