/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import org.apache.commons.lang3.Validate;

public enum XPFluidManager {
    INSTANCE;

    public final Map<Fluid, Integer> liquidXPs = new HashMap<Fluid, Integer>();
    public final List<Fluid> availableLiquidXPs = new ArrayList<Fluid>();

    public static XPFluidManager getInstance() {
        return INSTANCE;
    }

    public void registerXPFluid(Fluid fluid, int liquidToPointRatio) {
        Validate.isTrue((fluid != null && fluid != Fluids.field_204541_a ? 1 : 0) != 0, (String)"Fluid may not be null!", (Object[])new Object[0]);
        if (liquidToPointRatio <= 0) {
            this.liquidXPs.remove(fluid);
            this.availableLiquidXPs.remove(fluid);
        } else {
            this.liquidXPs.put(fluid, liquidToPointRatio);
            this.availableLiquidXPs.add(fluid);
        }
    }

    public int getXPRatio(Fluid fluid) {
        return this.liquidXPs.getOrDefault(fluid, 0);
    }

    public List<Fluid> getAvailableLiquidXPs() {
        return ImmutableList.copyOf(this.availableLiquidXPs);
    }
}

