/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAbstractHopper;
import me.desht.pneumaticcraft.common.tileentity.TileEntityOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;

public class BlockOmnidirectionalHopper
extends BlockPneumaticCraft
implements ColorHandlers.ITintableBlock {
    private static final VoxelShape MIDDLE_SHAPE = Block.func_208617_a((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape INPUT_SHAPE = Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape BOWL_SHAPE = Block.func_208617_a((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape INPUT_UP = VoxelShapes.func_197878_a((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)BOWL_SHAPE, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape INPUT_NORTH = VoxelShapeUtils.rotateX(INPUT_UP, 270);
    private static final VoxelShape INPUT_DOWN = VoxelShapeUtils.rotateX(INPUT_NORTH, 270);
    private static final VoxelShape INPUT_SOUTH = VoxelShapeUtils.rotateX(INPUT_UP, 90);
    private static final VoxelShape INPUT_WEST = VoxelShapeUtils.rotateY(INPUT_NORTH, 270);
    private static final VoxelShape INPUT_EAST = VoxelShapeUtils.rotateY(INPUT_NORTH, 90);
    private static final VoxelShape[] INPUT_SHAPES = new VoxelShape[]{INPUT_DOWN, INPUT_UP, INPUT_NORTH, INPUT_SOUTH, INPUT_WEST, INPUT_EAST};
    private static final VoxelShape OUTPUT_DOWN = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape OUTPUT_UP = Block.func_208617_a((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape OUTPUT_NORTH = VoxelShapeUtils.rotateX(OUTPUT_DOWN, 90);
    private static final VoxelShape OUTPUT_SOUTH = VoxelShapeUtils.rotateX(OUTPUT_DOWN, 270);
    private static final VoxelShape OUTPUT_WEST = VoxelShapeUtils.rotateY(OUTPUT_NORTH, 270);
    private static final VoxelShape OUTPUT_EAST = VoxelShapeUtils.rotateY(OUTPUT_NORTH, 90);
    private static final VoxelShape[] OUTPUT_SHAPES = new VoxelShape[]{OUTPUT_DOWN, OUTPUT_UP, OUTPUT_NORTH, OUTPUT_SOUTH, OUTPUT_WEST, OUTPUT_EAST};
    public static final EnumProperty<Direction> INPUT_FACING = EnumProperty.func_177709_a((String)"input", Direction.class);

    public BlockOmnidirectionalHopper() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityOmnidirectionalHopper.class;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197878_a((VoxelShape)INPUT_SHAPES[((Direction)state.func_177229_b(INPUT_FACING)).func_176745_a()], (VoxelShape)OUTPUT_SHAPES[((Direction)state.func_177229_b((IProperty)this.directionProperty())).ordinal()], (IBooleanFunction)IBooleanFunction.field_223244_o_);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{INPUT_FACING});
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)ctx.func_196000_l().func_176734_d())).func_206870_a(INPUT_FACING, (Comparable)ctx.func_196010_d().func_176734_d());
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    private Direction getInputDirection(World world, BlockPos pos) {
        return (Direction)world.func_180495_p(pos).func_177229_b(INPUT_FACING);
    }

    @Override
    public boolean onWrenched(World world, PlayerEntity player, BlockPos pos, Direction face, Hand hand) {
        BlockState state = world.func_180495_p(pos);
        if (player != null && player.func_70093_af()) {
            Direction outputDir = this.getRotation(state);
            if ((outputDir = Direction.func_82600_a((int)(outputDir.ordinal() + 1))) == this.getInputDirection(world, pos)) {
                outputDir = Direction.func_82600_a((int)(outputDir.ordinal() + 1));
            }
            this.setRotation(world, pos, outputDir);
        } else {
            Direction inputDir = (Direction)state.func_177229_b(INPUT_FACING);
            if ((inputDir = Direction.func_82600_a((int)(inputDir.ordinal() + 1))) == this.getRotation((IBlockReader)world, pos)) {
                inputDir = Direction.func_82600_a((int)(inputDir.ordinal() + 1));
            }
            world.func_175656_a(pos, (BlockState)state.func_206870_a(INPUT_FACING, (Comparable)inputDir));
        }
        return true;
    }

    @Override
    public int getTintColor(BlockState state, @Nullable IEnviromentBlockReader world, @Nullable BlockPos pos, int tintIndex) {
        TileEntity te;
        if (world != null && pos != null && (te = world.func_175625_s(pos)) instanceof TileEntityAbstractHopper) {
            return ((TileEntityAbstractHopper)te).isCreative ? -32513 : -1;
        }
        return -1;
    }

    public static class ItemBlockOmnidirectionalHopper
    extends BlockItem
    implements ColorHandlers.ITintableItem {
        public ItemBlockOmnidirectionalHopper(Block block) {
            super(block, ModItems.defaultProps());
        }

        @Override
        public int getTintColor(ItemStack stack, int tintIndex) {
            int n = UpgradableItemUtils.getUpgrades(stack, EnumUpgrade.CREATIVE);
            return n > 0 ? -40705 : -1;
        }
    }
}

