/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefineryController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefineryOutput;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockRefineryOutput
extends BlockPneumaticCraft {
    private static final VoxelShape SHAPE1 = BlockRefineryOutput.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE2 = BlockRefineryOutput.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EW = VoxelShapes.func_197872_a((VoxelShape)SHAPE1, (VoxelShape)SHAPE2);
    private static final VoxelShape SHAPE_NS = VoxelShapeUtils.rotateY(SHAPE_EW, 90);

    public BlockRefineryOutput() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityRefineryOutput.class;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brtr) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityRefineryOutput) {
            TileEntityRefineryController master;
            boolean canTransferFluid = (Boolean)FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)player.func_184586_b(hand), (int)1)).map(heldHandler -> (Boolean)FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (Direction)brtr.func_216354_b()).map(refineryHandler -> this.couldTransferFluidOut((IFluidHandler)heldHandler, (IFluidHandler)refineryHandler)).orElse((Object)false)).orElse((Object)false);
            if (canTransferFluid) {
                return super.func_220051_a(state, world, pos, player, hand, brtr);
            }
            if (!world.field_72995_K && (master = ((TileEntityRefineryOutput)te).getRefineryController()) != null) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)master, (BlockPos)master.func_174877_v());
            }
            return true;
        }
        return false;
    }

    private boolean couldTransferFluidOut(IFluidHandler h1, IFluidHandler h2) {
        FluidStack f = FluidUtil.tryFluidTransfer((IFluidHandler)h1, (IFluidHandler)h2, (int)1000, (boolean)false);
        return !f.isEmpty();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getRotation(state).func_176740_k() == Direction.Axis.X ? SHAPE_EW : SHAPE_NS;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        int nOutputs = 0;
        int up = 1;
        int down = 1;
        while (worldIn.func_180495_p(pos.func_177981_b(up++)).func_177230_c() instanceof BlockRefineryOutput) {
            ++nOutputs;
        }
        while (worldIn.func_180495_p(pos.func_177979_c(down++)).func_177230_c() instanceof BlockRefineryOutput) {
            ++nOutputs;
        }
        return nOutputs < 4 && super.func_196260_a(state, worldIn, pos);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!worldIn.func_201670_d() && facingState.func_177230_c() == ModBlocks.REFINERY_OUTPUT.get()) {
            this.recache(worldIn, currentPos);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private void recache(IWorld world, BlockPos pos) {
        TileEntityRefineryController teC;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityRefineryOutput && (teC = ((TileEntityRefineryOutput)te).getRefineryController()) != null) {
            teC.cacheRefineryOutputs();
        }
    }
}

