/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.hacking.IHacking;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityHacking {
    public static void register() {
        CapabilityManager.INSTANCE.register(IHacking.class, (Capability.IStorage)new Capability.IStorage<IHacking>(){

            @Nullable
            public CompoundNBT writeNBT(Capability<IHacking> capability, IHacking instance, Direction side) {
                return (CompoundNBT)instance.serializeNBT();
            }

            public void readNBT(Capability<IHacking> capability, IHacking instance, Direction side, INBT nbt) {
                if (nbt instanceof CompoundNBT) {
                    instance.deserializeNBT((INBT)((CompoundNBT)nbt));
                }
            }
        }, () -> new DefaultImpl());
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        private final IHacking impl = new DefaultImpl();
        private final LazyOptional<IHacking> l = LazyOptional.of(() -> this.impl);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
            return cap == PNCCapabilities.HACKING_CAPABILITY ? this.l.cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return PNCCapabilities.HACKING_CAPABILITY.getStorage().writeNBT(PNCCapabilities.HACKING_CAPABILITY, (Object)this.impl, null);
        }

        public void deserializeNBT(INBT nbt) {
            PNCCapabilities.HACKING_CAPABILITY.getStorage().readNBT(PNCCapabilities.HACKING_CAPABILITY, (Object)this.impl, null, nbt);
        }
    }

    private static class DefaultImpl
    implements IHacking {
        private final List<IHackableEntity> hackables = new ArrayList<IHackableEntity>();

        private DefaultImpl() {
        }

        @Override
        public void update(Entity entity) {
            this.hackables.removeIf(hackable -> !hackable.afterHackTick(entity));
        }

        @Override
        public void addHackable(IHackableEntity hackable) {
            this.hackables.add(hackable);
        }

        @Override
        public List<IHackableEntity> getCurrentHacks() {
            return this.hackables;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT compound = new CompoundNBT();
            if (!this.getCurrentHacks().isEmpty()) {
                ListNBT tagList = new ListNBT();
                for (IHackableEntity hackableEntity : this.getCurrentHacks()) {
                    if (hackableEntity.getId() == null) continue;
                    CompoundNBT tag = new CompoundNBT();
                    tag.func_74778_a("id", hackableEntity.getId());
                    tagList.add(tagList.size(), (INBT)tag);
                }
                compound.func_218657_a("hackables", (INBT)tagList);
            }
            return compound;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.getCurrentHacks().clear();
            ListNBT tagList = nbt.func_150295_c("hackables", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                String hackableId = tagList.func_150305_b(i).func_74779_i("id");
                Class<? extends IHackableEntity> hackableClass = PneumaticHelmetRegistry.getInstance().stringToEntityHackables.get(hackableId);
                if (hackableClass != null) {
                    try {
                        this.getCurrentHacks().add(hackableClass.newInstance());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                Log.warning("hackable \"" + hackableId + "\" not found when constructing from NBT. Was it deleted?", new Object[0]);
            }
        }
    }
}

