/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.common.config.ClientConfig;
import me.desht.pneumaticcraft.common.config.CommonConfig;
import me.desht.pneumaticcraft.common.config.ConfigHolder;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigHelper {
    private static ModConfig clientConfig;
    private static ModConfig commonConfig;

    static void refreshClient(ModConfig config) {
        clientConfig = config;
        ClientConfig client = ConfigHolder.client;
        PNCConfig.Client.aphorismDrama = (Boolean)client.general.aphorismDrama.get();
        PNCConfig.Client.programmerDifficulty = (IProgWidget.WidgetDifficulty)((Object)client.general.programmerDifficulty.get());
        PNCConfig.Client.topShowsFluids = (Boolean)client.general.topShowsFluids.get();
        PNCConfig.Client.logisticsGuiTint = (Boolean)client.general.logisticsGuiTint.get();
        PNCConfig.Client.semiBlockLighting = (Boolean)client.general.semiBlockLighting.get();
        PNCConfig.Client.guiBevel = (Boolean)client.general.guiBevel.get();
        PNCConfig.Client.alwaysShowPressureDurabilityBar = (Boolean)client.general.alwaysShowPressureDurabilityBar.get();
        PNCConfig.Client.tubeModuleRedstoneParticles = (Boolean)client.general.tubeModuleRedstoneParticles.get();
        PNCConfig.Client.guiRemoteGridSnap = (Boolean)client.general.guiRemoteGridSnap.get();
        PNCConfig.Client.Armor.blockTrackerMaxTimePerTick = (Integer)client.armor.blockTrackerMaxTimePerTick.get();
        PNCConfig.Client.Armor.fancyArmorModels = (Boolean)client.armor.fancyArmorModels.get();
        PNCConfig.Client.Armor.leggingsFOVFactor = (Double)client.armor.leggingsFOVFactor.get();
        PNCConfig.Client.Armor.pathEnabled = (Boolean)client.armor.pathEnabled.get();
        PNCConfig.Client.Armor.wirePath = (Boolean)client.armor.wirePath.get();
        PNCConfig.Client.Armor.xRayEnabled = (Boolean)client.armor.xRayEnabled.get();
        PNCConfig.Client.Armor.pathUpdateSetting = (ClientConfig.PathUpdateSetting)((Object)client.armor.pathUpdateSetting.get());
        UpgradeRenderHandlerList.instance().refreshConfig();
    }

    static void refreshCommon(ModConfig config) {
        commonConfig = config;
        CommonConfig common = ConfigHolder.common;
        PNCConfig.Common.General.enableDroneSuffocation = (Boolean)common.general.enableDroneSuffocation.get();
        PNCConfig.Common.General.enableDungeonLoot = (Boolean)common.general.enableDungeonLoot.get();
        PNCConfig.Common.General.fuelBucketEfficiency = (Double)common.general.fuelBucketEfficiency.get();
        PNCConfig.Common.General.maxProgrammingArea = (Integer)common.general.maxProgrammingArea.get();
        PNCConfig.Common.General.minFluidFuelTemperature = (Integer)common.general.minFluidFuelTemperature.get();
        PNCConfig.Common.General.oilGenerationChance = (Integer)common.general.oilGenerationChance.get();
        PNCConfig.Common.General.oilWorldGenBlacklist = ((List)common.general.oilWorldGenBlacklist.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
        PNCConfig.Common.General.useUpDyesWhenColoring = (Boolean)common.general.useUpDyesWhenColoring.get();
        PNCConfig.Common.General.dronesRenderHeldItem = (Boolean)common.general.dronesRenderHeldItem.get();
        PNCConfig.Common.Machines.aerialInterfaceArmorCompat = (Boolean)common.machines.aerialInterfaceArmorCompat.get();
        PNCConfig.Common.Machines.cropSticksGrowthBoostChance = (Double)common.machines.cropSticksGrowthBoostChance.get();
        PNCConfig.Common.Machines.electricCompressorEfficiency = (Integer)common.machines.electricCompressorEfficiency.get();
        PNCConfig.Common.Machines.electrostaticLightningChance = (Integer)common.machines.electrostaticLightningChance.get();
        PNCConfig.Common.Machines.elevatorBaseBlocksPerBase = (Integer)common.machines.elevatorBaseBlocksPerBase.get();
        PNCConfig.Common.Machines.fluxCompressorEfficiency = (Integer)common.machines.fluxCompressorEfficiency.get();
        PNCConfig.Common.Machines.keroseneLampCanUseAnyFuel = (Boolean)common.machines.keroseneLampCanUseAnyFuel.get();
        PNCConfig.Common.Machines.keroseneLampFuelEfficiency = (Double)common.machines.keroseneLampFuelEfficiency.get();
        PNCConfig.Common.Machines.kineticCompressorEfficiency = (Integer)common.machines.kineticCompressorEfficiency.get();
        PNCConfig.Common.Machines.liquidHopperDispenser = (Boolean)common.machines.liquidHopperDispenser.get();
        PNCConfig.Common.Machines.omniHopperDispenser = (Boolean)common.machines.omniHopperDispenser.get();
        PNCConfig.Common.Machines.plasticMixerPlasticRatio = (Integer)common.machines.plasticMixerPlasticRatio.get();
        PNCConfig.Common.Machines.pneumaticDynamoEfficiency = (Integer)common.machines.pneumaticDynamoEfficiency.get();
        PNCConfig.Common.Machines.pneumaticEngineEfficiency = (Integer)common.machines.pneumaticEngineEfficiency.get();
        PNCConfig.Common.Machines.pneumaticGeneratorEfficiency = (Integer)common.machines.pneumaticGeneratorEfficiency.get();
        PNCConfig.Common.Machines.pneumaticPumpEfficiency = (Integer)common.machines.pneumaticPumpEfficiency.get();
        PNCConfig.Common.Machines.speedUpgradeSpeedMultiplier = (Double)common.machines.speedUpgradeSpeedMultiplier.get();
        PNCConfig.Common.Machines.speedUpgradeUsageMultiplier = (Double)common.machines.speedUpgradeUsageMultiplier.get();
        PNCConfig.Common.Machines.thermalCompressorThermalResistance = (Double)common.machines.thermalCompressorThermalResistance.get();
        PNCConfig.Common.Armor.jetBootsAirUsage = (Integer)common.armor.jetBootsAirUsage.get();
        PNCConfig.Common.Armor.armorStartupTime = (Integer)common.armor.armorStartupTime.get();
        PNCConfig.Common.Integration.ieExternalHeaterHeatPerRF = (Double)common.integration.ieExternalHeaterHeatPerRF.get();
        PNCConfig.Common.Integration.ieExternalHeaterRFperTick = (Integer)common.integration.ieExternalHeaterRFperTick.get();
        PNCConfig.Common.Integration.mekHeatEfficiency = (Double)common.integration.mekHeatEfficiency.get();
        PNCConfig.Common.Integration.mekThermalResistanceMult = (Double)common.integration.mekThermalResistanceMult.get();
        PNCConfig.Common.Integration.tanAirConAirUsageMultiplier = (Double)common.integration.tanAirConAirUsageMultiplier.get();
        PNCConfig.Common.Integration.tanHeatDivider = (Double)common.integration.tanHeatDivider.get();
        PNCConfig.Common.Integration.tanRefreshInterval = (Integer)common.integration.tanRefreshInterval.get();
        PNCConfig.Common.Advanced.disableKeroseneLampFakeAirBlock = (Boolean)common.advanced.disableKeroseneLampFakeAirBlock.get();
        PNCConfig.Common.Advanced.fluidTankUpdateRate = (Integer)common.advanced.fluidTankUpdateRate.get();
        PNCConfig.Common.Advanced.stopDroneAI = (Boolean)common.advanced.stopDroneAI.get();
        PNCConfig.Common.Micromissiles.baseExplosionDamage = (Double)common.micromissiles.baseExplosionDamage.get();
        PNCConfig.Common.Micromissiles.damageTerrain = (Boolean)common.micromissiles.damageTerrain.get();
        PNCConfig.Common.Micromissiles.launchCooldown = (Integer)common.micromissiles.launchCooldown.get();
        PNCConfig.Common.Micromissiles.lifetime = (Integer)common.micromissiles.lifetime.get();
        PNCConfig.Common.Micromissiles.missilePodSize = (Integer)common.micromissiles.missilePodSize.get();
        PNCConfig.Common.Minigun.apAmmoDamageMultiplier = (Double)common.minigun.apAmmoDamageMultiplier.get();
        PNCConfig.Common.Minigun.apAmmoIgnoreArmorChance = (Integer)common.minigun.apAmmoIgnoreArmorChance.get();
        PNCConfig.Common.Minigun.armorPiercingAmmoCartridgeSize = (Integer)common.minigun.armorPiercingAmmoCartridgeSize.get();
        PNCConfig.Common.Minigun.baseDamage = (Double)common.minigun.baseDamage.get();
        PNCConfig.Common.Minigun.baseRange = (Integer)common.minigun.baseRange.get();
        PNCConfig.Common.Minigun.explosiveAmmoCartridgeSize = (Integer)common.minigun.explosiveAmmoCartridgeSize.get();
        PNCConfig.Common.Minigun.explosiveAmmoDamageMultiplier = (Double)common.minigun.explosiveAmmoDamageMultiplier.get();
        PNCConfig.Common.Minigun.explosiveAmmoExplosionChance = (Integer)common.minigun.explosiveAmmoExplosionChance.get();
        PNCConfig.Common.Minigun.explosiveAmmoExplosionPower = (Double)common.minigun.explosiveAmmoExplosionPower.get();
        PNCConfig.Common.Minigun.explosiveAmmoTerrainDamage = (Boolean)common.minigun.explosiveAmmoTerrainDamage.get();
        PNCConfig.Common.Minigun.freezingAmmoBlockIceChance = (Integer)common.minigun.freezingAmmoBlockIceChance.get();
        PNCConfig.Common.Minigun.freezingAmmoCartridgeSize = (Integer)common.minigun.freezingAmmoCartridgeSize.get();
        PNCConfig.Common.Minigun.freezingAmmoEntityIceChance = (Integer)common.minigun.freezingAmmoEntityIceChance.get();
        PNCConfig.Common.Minigun.freezingAmmoFakeIceDamage = (Double)common.minigun.freezingAmmoFakeIceDamage.get();
        PNCConfig.Common.Minigun.incendiaryAmmoBlockIgniteChance = (Integer)common.minigun.incendiaryAmmoBlockIgniteChance.get();
        PNCConfig.Common.Minigun.incendiaryAmmoCartridgeSize = (Integer)common.minigun.incendiaryAmmoCartridgeSize.get();
        PNCConfig.Common.Minigun.incendiaryAmmoEntityIgniteChance = (Integer)common.minigun.incendiaryAmmoEntityIgniteChance.get();
        PNCConfig.Common.Minigun.incendiaryAmmoFireDuration = (Integer)common.minigun.incendiaryAmmoFireDuration.get();
        PNCConfig.Common.Minigun.potionProcChance = (Integer)common.minigun.potionProcChance.get();
        PNCConfig.Common.Minigun.standardAmmoCartridgeSize = (Integer)common.minigun.standardAmmoCartridgeSize.get();
        PNCConfig.Common.Minigun.weightedAmmoAirUsageMultiplier = (Double)common.minigun.weightedAmmoAirUsageMultiplier.get();
        PNCConfig.Common.Minigun.weightedAmmoCartridgeSize = (Integer)common.minigun.weightedAmmoCartridgeSize.get();
        PNCConfig.Common.Minigun.weightedAmmoDamageMultiplier = (Double)common.minigun.weightedAmmoDamageMultiplier.get();
        PNCConfig.Common.Minigun.weightedAmmoRangeMultiplier = (Double)common.minigun.weightedAmmoRangeMultiplier.get();
        PNCConfig.Common.Minigun.blockHitParticles = (Boolean)common.minigun.blockHitParticles.get();
        PNCConfig.Common.Recipes.coalToDiamondsRecipe = (Boolean)common.recipes.coalToDiamondsRecipe.get();
        PNCConfig.Common.Recipes.explosionCrafting = (Boolean)common.recipes.explosionCrafting.get();
        PNCConfig.Common.Heat.defaultBlockThermalResistance = (Double)common.heat.blockThermalResistance.get();
        PNCConfig.Common.Heat.defaultFluidThermalResistance = (Double)common.heat.fluidThermalResistance.get();
        PNCConfig.Common.Heat.airThermalResistance = (Double)common.heat.airThermalResistance.get();
        PNCConfig.Common.Heat.defaultFluidHeatCapacity = (Integer)common.heat.defaultFluidHeatCapacity.get();
        PNCConfig.Common.Heat.ambientTempBiomeModifier = (Double)common.heat.ambientTemperatureBiomeModifier.get();
        PNCConfig.Common.Heat.ambientTempHeightModifier = (Double)common.heat.ambientTemperatureHeightModifier.get();
        PNCConfig.Common.Amadron.numPeriodicOffers = (Integer)common.amadron.numPeriodicOffers.get();
        PNCConfig.Common.Amadron.reshuffleInterval = (Integer)common.amadron.reshuffleInterval.get();
        PNCConfig.Common.Amadron.maxTradesPerPlayer = (Integer)common.amadron.maxTradesPerPlayer.get();
        PNCConfig.Common.Amadron.notifyOfDealMade = (Boolean)common.amadron.notifyOfDealMade.get();
        PNCConfig.Common.Amadron.notifyOfTradeAddition = (Boolean)common.amadron.notifyOfTradeAddition.get();
        PNCConfig.Common.Amadron.notifyOfTradeRemoval = (Boolean)common.amadron.notifyOfTradeRemoval.get();
        PNCConfig.Common.Logistics.itemTransportCost = (Double)common.logistics.itemTransportCost.get();
        PNCConfig.Common.Logistics.fluidTransportCost = (Double)common.logistics.fluidTransportCost.get();
        PNCConfig.Common.Logistics.minPressure = (Double)common.logistics.minPressure.get();
    }

    private static void setValueAndSave(ModConfig modConfig, String path, Object newValue) {
        modConfig.getConfigData().set(path, newValue);
        modConfig.save();
    }

    private static void setValuesAndSave(ModConfig modConfig, Map<String, Object> values) {
        values.forEach((k, v) -> modConfig.getConfigData().set(k, v));
        modConfig.save();
    }

    public static void setProgrammerDifficulty(IProgWidget.WidgetDifficulty difficulty) {
        ConfigHelper.setValueAndSave(clientConfig, "general.programmer_difficulty", (Object)difficulty);
        ConfigHelper.refreshClient(clientConfig);
    }

    public static void setGuiRemoteGridSnap(boolean snap) {
        ConfigHelper.setValueAndSave(clientConfig, "general.gui_remote_grid_snap", snap);
        ConfigHelper.refreshClient(clientConfig);
    }

    public static void updateCoordTracker(boolean pathEnabled, boolean wirePath, boolean xRayEnabled, ClientConfig.PathUpdateSetting pathUpdateSetting) {
        ConfigHelper.setValuesAndSave(clientConfig, (Map<String, Object>)ImmutableMap.of((Object)"armor.path_enabled", (Object)pathEnabled, (Object)"armor.wire_path", (Object)wirePath, (Object)"armor.xray_enabled", (Object)xRayEnabled, (Object)"armor.path_update_setting", (Object)((Object)pathUpdateSetting)));
        ConfigHelper.refreshClient(clientConfig);
    }
}

