/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.core;

import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import me.desht.pneumaticcraft.common.core.ModRegistries;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCactusLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCropLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCrops;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerLeaves;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerTree;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class ModHarvestHandlers {
    public static final DeferredRegister<HarvestHandler> HARVEST_HANDLERS = new DeferredRegister(ModRegistries.HARVEST_HANDLERS, "pneumaticcraft");

    public static Block convertTree(Block in, String from, String to) {
        ResourceLocation rl = new ResourceLocation(in.getRegistryName().toString().replace("_" + from, "_" + to));
        return (Block)ForgeRegistries.BLOCKS.getValue(rl);
    }

    static {
        HARVEST_HANDLERS.register("crops", HarvestHandlerCrops::new);
        HARVEST_HANDLERS.register("nether_wart", () -> new HarvestHandlerCropLike(state -> state.func_177230_c() == Blocks.field_150388_bm, NetherWartBlock.field_176486_a, stack -> stack.func_77973_b() == Items.field_151075_bm));
        HARVEST_HANDLERS.register("cocoa_beans", () -> new HarvestHandlerCropLike(state -> state.func_177230_c() == Blocks.field_150375_by, CocoaBlock.field_176501_a, stack -> stack.func_77973_b() == Items.field_196130_bo));
        HARVEST_HANDLERS.register("cactus_like", () -> new HarvestHandlerCactusLike(state -> state.func_177230_c() == Blocks.field_150434_aF || state.func_177230_c() == Blocks.field_196608_cF));
        HARVEST_HANDLERS.register("pumpkin_like", () -> new HarvestHandler.SimpleHarvestHandler(Blocks.field_150423_aK, Blocks.field_150440_ba));
        HARVEST_HANDLERS.register("leaves", HarvestHandlerLeaves::new);
        HARVEST_HANDLERS.register("trees", HarvestHandlerTree::new);
    }
}

