/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.living;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.api.drone.IPathfindHandler;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.semiblock.SemiblockEvent;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.client.render.RenderProgressingLine;
import me.desht.pneumaticcraft.common.DamageSourcePneumaticCraft;
import me.desht.pneumaticcraft.common.DroneRegistry;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.DroneGoToChargingStation;
import me.desht.pneumaticcraft.common.ai.DroneGoToOwner;
import me.desht.pneumaticcraft.common.ai.DroneMovementController;
import me.desht.pneumaticcraft.common.ai.EntityPathNavigateDrone;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.ai.LogisticsManager;
import me.desht.pneumaticcraft.common.block.BlockDroneRedstoneEmitter;
import me.desht.pneumaticcraft.common.capabilities.BasicAirHandler;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModEntities;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.living.DebugEntry;
import me.desht.pneumaticcraft.common.entity.living.EntityDroneBase;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.item.ItemDrone;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSendDroneDebugEntry;
import me.desht.pneumaticcraft.common.network.PacketShowWireframe;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneEntityProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetGoToLocation;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneFakePlayer;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneItemHandler;
import me.desht.pneumaticcraft.common.util.fakeplayer.FakeNetHandlerPlayerServer;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.util.upgrade.IUpgradeHolder;
import me.desht.pneumaticcraft.common.util.upgrade.UpgradeCache;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

public class EntityDrone
extends EntityDroneBase
implements IManoMeasurable,
IPneumaticWrenchable,
IEntityAdditionalSpawnData,
IHackableEntity,
IDroneBase,
IFlyingAnimal,
IUpgradeHolder {
    private static final float LASER_EXTEND_SPEED = 0.05f;
    private static final DataParameter<Boolean> ACCELERATING = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> PRESSURE = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<String> PROGRAM_KEY = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<BlockPos> DUG_POS = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> GOING_TO_OWNER = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DRONE_COLOR = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> MINIGUN_ACTIVE = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_MINIGUN = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> AMMO = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<String> LABEL = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> ACTIVE_WIDGET = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> TARGET_POS = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<ItemStack> HELD_ITEM = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> TARGET_ID = EntityDataManager.func_187226_a(EntityDrone.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final HashMap<String, Integer> LASER_COLOR_MAP = new HashMap();
    private EntityDroneItemHandler droneItemHandler;
    private final LazyOptional<IItemHandlerModifiable> droneItemHandlerCap = LazyOptional.of(this::getDroneItemHandler);
    private final FluidTank fluidTank = new FluidTank(Integer.MAX_VALUE);
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.fluidTank);
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private final ItemStackHandler upgradeInventory = new ItemStackHandler(9);
    private final UpgradeCache upgradeCache = new UpgradeCache(this);
    private BasicAirHandler airHandler;
    private final LazyOptional<IAirHandler> airCap = LazyOptional.of(this::getAirHandler);
    private final int[] emittingRedstoneValues = new int[6];
    private float propSpeed;
    private RenderProgressingLine targetLine;
    private RenderProgressingLine oldTargetLine;
    public List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private DroneFakePlayer fakePlayer;
    public String ownerName = "Drone";
    private UUID ownerUUID;
    private DroneGoToChargingStation chargeAI;
    private DroneGoToOwner gotoOwnerAI;
    private final DroneAIManager aiManager = new DroneAIManager(this);
    private double speed;
    private int healingInterval;
    private int suffocationCounter = 40;
    private boolean isSuffocating;
    private boolean disabledByHacking;
    private boolean standby;
    private Minigun minigun;
    private final DroneDebugList debugList = new DroneDebugList();
    private final Set<ServerPlayerEntity> debuggingPlayers = new HashSet<ServerPlayerEntity>();
    private int securityUpgradeCount;
    private final Map<BlockPos, BlockState> displacedLiquids = new HashMap<BlockPos, BlockState>();
    private LogisticsManager logisticsManager;

    public EntityDrone(EntityType<? extends EntityDrone> type, World world) {
        super(type, world);
        this.field_70765_h = new DroneMovementController(this);
        this.chargeAI = new DroneGoToChargingStation(this);
        this.field_70714_bg.func_75776_a(1, (Goal)this.chargeAI);
    }

    EntityDrone(EntityType<? extends EntityDrone> type, World world, PlayerEntity player) {
        this(type, world);
        if (player != null) {
            this.ownerUUID = player.func_146103_bH().getId();
            this.ownerName = player.func_200200_C_().func_150254_d();
        } else {
            this.ownerUUID = this.func_110124_au();
            this.ownerName = "Drone";
        }
    }

    public EntityDrone(World world, PlayerEntity player) {
        this((EntityType<? extends EntityDrone>)((EntityType)ModEntities.DRONE.get()), world, player);
    }

    @SubscribeEvent
    public void onSemiblockEvent(SemiblockEvent event) {
        if (!event.getWorld().field_72995_K && event.getWorld() == this.func_130014_f_() && event.getSemiblock() instanceof EntityLogisticsFrame) {
            this.logisticsManager = null;
        }
    }

    protected PathNavigator func_175447_b(World worldIn) {
        EntityPathNavigateDrone nav = new EntityPathNavigateDrone(this, worldIn);
        nav.func_192879_a(false);
        nav.func_212239_d(true);
        nav.func_192878_b(true);
        return nav;
    }

    public void readFromItemStack(ItemStack droneStack) {
        Validate.isTrue((boolean)(droneStack.func_77973_b() instanceof ItemDrone));
        CompoundNBT stackTag = droneStack.func_77978_p();
        if (stackTag != null) {
            this.upgradeInventory.deserializeNBT(stackTag.func_74775_l("UpgradeInventory"));
            int air = ((IAirHandlerItem)droneStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElseThrow(RuntimeException::new)).getAir();
            this.getAirHandler().addAir(air);
            if (((ItemDrone)droneStack.func_77973_b()).canProgram(droneStack)) {
                this.progWidgets = TileEntityProgrammer.getWidgetsFromNBT(stackTag);
                TileEntityProgrammer.updatePuzzleConnections(this.progWidgets);
            }
            this.setDroneColor(stackTag.func_74762_e("color"));
            this.fluidTank.setCapacity(16000 * (1 + this.getUpgrades(EnumUpgrade.INVENTORY)));
            if (stackTag.func_74764_b("Tank")) {
                this.fluidTank.readFromNBT(stackTag.func_74775_l("Tank"));
            }
        }
        if (droneStack.func_82837_s()) {
            this.func_200203_b(droneStack.func_200301_q());
        }
    }

    private void writeToItemStack(ItemStack droneStack) {
        Validate.isTrue((boolean)(droneStack.func_77973_b() instanceof ItemDrone));
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("UpgradeInventory", (INBT)this.upgradeInventory.serializeNBT());
        if (((ItemDrone)droneStack.func_77973_b()).canProgram(droneStack)) {
            TileEntityProgrammer.putWidgetsToNBT(this.progWidgets, tag);
        }
        tag.func_74768_a("color", this.getDroneColor());
        if (!this.fluidTank.isEmpty()) {
            tag.func_218657_a("Tank", (INBT)this.fluidTank.writeToNBT(new CompoundNBT()));
        }
        droneStack.func_77982_d(tag);
        ((IAirHandlerItem)droneStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElseThrow(RuntimeException::new)).addAir(this.getAirHandler().getAir());
        if (this.func_145818_k_()) {
            droneStack.func_200302_a(this.func_200201_e());
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PRESSURE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ACCELERATING, (Object)false);
        this.field_70180_af.func_187214_a(PROGRAM_KEY, (Object)"");
        this.field_70180_af.func_187214_a(DUG_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(GOING_TO_OWNER, (Object)false);
        this.field_70180_af.func_187214_a(DRONE_COLOR, (Object)DyeColor.BLACK.func_196059_a());
        this.field_70180_af.func_187214_a(MINIGUN_ACTIVE, (Object)false);
        this.field_70180_af.func_187214_a(HAS_MINIGUN, (Object)false);
        this.field_70180_af.func_187214_a(AMMO, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(LABEL, (Object)"");
        this.field_70180_af.func_187214_a(ACTIVE_WIDGET, (Object)0);
        this.field_70180_af.func_187214_a(TARGET_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(HELD_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(TARGET_ID, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getRange());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.droneItemHandlerCap.cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        if (capability == PNCCapabilities.AIR_HANDLER_CAPABILITY) {
            return this.airCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeLong(this.ownerUUID.getMostSignificantBits());
        buffer.writeLong(this.ownerUUID.getLeastSignificantBits());
        buffer.func_180714_a(this.ownerName);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.ownerUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.ownerName = buffer.func_218666_n();
    }

    public boolean func_213397_c(double dist) {
        return false;
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)ModSounds.DRONE_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSounds.DRONE_DEATH.get();
    }

    public void func_70071_h_() {
        boolean enabled;
        if (this.field_70173_aa == 1) {
            this.onFirstTick();
        }
        boolean bl = enabled = !this.disabledByHacking && this.getAirHandler().getPressure() > 0.01f;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(PRESSURE, (Object)Float.valueOf((float)((int)(this.getAirHandler().getPressure() * 10.0f)) / 10.0f));
            this.setAccelerating(!this.standby && enabled);
            if (this.isAccelerating()) {
                this.field_70143_R = 0.0f;
            }
            if (this.healingInterval != 0 && this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % this.healingInterval == 0) {
                this.func_70691_i(1.0f);
                this.airHandler.addAir(-this.healingInterval);
            }
            if (!this.isSuffocating) {
                this.suffocationCounter = 40;
            }
            this.isSuffocating = false;
            Path path = this.func_70661_as().func_75505_d();
            if (path != null) {
                PathPoint target = path.func_75870_c();
                if (target != null) {
                    this.setTargetedBlock(new BlockPos(target.field_75839_a, target.field_75837_b, target.field_75838_c));
                } else {
                    this.setTargetedBlock(null);
                }
            } else {
                this.setTargetedBlock(null);
            }
            if (this.field_70170_p.func_82737_E() % 20L == 0L) {
                this.updateDebuggingPlayers();
            }
            FakePlayer fp = this.getFakePlayer();
            fp.field_70165_t = this.field_70165_t;
            fp.field_70163_u = this.field_70163_u;
            fp.field_70161_v = this.field_70161_v;
            fp.func_70071_h_();
            if (this.func_70089_S()) {
                for (int i = 0; i < 4; ++i) {
                    fp.field_71134_c.func_73075_a();
                }
            }
            if (this.securityUpgradeCount > 1 && this.func_110143_aJ() > 0.0f) {
                this.handleFluidDisplacement();
            }
        } else {
            this.oldLaserExtension = this.laserExtension;
            this.laserExtension = this.getActiveProgramKey().func_110623_a().equals("dig") ? Math.min(1.0f, this.laserExtension + 0.05f) : Math.max(0.0f, this.laserExtension - 0.05f);
            if (this.isAccelerating() && this.field_70146_Z.nextBoolean()) {
                int x = (int)Math.floor(this.field_70165_t);
                int y = (int)Math.floor(this.field_70163_u - 1.0);
                int z = (int)Math.floor(this.field_70161_v);
                BlockPos pos = new BlockPos(x, y, z);
                BlockState state = null;
                for (int i = 0; i < 3 && (state = this.field_70170_p.func_180495_p(pos)).func_185904_a() == Material.field_151579_a; ++i) {
                    --y;
                }
                if (state.func_185904_a() != Material.field_151579_a && this.field_70170_p.field_73012_v.nextBoolean()) {
                    Vec3d vec = new Vec3d(this.field_70163_u - (double)y, 0.0, 0.0);
                    vec = vec.func_178785_b((float)((double)this.field_70146_Z.nextFloat() * Math.PI * 2.0));
                    BlockParticleData data = new BlockParticleData(ParticleTypes.field_197611_d, state);
                    this.field_70170_p.func_195594_a((IParticleData)data, this.field_70165_t + vec.field_72450_a, (double)(y + 1), this.field_70161_v + vec.field_72449_c, vec.field_72450_a, 0.0, vec.field_72449_c);
                }
            }
        }
        if (this.isAccelerating()) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.3));
            this.propSpeed = Math.min(1.0f, this.propSpeed + 0.04f);
            this.getAirHandler().addAir(-1);
        } else {
            this.propSpeed = Math.max(0.0f, this.propSpeed - 0.04f);
        }
        this.oldPropRotation = this.propRotation;
        this.propRotation += this.propSpeed;
        super.func_70071_h_();
        if (this.hasMinigun()) {
            this.getMinigun().setAttackTarget(this.func_70638_az()).update(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (enabled) {
                this.aiManager.onUpdateTasks();
            }
            this.handleRedstoneEmission();
        }
    }

    private void onFirstTick() {
        this.securityUpgradeCount = this.getUpgrades(EnumUpgrade.SECURITY);
        if (this.securityUpgradeCount > 0) {
            ((EntityPathNavigateDrone)this.getPathNavigator()).pathThroughLiquid = true;
        }
        this.func_184644_a(PathNodeType.WATER, this.securityUpgradeCount > 0 ? 0.0f : -1.0f);
        this.speed = 0.15 + (double)Math.min(10, this.getUpgrades(EnumUpgrade.SPEED)) * 0.015;
        int n = this.healingInterval = this.getUpgrades(EnumUpgrade.ITEM_LIFE) > 0 ? 100 / this.getUpgrades(EnumUpgrade.ITEM_LIFE) : 0;
        if (!this.field_70170_p.field_72995_K) {
            this.getDroneItemHandler().setFakePlayerReady();
            this.setHasMinigun(this.getUpgrades(EnumUpgrade.MINIGUN) > 0);
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.aiManager.setWidgets(this.progWidgets);
        }
        this.energy.setCapacity(100000 + 100000 * this.getUpgrades(EnumUpgrade.VOLUME));
    }

    private void handleRedstoneEmission() {
        for (Direction d : Direction.values()) {
            if (this.getEmittingRedstone(d) <= 0) continue;
            if (!this.field_70170_p.func_175623_d(new BlockPos((int)Math.floor(this.field_70165_t + (double)(this.func_213311_cf() / 2.0f)), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v + (double)(this.func_213311_cf() / 2.0f))))) break;
            this.field_70170_p.func_175656_a(new BlockPos((int)Math.floor(this.field_70165_t + (double)(this.func_213311_cf() / 2.0f)), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v + (double)(this.func_213311_cf() / 2.0f))), ((BlockDroneRedstoneEmitter)ModBlocks.DRONE_REDSTONE_EMITTER.get()).func_176223_P());
            break;
        }
    }

    private void handleFluidDisplacement() {
        this.restoreFluidBlocks(true);
        for (int x = (int)this.field_70165_t - 1; x <= (int)(this.field_70165_t + (double)this.func_213311_cf()); ++x) {
            for (int y = (int)this.field_70163_u - 1; y <= (int)(this.field_70163_u + (double)this.func_213302_cg() + 1.0); ++y) {
                for (int z = (int)this.field_70161_v - 2; z <= (int)(this.field_70161_v + (double)this.func_213311_cf()); ++z) {
                    if (!PneumaticCraftUtils.isBlockLiquid(this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c())) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (this.securityUpgradeCount == 2) {
                        this.displacedLiquids.put(pos, this.field_70170_p.func_180495_p(pos));
                    }
                    this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
    }

    public boolean func_70648_aU() {
        return this.securityUpgradeCount > 0;
    }

    public BlockPos getTargetedBlock() {
        BlockPos pos = (BlockPos)this.field_70180_af.func_187225_a(TARGET_POS);
        return pos.equals((Object)BlockPos.field_177992_a) ? null : pos;
    }

    private void setTargetedBlock(BlockPos pos) {
        this.field_70180_af.func_187227_b(TARGET_POS, (Object)(pos == null ? BlockPos.field_177992_a : pos));
    }

    @Override
    public int getLaserColor() {
        String name = this.func_145818_k_() ? this.func_200201_e().func_150254_d().toLowerCase() : this.ownerName.toLowerCase();
        return LASER_COLOR_MAP.getOrDefault(name, super.getLaserColor());
    }

    @Override
    public BlockPos getDugBlock() {
        BlockPos pos = (BlockPos)this.field_70180_af.func_187225_a(DUG_POS);
        return pos.equals((Object)BlockPos.field_177992_a) ? null : pos;
    }

    @Override
    public ItemStack getDroneHeldItem() {
        return PNCConfig.Common.General.dronesRenderHeldItem ? (ItemStack)this.field_70180_af.func_187225_a(HELD_ITEM) : ItemStack.field_190927_a;
    }

    @Override
    public void setDugBlock(BlockPos pos) {
        this.field_70180_af.func_187227_b(DUG_POS, (Object)(pos == null ? BlockPos.field_177992_a : pos));
    }

    public List<DroneAIManager.EntityAITaskEntry> getRunningTasks() {
        return this.aiManager.getRunningTasks();
    }

    public Goal getRunningTargetAI() {
        return this.aiManager.getTargetAI();
    }

    public void setVariable(String varName, BlockPos pos) {
        this.aiManager.setCoordinate(varName, pos);
    }

    public BlockPos getVariable(String varName) {
        return this.aiManager.getCoordinate(varName);
    }

    private ResourceLocation getActiveProgramKey() {
        return new ResourceLocation((String)this.field_70180_af.func_187225_a(PROGRAM_KEY));
    }

    public IProgWidget getActiveWidget() {
        int index = this.getActiveWidgetIndex();
        if (index >= 0 && index < this.progWidgets.size()) {
            return this.progWidgets.get(index);
        }
        return null;
    }

    private int getActiveWidgetIndex() {
        return (Integer)this.field_70180_af.func_187225_a(ACTIVE_WIDGET);
    }

    @Override
    public void setActiveProgram(IProgWidget widget) {
        this.field_70180_af.func_187227_b(PROGRAM_KEY, (Object)widget.getTypeID().toString());
        this.field_70180_af.func_187227_b(ACTIVE_WIDGET, (Object)this.progWidgets.indexOf(widget));
    }

    private void setAccelerating(boolean accelerating) {
        this.field_70180_af.func_187227_b(ACCELERATING, (Object)accelerating);
    }

    @Override
    public boolean isAccelerating() {
        return (Boolean)this.field_70180_af.func_187225_a(ACCELERATING);
    }

    private void setDroneColor(int color) {
        this.field_70180_af.func_187227_b(DRONE_COLOR, (Object)color);
    }

    @Override
    public int getDroneColor() {
        return (Integer)this.field_70180_af.func_187225_a(DRONE_COLOR);
    }

    private void setMinigunActivated(boolean activated) {
        this.field_70180_af.func_187227_b(MINIGUN_ACTIVE, (Object)activated);
    }

    private boolean isMinigunActivated() {
        return (Boolean)this.field_70180_af.func_187225_a(MINIGUN_ACTIVE);
    }

    private void setHasMinigun(boolean hasMinigun) {
        this.field_70180_af.func_187227_b(HAS_MINIGUN, (Object)hasMinigun);
    }

    public boolean hasMinigun() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_MINIGUN);
    }

    public int getAmmoColor() {
        ItemStack ammo = (ItemStack)this.field_70180_af.func_187225_a(AMMO);
        if (ammo.func_77973_b() instanceof ItemGunAmmo) {
            return ((ItemGunAmmo)ammo.func_77973_b()).getAmmoColor(ammo);
        }
        return 0x808080;
    }

    private void setAmmoColor(ItemStack color) {
        this.field_70180_af.func_187227_b(AMMO, (Object)color);
    }

    protected int func_70682_h(int par1) {
        return -20;
    }

    public void func_213352_e(Vec3d travelVec) {
        if (this.field_70170_p.field_72995_K) {
            LivingEntity targetEntity = this.func_70638_az();
            if (targetEntity != null && !targetEntity.func_70089_S()) {
                this.func_70624_b(null);
                targetEntity = null;
            }
            if (targetEntity != null) {
                if (this.targetLine == null) {
                    this.targetLine = new RenderProgressingLine(0.0, -this.func_213302_cg() / 2.0f, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.oldTargetLine == null) {
                    this.oldTargetLine = new RenderProgressingLine(0.0, -this.func_213302_cg() / 2.0f, 0.0, 0.0, 0.0, 0.0);
                }
                this.targetLine.endX = targetEntity.field_70165_t - this.field_70165_t;
                this.targetLine.endY = targetEntity.field_70163_u + (double)(targetEntity.func_213302_cg() / 2.0f) - this.field_70163_u;
                this.targetLine.endZ = targetEntity.field_70161_v - this.field_70161_v;
                this.oldTargetLine.endX = targetEntity.field_70169_q - this.field_70169_q;
                this.oldTargetLine.endY = targetEntity.field_70167_r + (double)(targetEntity.func_213302_cg() / 2.0f) - this.field_70167_r;
                this.oldTargetLine.endZ = targetEntity.field_70166_s - this.field_70166_s;
                this.oldTargetLine.setProgress(this.targetLine.getProgress());
                this.targetLine.incProgressByDistance(0.3);
                this.field_70158_ak = true;
            } else {
                this.oldTargetLine = null;
                this.targetLine = null;
                this.field_70158_ak = false;
            }
        }
        if (this.func_184187_bx() == null && this.isAccelerating()) {
            double d3 = this.func_213322_ci().field_72448_b;
            super.func_213352_e(travelVec);
            this.func_213293_j(this.func_213322_ci().field_72450_a, d3 * 0.6, this.func_213322_ci().field_72449_c);
        } else {
            super.func_213352_e(travelVec);
        }
        this.field_70122_E = true;
    }

    public RenderProgressingLine getTargetLine() {
        return this.targetLine;
    }

    public RenderProgressingLine getOldTargetLine() {
        return this.oldTargetLine;
    }

    public double getRange() {
        return 75.0;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == ModItems.GPS_TOOL.get()) {
            if (!this.field_70170_p.field_72995_K) {
                BlockPos gpsLoc = ItemGPSTool.getGPSLocation(this.field_70170_p, stack);
                if (gpsLoc != null) {
                    this.func_70661_as().func_75492_a((double)gpsLoc.func_177958_n(), (double)gpsLoc.func_177956_o(), (double)gpsLoc.func_177952_p(), 0.1);
                    return true;
                }
                return false;
            }
            return true;
        }
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        if (color != null) {
            if (!this.field_70170_p.field_72995_K) {
                this.setDroneColor(color.func_196059_a());
                if (PNCConfig.Common.General.useUpDyesWhenColoring && !player.func_184812_l_()) {
                    stack.func_190918_g(1);
                    if (stack.func_190916_E() <= 0) {
                        player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean shouldDropAsItem() {
        return true;
    }

    @Override
    public boolean onWrenched(World world, PlayerEntity player, BlockPos pos, Direction side, Hand hand) {
        if (this.shouldDropAsItem()) {
            this.func_70097_a(new DamageSourcePneumaticCraft.DamageSourceDroneOverload("wrenched", new Object[0]), 2000.0f);
            return true;
        }
        return false;
    }

    private void restoreFluidBlocks(boolean distCheck) {
        Iterator<Map.Entry<BlockPos, BlockState>> iter = this.displacedLiquids.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<BlockPos, BlockState> entry = iter.next();
            BlockPos pos = entry.getKey();
            if (distCheck && !(pos.func_218140_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, true) > 1.0)) continue;
            if (this.field_70170_p.func_175623_d(pos) || PneumaticCraftUtils.isBlockLiquid(this.field_70170_p.func_180495_p(pos).func_177230_c())) {
                this.field_70170_p.func_180501_a(pos, entry.getValue(), 2);
            }
            iter.remove();
        }
    }

    @Nullable
    public Entity func_212321_a(DimensionType type) {
        Entity entity = super.func_212321_a(type);
        if (entity != null) {
            this.restoreFluidBlocks(false);
        }
        return entity;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
    }

    protected void func_213337_cE() {
        EntityDroneItemHandler dih = this.getDroneItemHandler();
        for (int i = 0; i < dih.getSlots(); ++i) {
            if (dih.getStackInSlot(i).func_190926_b()) continue;
            this.func_70099_a(dih.getStackInSlot(i), 0.0f);
            dih.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        this.restoreFluidBlocks(false);
        if (this.shouldDropAsItem()) {
            ItemStack stack = new ItemStack((IItemProvider)this.getDroneItem());
            this.writeToItemStack(stack);
            this.func_70099_a(stack, 0.0f);
            if (!this.field_70170_p.field_72995_K) {
                this.reportDroneDeath(this.getOwner(), damageSource);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getDugBlock() != null) {
            this.getFakePlayer().field_71134_c.func_225416_a(this.getDugBlock(), CPlayerDiggingPacket.Action.ABORT_DESTROY_BLOCK, Direction.UP, 0);
        }
        this.func_200203_b((ITextComponent)new StringTextComponent(""));
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    private void reportDroneDeath(PlayerEntity owner, DamageSource damageSource) {
        if (owner != null) {
            int x = (int)Math.floor(this.field_70165_t);
            int y = (int)Math.floor(this.field_70163_u);
            int z = (int)Math.floor(this.field_70161_v);
            TranslationTextComponent msg = this.func_145818_k_() ? new TranslationTextComponent("death.drone.named", new Object[]{this.func_200201_e().func_150254_d(), x, y, z}) : new TranslationTextComponent("death.drone", new Object[]{x, y, z});
            msg = msg.func_150257_a((ITextComponent)new StringTextComponent(" - ")).func_150257_a(damageSource.func_151519_b((LivingEntity)this));
            owner.func_146105_b((ITextComponent)msg, false);
        }
    }

    private Item getDroneItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(this.func_200600_R().getRegistryName());
    }

    public void func_184206_a(DataParameter<?> key) {
        if (this.field_70170_p.field_72995_K) {
            if (TARGET_ID.equals(key)) {
                Entity e;
                int id = (Integer)this.field_70180_af.func_187225_a(TARGET_ID);
                if (id > 0 && (e = this.func_130014_f_().func_73045_a(id)) instanceof LivingEntity) {
                    this.func_70624_b((LivingEntity)e);
                }
                if (this.targetLine != null && this.oldTargetLine != null) {
                    this.targetLine.setProgress(0.0f);
                    this.oldTargetLine.setProgress(0.0f);
                }
            } else if (PRESSURE.equals(key)) {
                int newAir = (int)(((Float)this.field_70180_af.func_187225_a(PRESSURE)).floatValue() * (float)this.getAirHandler().getVolume());
                this.getAirHandler().addAir(newAir - this.airHandler.getAir());
            }
        }
        super.func_184206_a(key);
    }

    public void func_70624_b(LivingEntity entity) {
        super.func_70624_b(entity);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(TARGET_ID, (Object)(entity == null ? 0 : entity.func_145782_y()));
        }
    }

    private EntityDroneItemHandler getDroneItemHandler() {
        if (this.droneItemHandler == null) {
            this.droneItemHandler = new EntityDroneItemHandler(this);
        }
        return this.droneItemHandler;
    }

    protected BasicAirHandler getAirHandler() {
        if (this.airHandler == null) {
            int vol = ApplicableUpgradesDB.getInstance().getUpgradedVolume(12000, this.getUpgrades(EnumUpgrade.VOLUME));
            this.airHandler = new BasicAirHandler(vol);
        }
        return this.airHandler;
    }

    @Override
    public void printManometerMessage(PlayerEntity player, List<ITextComponent> curInfo) {
        if (this.func_145818_k_()) {
            curInfo.add(this.func_200201_e().func_211708_a(TextFormatting.AQUA));
        }
        curInfo.add(PneumaticCraftUtils.xlate("entityTracker.info.tamed", this.getFakePlayer().func_200200_C_()));
        curInfo.add(PneumaticCraftUtils.xlate("gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(this.getAirHandler().getPressure(), 1) + " bar."));
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        TileEntityProgrammer.putWidgetsToNBT(this.progWidgets, tag);
        tag.func_218657_a("airHandler", (INBT)this.getAirHandler().serializeNBT());
        tag.func_74776_a("propSpeed", this.propSpeed);
        tag.func_74757_a("disabledByHacking", this.disabledByHacking);
        tag.func_74757_a("hackedByOwner", this.gotoOwnerAI != null);
        tag.func_74768_a("color", this.getDroneColor());
        tag.func_74757_a("standby", this.standby);
        tag.func_218657_a("variables", (INBT)this.aiManager.writeToNBT(new CompoundNBT()));
        tag.func_218657_a("Inventory", (INBT)this.getDroneItemHandler().serializeNBT());
        tag.func_218657_a("UpgradeInventory", (INBT)this.upgradeInventory.serializeNBT());
        this.fluidTank.writeToNBT(tag);
        tag.func_74778_a("owner", this.ownerName);
        tag.func_74772_a("ownerUUID_M", this.ownerUUID.getMostSignificantBits());
        tag.func_74772_a("ownerUUID_L", this.ownerUUID.getLeastSignificantBits());
        if (!this.displacedLiquids.isEmpty()) {
            ListNBT disp = new ListNBT();
            for (Map.Entry<BlockPos, BlockState> entry : this.displacedLiquids.entrySet()) {
                CompoundNBT p = NBTUtil.func_186859_a((BlockPos)entry.getKey());
                CompoundNBT s = NBTUtil.func_190009_a((BlockState)entry.getValue());
                ListNBT l = new ListNBT();
                l.add(0, (INBT)p);
                l.add(1, (INBT)s);
                disp.add(0, (INBT)l);
            }
            tag.func_218657_a("displacedLiquids", (INBT)disp);
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.progWidgets = TileEntityProgrammer.getWidgetsFromNBT(tag);
        TileEntityProgrammer.updatePuzzleConnections(this.progWidgets);
        this.propSpeed = tag.func_74760_g("propSpeed");
        this.disabledByHacking = tag.func_74767_n("disabledByHacking");
        this.setGoingToOwner(tag.func_74767_n("hackedByOwner"));
        this.setDroneColor(tag.func_74762_e("color"));
        this.aiManager.readFromNBT(tag.func_74775_l("variables"));
        this.standby = tag.func_74767_n("standby");
        this.upgradeInventory.deserializeNBT(tag.func_74775_l("UpgradeInventory"));
        this.upgradeCache.invalidate();
        this.getAirHandler().deserializeNBT(tag.func_74775_l("airHandler"));
        ItemStackHandler tmpInv = new ItemStackHandler();
        tmpInv.deserializeNBT(tag.func_74775_l("Inventory"));
        PneumaticCraftUtils.copyItemHandler((IItemHandler)tmpInv, this.getDroneItemHandler());
        this.fluidTank.setCapacity(16000 * (1 + this.getUpgrades(EnumUpgrade.INVENTORY)));
        this.fluidTank.readFromNBT(tag);
        this.energy.setCapacity(100000 + 100000 * this.getUpgrades(EnumUpgrade.VOLUME));
        if (tag.func_74764_b("owner")) {
            this.ownerName = tag.func_74779_i("owner");
        }
        if (tag.func_74764_b("ownerUUID_M")) {
            this.ownerUUID = new UUID(tag.func_74763_f("ownerUUID_M"), tag.func_74763_f("ownerUUID_L"));
        }
        if (tag.func_74764_b("displacedLiquids")) {
            for (INBT inbt : tag.func_150295_c("displacedLiquids", 9)) {
                ListNBT l = (ListNBT)inbt;
                CompoundNBT p = l.func_150305_b(0);
                CompoundNBT s = l.func_150305_b(1);
                BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)p);
                BlockState state = NBTUtil.func_190008_d((CompoundNBT)s);
                this.displacedLiquids.put(pos, state);
            }
        }
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UUID getOwnerUUID() {
        if (this.ownerUUID == null) {
            Log.warning(String.format("Drone with owner '%s' has no UUID! Substituting the Drone's UUID (%s).", this.ownerName, this.func_110124_au().toString()), new Object[0]);
            this.ownerUUID = this.func_110124_au();
        }
        return this.ownerUUID;
    }

    @Override
    public int getUpgrades(EnumUpgrade upgrade) {
        return this.upgradeCache.getUpgrades(upgrade);
    }

    @Override
    public FakePlayer getFakePlayer() {
        if (this.fakePlayer == null && !this.field_70170_p.field_72995_K) {
            this.fakePlayer = new DroneFakePlayer((ServerWorld)this.field_70170_p, new GameProfile(this.func_110124_au(), this.ownerName + "_drone"), this);
            this.fakePlayer.field_71135_a = new FakeNetHandlerPlayerServer(ServerLifecycleHooks.getCurrentServer(), (ServerPlayerEntity)this.fakePlayer);
        }
        return this.fakePlayer;
    }

    public Minigun getMinigun() {
        if (this.minigun == null) {
            this.minigun = new MinigunDrone().setPlayer((PlayerEntity)this.getFakePlayer()).setWorld(this.field_70170_p).setAirHandler((LazyOptional<? extends IAirHandler>)this.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY), 200);
        }
        return this.minigun;
    }

    public boolean func_70652_k(Entity entity) {
        this.getFakePlayer().func_71059_n(entity);
        this.getAirHandler().addAir(-200);
        return true;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource == DamageSource.field_76368_d) {
            this.isSuffocating = true;
            if (this.suffocationCounter-- > 0 || !PNCConfig.Common.General.enableDroneSuffocation) {
                return false;
            }
        }
        return super.func_70097_a(damageSource, damage);
    }

    @Override
    public IItemHandlerModifiable getInv() {
        return this.getDroneItemHandler();
    }

    public double getSpeed() {
        return this.speed;
    }

    public int getEmittingRedstone(Direction side) {
        return this.emittingRedstoneValues[side.ordinal()];
    }

    @Override
    public void setEmittingRedstone(Direction side, int value) {
        if (this.emittingRedstoneValues[side.ordinal()] != value) {
            this.emittingRedstoneValues[side.ordinal()] = value;
            BlockPos pos = new BlockPos((int)Math.floor(this.field_70165_t + (double)(this.func_213311_cf() / 2.0f)), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v + (double)(this.func_213311_cf() / 2.0f)));
            BlockState state = this.field_70170_p.func_180495_p(pos);
            this.field_70170_p.func_184138_a(pos, state, state, 3);
        }
    }

    @Override
    public boolean isBlockValidPathfindBlock(BlockPos pos) {
        if (this.field_70170_p.func_175623_d(pos)) {
            return true;
        }
        BlockState state = this.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (PneumaticCraftUtils.isBlockLiquid(block)) {
            return this.securityUpgradeCount > 0;
        }
        if (state.func_196957_g((IBlockReader)this.field_70170_p, pos, PathType.LAND)) {
            return true;
        }
        if (!state.func_185904_a().func_76230_c() && block != Blocks.field_150468_ap) {
            return true;
        }
        if (DroneRegistry.getInstance().pathfindableBlocks.containsKey(block)) {
            IPathfindHandler pathfindHandler = DroneRegistry.getInstance().pathfindableBlocks.get(block);
            return pathfindHandler == null || pathfindHandler.canPathfindThrough(this.field_70170_p, pos);
        }
        return false;
    }

    @Override
    public void sendWireframeToClient(BlockPos pos) {
        NetworkHandler.sendToAllAround(new PacketShowWireframe(this, pos), this.field_70170_p);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public boolean canHack(Entity entity, PlayerEntity player) {
        return this.isAccelerating();
    }

    @Override
    public void addHackInfo(Entity entity, List<String> curInfo, PlayerEntity player) {
        if (this.ownerUUID.equals(player.func_110124_au())) {
            if (this.isGoingToOwner()) {
                curInfo.add("pneumaticHelmet.hacking.result.resumeTasks");
            } else {
                curInfo.add("pneumaticHelmet.hacking.result.callBack");
            }
        } else {
            curInfo.add("pneumaticHelmet.hacking.result.disable");
        }
    }

    @Override
    public void addPostHackInfo(Entity entity, List<String> curInfo, PlayerEntity player) {
        if (this.ownerUUID.equals(player.func_110124_au())) {
            if (this.isGoingToOwner()) {
                curInfo.add("pneumaticHelmet.hacking.finished.calledBack");
            } else {
                curInfo.add("pneumaticHelmet.hacking.finished.resumedTasks");
            }
        } else {
            curInfo.add("pneumaticHelmet.hacking.finished.disabled");
        }
    }

    @Override
    public int getHackTime(Entity entity, PlayerEntity player) {
        return this.ownerUUID.equals(player.func_110124_au()) ? 20 : 100;
    }

    @Override
    public void onHackFinished(Entity entity, PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K && player.func_110124_au().equals(this.ownerUUID)) {
            this.setGoingToOwner(this.gotoOwnerAI == null);
        } else {
            this.disabledByHacking = true;
        }
    }

    @Override
    public boolean afterHackTick(Entity entity) {
        return false;
    }

    private void setGoingToOwner(boolean state) {
        if (!this.field_70170_p.field_72995_K) {
            if (state && this.gotoOwnerAI == null) {
                this.gotoOwnerAI = new DroneGoToOwner(this);
                this.field_70714_bg.func_75776_a(2, (Goal)this.gotoOwnerAI);
                this.field_70180_af.func_187227_b(GOING_TO_OWNER, (Object)true);
                this.setActiveProgram(new ProgWidgetGoToLocation());
            } else if (!state && this.gotoOwnerAI != null) {
                this.field_70714_bg.func_85156_a((Goal)this.gotoOwnerAI);
                this.gotoOwnerAI = null;
                this.field_70180_af.func_187227_b(GOING_TO_OWNER, (Object)false);
            }
        }
    }

    private boolean isGoingToOwner() {
        return (Boolean)this.field_70180_af.func_187225_a(GOING_TO_OWNER);
    }

    @Override
    public IFluidTank getFluidTank() {
        return this.fluidTank;
    }

    @Override
    public PlayerEntity getOwner() {
        return this.field_70170_p.func_73046_m().func_184103_al().func_152612_a(this.ownerName);
    }

    public void setStandby(boolean standby) {
        this.standby = standby;
    }

    @Override
    public World world() {
        return this.field_70170_p;
    }

    @Override
    public Vec3d getDronePos() {
        return new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    public void dropItem(ItemStack stack) {
        this.func_70099_a(stack, 0.0f);
    }

    @Override
    public List<IProgWidget> getProgWidgets() {
        return this.progWidgets;
    }

    @Override
    public GoalSelector getTargetAI() {
        return this.field_70715_bh;
    }

    @Override
    public boolean isProgramApplicable(ProgWidgetType widgetType) {
        return true;
    }

    @Override
    public void setName(ITextComponent string) {
        this.func_200203_b(string);
    }

    @Override
    public void setCarryingEntity(Entity entity) {
        if (entity == null) {
            for (Entity e : this.getCarryingEntities()) {
                e.func_184210_p();
                if (!(e instanceof AbstractMinecartEntity) && !(e instanceof BoatEntity)) continue;
                e.field_70163_u -= 2.0;
                if (this.field_70170_p.func_180495_p(e.func_180425_c()).func_215686_e((IBlockReader)this.field_70170_p, e.func_180425_c())) {
                    e.field_70163_u += 1.0;
                }
                if (!(e instanceof AbstractMinecartEntity)) continue;
                e.field_184245_j = 0;
            }
        } else {
            entity.func_184220_m((Entity)this);
        }
    }

    @Override
    public List<Entity> getCarryingEntities() {
        return this.func_184188_bt();
    }

    @Override
    public boolean isAIOverriden() {
        return this.chargeAI.isExecuting || this.gotoOwnerAI != null;
    }

    @Override
    public void onItemPickupEvent(ItemEntity curPickingUpEntity, int stackSize) {
        this.func_71001_a((Entity)curPickingUpEntity, stackSize);
    }

    @Override
    public IPathNavigator getPathNavigator() {
        return (IPathNavigator)this.func_70661_as();
    }

    public void tryFireMinigun(LivingEntity target) {
        int slot = this.getSlotForAmmo();
        EntityDroneItemHandler dih = this.getDroneItemHandler();
        if (slot >= 0) {
            ItemStack ammo = dih.getStackInSlot(slot);
            if (this.getMinigun().setAmmoStack(ammo).tryFireMinigun((Entity)target)) {
                dih.setStackInSlot(slot, ItemStack.field_190927_a);
            }
        }
    }

    public int getSlotForAmmo() {
        EntityDroneItemHandler dih = this.getDroneItemHandler();
        for (int i = 0; i < dih.getSlots(); ++i) {
            if (!(dih.getStackInSlot(i).func_77973_b() instanceof ItemGunAmmo)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void overload(String msgKey, Object ... params) {
        this.func_70097_a(new DamageSourcePneumaticCraft.DamageSourceDroneOverload(msgKey, params), 2000.0f);
    }

    @Override
    public DroneAIManager getAIManager() {
        return this.aiManager;
    }

    @Override
    public LogisticsManager getLogisticsManager() {
        return this.logisticsManager;
    }

    @Override
    public void setLogisticsManager(LogisticsManager logisticsManager) {
        this.logisticsManager = logisticsManager;
    }

    @Override
    public void updateLabel() {
        this.field_70180_af.func_187227_b(LABEL, (Object)(this.getAIManager() != null ? this.getAIManager().getLabel() : "Main"));
    }

    public String getLabel() {
        return (String)this.field_70180_af.func_187225_a(LABEL);
    }

    public DebugEntry getDebugEntry(int widgetID) {
        return this.debugList.get(widgetID);
    }

    @Override
    public void addDebugEntry(String message) {
        this.addDebugEntry(message, null);
    }

    @Override
    public void addDebugEntry(String message, BlockPos pos) {
        DebugEntry entry = new DebugEntry(message, this.getActiveWidgetIndex(), pos);
        this.addDebugEntry(entry);
        PacketSendDroneDebugEntry packet = new PacketSendDroneDebugEntry(entry, this);
        for (ServerPlayerEntity player : this.debuggingPlayers) {
            NetworkHandler.sendToPlayer(packet, player);
        }
    }

    public void addDebugEntry(DebugEntry entry) {
        this.debugList.addEntry(entry);
    }

    public void trackAsDebugged(ServerPlayerEntity player) {
        NetworkHandler.sendToPlayer(new PacketSyncDroneEntityProgWidgets(this), player);
        for (DebugEntry entry : this.debugList.getAll()) {
            NetworkHandler.sendToPlayer(new PacketSendDroneDebugEntry(entry, this), player);
        }
        this.debuggingPlayers.add(player);
    }

    private void updateDebuggingPlayers() {
        this.debuggingPlayers.removeIf(player -> !player.func_70089_S() || !ItemPneumaticArmor.isPlayerDebuggingEntity((PlayerEntity)player, (Entity)this));
    }

    @Override
    public IItemHandler getUpgradeHandler() {
        return this.upgradeInventory;
    }

    @Override
    public void onUpgradesChanged() {
        this.energy.setCapacity(100000 + 100000 * this.getUpgrades(EnumUpgrade.VOLUME));
    }

    public boolean addProgram(BlockPos clickPos, Direction facing, BlockPos placePos, ItemStack droneStack, List<IProgWidget> progWidgets) {
        return false;
    }

    static {
        LASER_COLOR_MAP.put("aureylian", 16738740);
        LASER_COLOR_MAP.put("loneztar", 41120);
        LASER_COLOR_MAP.put("jadedcat", 10494192);
        LASER_COLOR_MAP.put("desht", 0xFF6000);
    }

    private class DroneDebugList {
        private final Map<Integer, DebugEntry> debugEntries = new HashMap<Integer, DebugEntry>();

        private DroneDebugList() {
        }

        void addEntry(DebugEntry entry) {
            this.debugEntries.put(EntityDrone.this.getActiveWidgetIndex(), entry);
        }

        public Collection<DebugEntry> getAll() {
            return this.debugEntries.values();
        }

        public DebugEntry get(int widgetId) {
            return this.debugEntries.get(widgetId);
        }

        public DebugEntry getCurrent() {
            return this.debugEntries.get(EntityDrone.this.getActiveWidgetIndex());
        }
    }

    private class EntityDroneItemHandler
    extends DroneItemHandler {
        EntityDroneItemHandler(IDrone holder) {
            super(holder);
        }

        @Override
        public void copyItemToFakePlayer(int slot) {
            super.copyItemToFakePlayer(slot);
            if (this.isFakePlayerReady() && slot == EntityDrone.this.getFakePlayer().field_71071_by.field_70461_c && PNCConfig.Common.General.dronesRenderHeldItem) {
                EntityDrone.this.field_70180_af.func_187227_b(HELD_ITEM, (Object)this.getStackInSlot(slot));
            }
        }
    }

    public class MinigunDrone
    extends Minigun {
        MinigunDrone() {
            super(true);
        }

        @Override
        public Object getSoundSource() {
            return EntityDrone.this;
        }

        @Override
        public boolean isMinigunActivated() {
            return EntityDrone.this.isMinigunActivated();
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            EntityDrone.this.setMinigunActivated(activated);
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            EntityDrone.this.setAmmoColor(ammo);
        }

        @Override
        public int getAmmoColor() {
            return EntityDrone.this.getAmmoColor();
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            NetworkHandler.sendToAllAround(new PacketPlaySound(soundName, SoundCategory.NEUTRAL, EntityDrone.this.field_70165_t, EntityDrone.this.field_70163_u, EntityDrone.this.field_70161_v, volume, pitch, true), this.world);
        }

        @Override
        public boolean isValid() {
            return EntityDrone.this.func_70089_S();
        }
    }
}

