/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderBlockTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderEntityTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.hacking.WorldAndCoord;
import me.desht.pneumaticcraft.common.hacking.block.HackableButton;
import me.desht.pneumaticcraft.common.hacking.block.HackableDispenser;
import me.desht.pneumaticcraft.common.hacking.block.HackableDoor;
import me.desht.pneumaticcraft.common.hacking.block.HackableJukebox;
import me.desht.pneumaticcraft.common.hacking.block.HackableLever;
import me.desht.pneumaticcraft.common.hacking.block.HackableMobSpawner;
import me.desht.pneumaticcraft.common.hacking.block.HackableNoteblock;
import me.desht.pneumaticcraft.common.hacking.block.HackableSecurityStation;
import me.desht.pneumaticcraft.common.hacking.block.HackableSilverfish;
import me.desht.pneumaticcraft.common.hacking.block.HackableTNT;
import me.desht.pneumaticcraft.common.hacking.block.HackableTripwire;
import me.desht.pneumaticcraft.common.hacking.entity.HackableBat;
import me.desht.pneumaticcraft.common.hacking.entity.HackableBlaze;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCaveSpider;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCow;
import me.desht.pneumaticcraft.common.hacking.entity.HackableCreeper;
import me.desht.pneumaticcraft.common.hacking.entity.HackableEnderman;
import me.desht.pneumaticcraft.common.hacking.entity.HackableGhast;
import me.desht.pneumaticcraft.common.hacking.entity.HackableGuardian;
import me.desht.pneumaticcraft.common.hacking.entity.HackableHorse;
import me.desht.pneumaticcraft.common.hacking.entity.HackableItemFrame;
import me.desht.pneumaticcraft.common.hacking.entity.HackableLivingDisarm;
import me.desht.pneumaticcraft.common.hacking.entity.HackablePainting;
import me.desht.pneumaticcraft.common.hacking.entity.HackableShulker;
import me.desht.pneumaticcraft.common.hacking.entity.HackableTameable;
import me.desht.pneumaticcraft.common.hacking.entity.HackableVillager;
import me.desht.pneumaticcraft.common.hacking.entity.HackableWitch;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class HackableHandler {
    private final Map<Entity, IHackableEntity> trackedHackableEntities = new HashMap<Entity, IHackableEntity>();
    private final Map<WorldAndCoord, IHackableBlock> trackedHackableBlocks = new HashMap<WorldAndCoord, IHackableBlock>();
    private static HackableHandler clientInstance;
    private static HackableHandler serverInstance;

    private static HackableHandler getInstance() {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            if (clientInstance == null) {
                clientInstance = new HackableHandler();
            }
            return clientInstance;
        }
        if (serverInstance == null) {
            serverInstance = new HackableHandler();
        }
        return serverInstance;
    }

    public static void addDefaultEntries() {
        IPneumaticHelmetRegistry manager = PneumaticRegistry.getInstance().getHelmetRegistry();
        manager.addHackable(Blocks.field_150335_W, HackableTNT.class);
        manager.addHackable(Blocks.field_150474_ac, HackableMobSpawner.class);
        manager.addHackable(Blocks.field_150442_at, HackableLever.class);
        manager.addHackable((Tag<Block>)BlockTags.field_200027_d, HackableButton.class);
        manager.addHackable((Tag<Block>)BlockTags.field_200029_f, HackableDoor.class);
        manager.addHackable(Blocks.field_150479_bC, HackableTripwire.class);
        manager.addHackable(Blocks.field_150367_z, HackableDispenser.class);
        manager.addHackable(Blocks.field_150409_cd, HackableDispenser.class);
        manager.addHackable((Block)ModBlocks.SECURITY_STATION.get(), HackableSecurityStation.class);
        manager.addHackable(Blocks.field_196687_dd, HackableSilverfish.class);
        manager.addHackable(Blocks.field_196694_dh, HackableSilverfish.class);
        manager.addHackable(Blocks.field_196692_dg, HackableSilverfish.class);
        manager.addHackable(Blocks.field_196690_df, HackableSilverfish.class);
        manager.addHackable(Blocks.field_196686_dc, HackableSilverfish.class);
        manager.addHackable(Blocks.field_196688_de, HackableSilverfish.class);
        manager.addHackable(Blocks.field_196586_al, HackableNoteblock.class);
        manager.addHackable(Blocks.field_150421_aI, HackableJukebox.class);
        manager.addHackable(CreeperEntity.class, HackableCreeper.class);
        manager.addHackable(TameableEntity.class, HackableTameable.class);
        manager.addHackable(CowEntity.class, HackableCow.class);
        manager.addHackable(CaveSpiderEntity.class, HackableCaveSpider.class);
        manager.addHackable(BlazeEntity.class, HackableBlaze.class);
        manager.addHackable(GhastEntity.class, HackableGhast.class);
        manager.addHackable(WitchEntity.class, HackableWitch.class);
        manager.addHackable(MobEntity.class, HackableLivingDisarm.class);
        manager.addHackable(EndermanEntity.class, HackableEnderman.class);
        manager.addHackable(BatEntity.class, HackableBat.class);
        manager.addHackable(HorseEntity.class, HackableHorse.class);
        manager.addHackable(ShulkerEntity.class, HackableShulker.class);
        manager.addHackable(GuardianEntity.class, HackableGuardian.class);
        manager.addHackable(VillagerEntity.class, HackableVillager.class);
        manager.addHackable(PaintingEntity.class, HackablePainting.class);
        manager.addHackable(ItemFrameEntity.class, HackableItemFrame.class);
    }

    public static IHackableEntity getHackableForEntity(Entity entity, PlayerEntity player) {
        HackableHandler.getInstance().trackedHackableEntities.entrySet().removeIf(entry -> !((Entity)entry.getKey()).func_70089_S() || !((IHackableEntity)entry.getValue()).canHack((Entity)entry.getKey(), player) && !HackableHandler.isInDisplayCooldown((IHackableEntity)entry.getValue(), (Entity)entry.getKey()));
        if (entity instanceof IHackableEntity && ((IHackableEntity)entity).canHack(entity, player)) {
            return (IHackableEntity)entity;
        }
        IHackableEntity hackable = HackableHandler.getInstance().trackedHackableEntities.get(entity);
        if (hackable == null) {
            for (Map.Entry<Class<? extends Entity>, Class<? extends IHackableEntity>> entry2 : PneumaticHelmetRegistry.getInstance().hackableEntities.entrySet()) {
                if (!entry2.getKey().isAssignableFrom(entity.getClass())) continue;
                try {
                    hackable = entry2.getValue().newInstance();
                    if (hackable.canHack(entity, player)) {
                        HackableHandler.getInstance().trackedHackableEntities.put(entity, hackable);
                        break;
                    }
                    hackable = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return hackable;
    }

    public static IHackableBlock getHackableForCoord(WorldAndCoord coord, PlayerEntity player) {
        return HackableHandler.getHackableForCoord(coord.world, coord.pos, player);
    }

    public static IHackableBlock getHackableForCoord(IBlockReader world, BlockPos pos, PlayerEntity player) {
        Iterator<Map.Entry<WorldAndCoord, IHackableBlock>> iterator = HackableHandler.getInstance().trackedHackableBlocks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WorldAndCoord, IHackableBlock> entry = iterator.next();
            Class<? extends IHackableBlock> hackableBlockClazz = PneumaticHelmetRegistry.getInstance().getHackableBlock(entry.getKey().getBlock());
            if (hackableBlockClazz == entry.getValue().getClass() && (entry.getValue().canHack(entry.getKey().world, entry.getKey().pos, player) || HackableHandler.isInDisplayCooldown(entry.getValue(), entry.getKey().world, entry.getKey().pos, player))) continue;
            iterator.remove();
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof IHackableBlock && ((IHackableBlock)block).canHack(world, pos, player)) {
            return (IHackableBlock)block;
        }
        IHackableBlock hackable = HackableHandler.getInstance().trackedHackableBlocks.get(new WorldAndCoord(world, pos));
        if (hackable == null) {
            Class<? extends IHackableBlock> cls = PneumaticHelmetRegistry.getInstance().getHackableBlock(block);
            if (cls == null) {
                return null;
            }
            try {
                hackable = cls.newInstance();
                if (hackable.canHack(world, pos, player)) {
                    HackableHandler.getInstance().trackedHackableBlocks.put(new WorldAndCoord(world, pos), hackable);
                } else {
                    hackable = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hackable;
    }

    private static boolean isInDisplayCooldown(IHackableBlock hackableBlock, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            RenderBlockTarget target = HUDHandler.instance().getSpecificRenderer(BlockTrackUpgradeHandler.class).getTargetForCoord(pos);
            int requiredHackTime = hackableBlock.getHackTime(world, pos, player);
            return target != null && target.getHackTime() >= requiredHackTime && target.getHackTime() <= requiredHackTime + 20;
        }
        return false;
    }

    private static boolean isInDisplayCooldown(IHackableEntity hackableBlock, Entity entity) {
        if (entity.field_70170_p.field_72995_K) {
            RenderEntityTarget target = HUDHandler.instance().getSpecificRenderer(EntityTrackUpgradeHandler.class).getTargetForEntity(entity);
            int requiredHackTime = hackableBlock.getHackTime(entity, ClientUtils.getClientPlayer());
            return target != null && target.getHackTime() >= requiredHackTime && target.getHackTime() <= requiredHackTime + 20;
        }
        return false;
    }
}

