/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ICustomDurabilityBar;
import me.desht.pneumaticcraft.common.item.ItemNonDespawning;
import me.desht.pneumaticcraft.common.tileentity.TileEntityUVLightBox;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;

public class ItemEmptyPCB
extends ItemNonDespawning
implements ICustomDurabilityBar {
    private static final String NBT_ETCH_PROGRESS = "pneumaticcraft:etch_progress";

    @Override
    public void func_77624_a(ItemStack stack, World player, List<ITextComponent> infoList, ITooltipFlag par4) {
        super.func_77624_a(stack, player, infoList, par4);
        int uvProgress = TileEntityUVLightBox.getExposureProgress(stack);
        int etchProgress = ItemEmptyPCB.getEtchProgress(stack);
        infoList.add(PneumaticCraftUtils.xlate("gui.tooltip.item.uvLightBox.successChance", uvProgress));
        if (uvProgress < 100 && etchProgress == 0) {
            infoList.add(PneumaticCraftUtils.xlate("gui.tooltip.item.uvLightBox.putInLightBox", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
        if (etchProgress > 0) {
            infoList.add(PneumaticCraftUtils.xlate("gui.tooltip.item.uvLightBox.etchProgress", etchProgress));
        }
        if (uvProgress > 0) {
            infoList.add(PneumaticCraftUtils.xlate("gui.tooltip.item.uvLightBox.putInAcid", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    public static int getEtchProgress(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74762_e(NBT_ETCH_PROGRESS) : 0;
    }

    public static void setEtchProgress(ItemStack stack, int progress) {
        Validate.isTrue((progress >= 0 && progress <= 100 ? 1 : 0) != 0);
        stack.func_196082_o().func_74768_a(NBT_ETCH_PROGRESS, progress);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int progress = TileEntityUVLightBox.getExposureProgress(stack);
        return 1.0 - (double)progress / 100.0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        int progress = TileEntityUVLightBox.getExposureProgress(stack);
        return progress << 16 | 0xFF;
    }

    @Override
    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        super.onEntityItemUpdate(stack, entityItem);
        if (entityItem.field_70170_p.func_204610_c(new BlockPos((Entity)entityItem)).func_206886_c().func_207185_a(PneumaticCraftTags.Fluids.ETCHING_ACID)) {
            int etchProgress;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new CompoundNBT());
            }
            if ((etchProgress = ItemEmptyPCB.getEtchProgress(stack)) < 100) {
                if (entityItem.field_70173_aa % 60 == 0) {
                    ItemEmptyPCB.setEtchProgress(stack, etchProgress + 1);
                }
                World world = entityItem.func_130014_f_();
                if (world.field_73012_v.nextInt(15) == 0) {
                    double x = entityItem.field_70165_t + world.field_73012_v.nextDouble() * 0.3 - 0.15;
                    double y = entityItem.field_70163_u - 0.15;
                    double z = entityItem.field_70161_v + world.field_73012_v.nextDouble() * 0.3 - 0.15;
                    world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, x, y, z, 0.0, 0.05, 0.0);
                }
            } else if (!entityItem.field_70170_p.field_72995_K) {
                int successCount = 0;
                int failedCount = 0;
                int uvProgress = TileEntityUVLightBox.getExposureProgress(stack);
                for (int i = 0; i < stack.func_190916_E(); ++i) {
                    if (entityItem.field_70170_p.field_73012_v.nextInt(100) <= uvProgress) {
                        ++successCount;
                        continue;
                    }
                    ++failedCount;
                }
                ItemStack successStack = new ItemStack(successCount == 0 ? (IItemProvider)ModItems.FAILED_PCB.get() : (IItemProvider)ModItems.UNASSEMBLED_PCB.get(), successCount == 0 ? failedCount : successCount);
                entityItem.func_92058_a(successStack);
                if (successCount > 0 && failedCount > 0) {
                    ItemStack failedStack = new ItemStack((IItemProvider)ModItems.FAILED_PCB.get(), failedCount);
                    entityItem.field_70170_p.func_217376_c((Entity)new ItemEntity(entityItem.field_70170_p, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, failedStack));
                }
            }
        }
        return false;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack stack = new ItemStack((IItemProvider)this);
            TileEntityUVLightBox.setExposureProgress(stack, 100);
            items.add((Object)stack);
        }
    }

    @Override
    public boolean shouldShowCustomDurabilityBar(ItemStack stack) {
        return ItemEmptyPCB.getEtchProgress(stack) > 0;
    }

    @Override
    public int getCustomDurabilityColour(ItemStack stack) {
        return MaterialColor.field_151653_I.field_76291_p;
    }

    @Override
    public float getCustomDurability(ItemStack stack) {
        return (float)ItemEmptyPCB.getEtchProgress(stack) / 100.0f;
    }

    @Override
    public boolean isShowingOtherBar(ItemStack stack) {
        return true;
    }
}

