/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.areatool.GuiGPSAreaTool;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.Validate;

public class ItemGPSAreaTool
extends Item
implements IPositionProvider {
    public ItemGPSAreaTool() {
        super(ModItems.defaultProps());
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        ItemGPSAreaTool.setGPSPosAndNotify(ctx.func_195999_j(), ctx.func_195995_a(), ctx.func_221531_n(), 0);
        ctx.func_195999_j().func_184185_a((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            GuiGPSAreaTool.showGUI(stack, handIn, 0);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
    }

    public static void setGPSPosAndNotify(PlayerEntity player, BlockPos pos, Hand hand, int index) {
        ItemStack stack = player.func_184586_b(hand);
        ItemGPSAreaTool.setGPSLocation(stack, pos, index);
        if (!player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + String.format("[%s] %s", stack.func_200301_q().func_150254_d(), ItemGPSAreaTool.getMessageText(pos, index))), false);
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SHeldItemChangePacket(player.field_71071_by.field_70461_c));
            }
        }
    }

    private static String getMessageText(BlockPos pos, int index) {
        String str = String.format("P%d%s: [%d, %d, %d]", index + 1, TextFormatting.YELLOW.toString(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return (index == 0 ? TextFormatting.RED.toString() : TextFormatting.GREEN.toString()) + str;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> infoList, ITooltipFlag par4) {
        super.func_77624_a(stack, worldIn, infoList, par4);
        for (int index = 0; index < 2; ++index) {
            BlockPos pos = ItemGPSAreaTool.getGPSLocation(worldIn, stack, index);
            infoList.add(new StringTextComponent(ItemGPSAreaTool.getMessageText(pos, index)).func_211708_a(index == 0 ? TextFormatting.RED : TextFormatting.GREEN));
            String varName = ItemGPSAreaTool.getVariable(stack, index);
            if (varName.isEmpty()) continue;
            infoList.add(PneumaticCraftUtils.xlate("gui.tooltip.gpsTool.variable", varName));
        }
        ItemGPSAreaTool.getArea(stack).addAreaTypeTooltip(infoList);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean heldItem) {
        if (!world.field_72995_K) {
            for (int index = 0; index < 2; ++index) {
                String var = ItemGPSAreaTool.getVariable(stack, index);
                if (var.isEmpty()) continue;
                BlockPos pos = GlobalVariableManager.getInstance().getPos(var);
                ItemGPSAreaTool.setGPSLocation(stack, pos, index);
            }
        }
    }

    @Nonnull
    public static ProgWidgetArea getArea(ItemStack stack) {
        Validate.isTrue((boolean)(stack.func_77973_b() instanceof ItemGPSAreaTool));
        ProgWidgetArea area = new ProgWidgetArea();
        if (stack.func_77942_o()) {
            area.readFromNBT(stack.func_77978_p());
        }
        return area;
    }

    public static BlockPos getGPSLocation(World world, ItemStack gpsTool, int index) {
        ProgWidgetArea area = ItemGPSAreaTool.getArea(gpsTool);
        String var = ItemGPSAreaTool.getVariable(gpsTool, index);
        if (!var.equals("") && !world.field_72995_K) {
            BlockPos pos = GlobalVariableManager.getInstance().getPos(var);
            ItemGPSAreaTool.setGPSLocation(gpsTool, pos, index);
        }
        if (index == 0) {
            return new BlockPos(area.x1, area.y1, area.z1);
        }
        if (index == 1) {
            return new BlockPos(area.x2, area.y2, area.z2);
        }
        throw new IllegalArgumentException("index must be 0 or 1!");
    }

    private static void setGPSLocation(ItemStack gpsTool, BlockPos pos, int index) {
        ProgWidgetArea area = ItemGPSAreaTool.getArea(gpsTool);
        if (index == 0) {
            area.setP1(pos);
        } else if (index == 1) {
            area.setP2(pos);
        }
        NBTUtil.initNBTTagCompound(gpsTool);
        area.writeToNBT(gpsTool.func_77978_p());
    }

    public static void setVariable(ItemStack gpsTool, String variable, int index) {
        ProgWidgetArea area = ItemGPSAreaTool.getArea(gpsTool);
        if (index == 0) {
            area.setCoord1Variable(variable);
        } else if (index == 1) {
            area.setCoord2Variable(variable);
        }
        NBTUtil.initNBTTagCompound(gpsTool);
        area.writeToNBT(gpsTool.func_77978_p());
    }

    public static String getVariable(ItemStack gpsTool, int index) {
        ProgWidgetArea area = ItemGPSAreaTool.getArea(gpsTool);
        return index == 0 ? area.getCoord1Variable() : area.getCoord2Variable();
    }

    @Override
    public List<BlockPos> getStoredPositions(World world, @Nonnull ItemStack stack) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        ItemGPSAreaTool.getArea(stack).getArea(posSet);
        return new ArrayList<BlockPos>(posSet);
    }

    @Override
    public int getRenderColor(int index) {
        return -1862271232;
    }

    @Override
    public boolean disableDepthTest() {
        return false;
    }

    public static class EventHandler {
        @SubscribeEvent
        public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
            if (event.getItemStack().func_77973_b() == ModItems.GPS_AREA_TOOL.get()) {
                if (!event.getPos().equals((Object)ItemGPSAreaTool.getGPSLocation(event.getWorld(), event.getItemStack(), 1))) {
                    event.getPlayer().func_184185_a((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
                    ItemGPSAreaTool.setGPSPosAndNotify(event.getPlayer(), event.getPos(), event.getHand(), 1);
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
            if (event.getItemStack().func_77973_b() == ModItems.GPS_AREA_TOOL.get()) {
                GuiGPSAreaTool.showGUI(event.getItemStack(), event.getHand(), 1);
            }
        }
    }
}

