/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.UUID;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class ItemGunAmmoFreezing
extends ItemGunAmmo {
    private static final UUID KNOCKBACK_UUID = UUID.fromString("49b2f9a8-228d-4be5-96ce-6f9ce2877145");
    private static final AttributeModifier KNOCKBACK = new AttributeModifier(KNOCKBACK_UUID, "Temp. Knockback Resist", 1.0, AttributeModifier.Operation.ADDITION);

    @Override
    public int getMaxDamage(ItemStack stack) {
        return PNCConfig.Common.Minigun.freezingAmmoCartridgeSize;
    }

    @Override
    public int getAmmoColor(ItemStack ammo) {
        return 4235519;
    }

    @Override
    protected float getDamageMultiplier(Entity target, ItemStack ammoStack) {
        double mul = super.getDamageMultiplier(target, ammoStack);
        if (target != null && target.func_70045_F()) {
            mul *= 1.5;
        }
        return (float)mul;
    }

    @Override
    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            IAttributeInstance knockbackRes = living.func_110148_a(SharedMonsterAttributes.field_111266_c);
            living.func_195064_c(new EffectInstance(Effects.field_76421_d, living.func_70681_au().nextInt(40) + 40, 3));
            knockbackRes.func_111121_a(KNOCKBACK);
            if (minigun.dispenserWeightedPercentage(PNCConfig.Common.Minigun.freezingAmmoEntityIceChance)) {
                this.createFreezeCloud(minigun, target);
            }
            int rounds = super.onTargetHit(minigun, ammo, target);
            knockbackRes.func_188479_b(KNOCKBACK_UUID);
            return rounds;
        }
        return super.onTargetHit(minigun, ammo, target);
    }

    private void createFreezeCloud(Minigun minigun, Entity target) {
        World world = target.func_130014_f_();
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(world, target.field_70165_t, target.field_70163_u, target.field_70161_v);
        cloud.func_184484_a(Potions.field_185246_r);
        cloud.func_184481_a((LivingEntity)minigun.getPlayer());
        cloud.func_184496_a(new EffectInstance(Effects.field_76421_d, 100, 3));
        cloud.func_184496_a(new EffectInstance(Effects.field_82731_v, 20, 1));
        cloud.func_184483_a(2.0f);
        cloud.func_184486_b(60);
        cloud.func_184495_b(-0.5f);
        cloud.func_184485_d(20);
        cloud.func_184482_a(-16727809);
        cloud.func_184487_c(-cloud.func_184490_j() / (float)cloud.func_184489_o());
        world.func_217376_c((Entity)cloud);
    }

    @Override
    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockRayTraceResult brtr) {
        World world = minigun.getWorld();
        BlockPos pos = brtr.func_216350_a();
        if (world.func_201675_m().func_186058_p() != DimensionType.field_223228_b_ && minigun.dispenserWeightedPercentage(PNCConfig.Common.Minigun.freezingAmmoBlockIceChance)) {
            Vec3d eye;
            RayTraceContext ctx;
            BlockRayTraceResult res;
            BlockPos pos1 = world.func_180495_p(pos).func_196954_c((IBlockReader)world, pos) == VoxelShapes.func_197868_b() || brtr.func_216354_b() != Direction.UP ? pos.func_177972_a(brtr.func_216354_b()) : pos;
            BlockState newState = null;
            if (world.func_175623_d(pos1) && !world.func_175623_d(pos1.func_177977_b())) {
                newState = (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((IProperty)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(1));
            } else if (world.func_180495_p(pos1).func_177230_c() == Blocks.field_150433_aE) {
                BlockState state = world.func_180495_p(pos1);
                int level = (Integer)state.func_177229_b((IProperty)SnowBlock.field_176315_a);
                newState = level < 8 ? (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((IProperty)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(level + 1)) : Blocks.field_196604_cC.func_176223_P();
            } else if (world.func_180495_p(pos1).func_177230_c() == Blocks.field_150355_j && (res = world.func_217299_a(ctx = new RayTraceContext(eye = minigun.getPlayer().func_174824_e(0.0f), brtr.func_216347_e(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)minigun.getPlayer()))).func_216346_c() == RayTraceResult.Type.BLOCK) {
                pos1 = res.func_216350_a();
                newState = Blocks.field_150432_aD.func_176223_P();
            }
            if (newState != null) {
                PneumaticCraftUtils.tryPlaceBlock(world, pos1, minigun.getPlayer(), brtr.func_216354_b(), newState);
            }
        }
        return super.onBlockHit(minigun, ammo, brtr);
    }
}

