/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.capabilities.AirHandlerItemStack;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemPressurizable
extends Item {
    private final int volume;
    private final float maxPressure;

    public ItemPressurizable(int maxAir, int volume) {
        this(ModItems.defaultProps(), maxAir, volume);
    }

    public ItemPressurizable(Item.Properties props, int maxAir, int volume) {
        super(props);
        this.volume = volume;
        this.maxPressure = (float)maxAir / (float)volume;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemPressurizable.shouldShowPressureDurability(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ItemPressurizable.getPressureDurabilityColor(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ((Float)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> Float.valueOf(1.0f - h.getPressure() / h.maxPressure())).orElse((Object)Float.valueOf(1.0f))).floatValue();
    }

    public static int getPressureDurabilityColor(ItemStack stack) {
        return (Integer)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(airHandler -> {
            float f = airHandler.getPressure() / airHandler.maxPressure();
            int c = (int)(64.0f + 191.0f * f);
            return 0x400000 | c << 8 | 0xFF;
        }).orElse((Object)0xC0C0C0);
    }

    public static boolean shouldShowPressureDurability(ItemStack stack) {
        if (PNCConfig.Client.alwaysShowPressureDurabilityBar) {
            return true;
        }
        return (Boolean)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(airHandler -> airHandler.getPressure() < airHandler.maxPressure()).orElse((Object)false);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack stack = new ItemStack((IItemProvider)this);
            new AirHandlerItemStack(stack, this.volume, this.maxPressure).addAir((int)((float)this.volume * this.maxPressure));
            items.add((Object)stack);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (this instanceof ItemPressurizable) {
            return new AirHandlerItemStack(stack, this.volume, this.maxPressure);
        }
        return super.initCapabilities(stack, nbt);
    }
}

