/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.network.PacketAbstractAmadronTrade;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketAmadronTradeNotifyDeal
extends PacketAbstractAmadronTrade {
    private int offerAmount;
    private String buyingPlayer;

    public PacketAmadronTradeNotifyDeal() {
    }

    public PacketAmadronTradeNotifyDeal(AmadronPlayerOffer offer, int offerAmount, String buyingPlayer) {
        super(offer);
        this.offerAmount = offerAmount;
        this.buyingPlayer = buyingPlayer;
    }

    public PacketAmadronTradeNotifyDeal(PacketBuffer buffer) {
        super(buffer);
        this.offerAmount = buffer.readInt();
        this.buyingPlayer = buffer.func_218666_n();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeInt(this.offerAmount);
        buf.func_180714_a(this.buyingPlayer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (PNCConfig.Common.Amadron.notifyOfDealMade) {
                ClientUtils.getClientPlayer().func_146105_b(PneumaticCraftUtils.xlate("message.amadron.playerBought", this.buyingPlayer, this.offerAmount, this.getOffer().getOutput().toString(), this.getOffer().getInput().toString()), false);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

