/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.IDescSynced;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.SyncedField;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDescription
extends LocationIntPacket {
    private byte[] types;
    private Object[] values;
    private CompoundNBT extraData;
    private IDescSynced.Type type;

    public PacketDescription() {
    }

    public PacketDescription(IDescSynced te) {
        super(te.getPosition());
        this.type = te.getSyncType();
        this.values = new Object[te.getDescriptionFields().size()];
        this.types = new byte[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = te.getDescriptionFields().get(i).getValue();
            this.types[i] = SyncedField.getType(te.getDescriptionFields().get(i));
        }
        this.extraData = new CompoundNBT();
        te.writeToPacket(this.extraData);
    }

    public PacketDescription(PacketBuffer buf) {
        super(buf);
        this.type = IDescSynced.Type.values()[buf.readByte()];
        int dataAmount = buf.readInt();
        this.types = new byte[dataAmount];
        this.values = new Object[dataAmount];
        for (int i = 0; i < dataAmount; ++i) {
            this.types[i] = buf.readByte();
            this.values[i] = SyncedField.fromBytes(buf, this.types[i]);
        }
        this.extraData = buf.func_150793_b();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeByte(this.type.ordinal());
        buf.writeInt(this.values.length);
        for (int i = 0; i < this.types.length; ++i) {
            buf.writeByte((int)this.types[i]);
            SyncedField.toBytes(buf, this.values[i], this.types[i]);
        }
        buf.func_150786_a(this.extraData);
    }

    public void process(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(this::process);
        ctx.get().setPacketHandled(true);
    }

    public void process() {
        Object syncable;
        PlayerEntity player = ClientUtils.getClientPlayer();
        if (player.field_70170_p.isAreaLoaded(this.pos, 0) && (syncable = this.getSyncableForType(player, this.type)) instanceof IDescSynced) {
            IDescSynced descSynced = (IDescSynced)syncable;
            List<SyncedField> descFields = descSynced.getDescriptionFields();
            if (descFields != null && descFields.size() == this.types.length) {
                for (int i = 0; i < descFields.size(); ++i) {
                    descFields.get(i).setValue(this.values[i]);
                }
            }
            descSynced.readFromPacket(this.extraData);
            descSynced.onDescUpdate();
        }
    }

    private Object getSyncableForType(PlayerEntity player, IDescSynced.Type type) {
        if (type == IDescSynced.Type.TILE_ENTITY) {
            return player.field_70170_p.func_175625_s(this.pos);
        }
        return null;
    }

    public CompoundNBT writeNBT(CompoundNBT compound) {
        compound.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        compound.func_74768_a("SyncType", this.type.ordinal());
        compound.func_74768_a("Length", this.values.length);
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.types.length; ++i) {
            CompoundNBT element = new CompoundNBT();
            element.func_74774_a("Type", this.types[i]);
            buf.clear();
            SyncedField.toBytes(buf, this.values[i], this.types[i]);
            element.func_74773_a("Value", Arrays.copyOf(buf.array(), buf.writerIndex()));
            list.add(list.size(), (INBT)element);
        }
        buf.release();
        compound.func_218657_a("Data", (INBT)list);
        compound.func_218657_a("Extra", (INBT)this.extraData);
        return compound;
    }

    public PacketDescription(CompoundNBT compound) {
        super(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Pos")));
        this.type = IDescSynced.Type.values()[compound.func_74762_e("SyncType")];
        this.values = new Object[compound.func_74762_e("Length")];
        this.types = new byte[this.values.length];
        ListNBT list = compound.func_150295_c("Data", 10);
        for (int i = 0; i < this.values.length; ++i) {
            CompoundNBT element = list.func_150305_b(i);
            this.types[i] = element.func_74771_c("Type");
            byte[] b = element.func_74770_j("Value");
            this.values[i] = SyncedField.fromBytes(new PacketBuffer(Unpooled.wrappedBuffer((byte[])b)), this.types[i]);
        }
        this.extraData = compound.func_74775_l("Extra");
    }
}

