/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketPlayMovingSound {
    private MovingSounds.Sound sound;
    private int entityId;
    private SourceType sourceType;
    private BlockPos pos;

    public PacketPlayMovingSound() {
    }

    public PacketPlayMovingSound(MovingSounds.Sound sound, Object soundSource) {
        this.sound = sound;
        if (soundSource instanceof Entity) {
            this.sourceType = SourceType.ENTITY;
            this.entityId = ((Entity)soundSource).func_145782_y();
        } else if (soundSource instanceof TileEntity) {
            this.sourceType = SourceType.STATIC_POS;
            this.pos = ((TileEntity)soundSource).func_174877_v();
        } else if (soundSource instanceof BlockPos) {
            this.sourceType = SourceType.STATIC_POS;
            this.pos = new BlockPos((Vec3i)((BlockPos)soundSource));
        } else {
            throw new IllegalArgumentException("invalid sound source: " + soundSource);
        }
    }

    public PacketPlayMovingSound(PacketBuffer buffer) {
        this.sound = MovingSounds.Sound.values()[buffer.readByte()];
        this.sourceType = SourceType.values()[buffer.readByte()];
        if (this.sourceType == SourceType.ENTITY) {
            this.entityId = buffer.readInt();
        } else if (this.sourceType == SourceType.STATIC_POS) {
            this.pos = buffer.func_179259_c();
        }
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeByte(this.sound.ordinal());
        buffer.writeByte(this.sourceType.ordinal());
        if (this.sourceType == SourceType.ENTITY) {
            buffer.writeInt(this.entityId);
        } else if (this.sourceType == SourceType.STATIC_POS) {
            buffer.func_179255_a(this.pos);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (this.sourceType == SourceType.ENTITY) {
                Entity e = ClientUtils.getClientWorld().func_73045_a(this.entityId);
                if (e != null) {
                    MovingSounds.playMovingSound(this.sound, e);
                }
            } else if (this.sourceType == SourceType.STATIC_POS) {
                MovingSounds.playMovingSound(this.sound, this.pos);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    static enum SourceType {
        ENTITY,
        STATIC_POS;

    }
}

