/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySmartChest;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSmartChestSync
extends LocationIntPacket {
    private int lastSlot;
    private List<Pair<Integer, Item>> filter;

    public PacketSmartChestSync() {
    }

    public PacketSmartChestSync(TileEntitySmartChest te) {
        super(te.func_174877_v());
        this.lastSlot = te.getLastSlot();
        this.filter = te.getFilter();
    }

    PacketSmartChestSync(PacketBuffer buffer) {
        super(buffer);
        this.lastSlot = buffer.func_150792_a();
        int nFilters = buffer.func_150792_a();
        this.filter = new ArrayList<Pair<Integer, Item>>();
        for (int i = 0; i < nFilters; ++i) {
            int slot = buffer.func_150792_a();
            Item item = Item.func_150899_d((int)buffer.func_150792_a());
            this.filter.add((Pair<Integer, Item>)Pair.of((Object)slot, (Object)item));
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.func_150787_b(this.lastSlot);
        buf.func_150787_b(this.filter.size());
        for (Pair<Integer, Item> p : this.filter) {
            buf.func_150787_b(((Integer)p.getLeft()).intValue());
            buf.func_150787_b(Item.func_150891_b((Item)((Item)p.getRight()).getItem()));
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World w = ((NetworkEvent.Context)ctx.get()).getSender() == null ? ClientUtils.getClientWorld() : ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q();
            this.process(w);
        });
        ctx.get().setPacketHandled(true);
    }

    private void process(World w) {
        TileEntity te = w.func_175625_s(this.pos);
        if (te instanceof TileEntitySmartChest) {
            TileEntitySmartChest teSC = (TileEntitySmartChest)te;
            teSC.setLastSlot(this.lastSlot);
            teSC.setFilter(this.filter);
        }
    }
}

