/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.crafting.PneumaticCraftRecipes;
import me.desht.pneumaticcraft.api.crafting.recipe.IAssemblyRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.IExplosionCraftingRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.IHeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.IModRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.IPressureChamberRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.IRefineryRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.IThermopneumaticProcessingPlantRecipe;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncRecipes {
    private final Map<ResourceLocation, IPressureChamberRecipe> pressureChamberRecipes;
    private final Map<ResourceLocation, IThermopneumaticProcessingPlantRecipe> thermopneumaticProcessingPlantRecipes;
    private final Map<ResourceLocation, IHeatFrameCoolingRecipe> heatFrameCoolingRecipes;
    private final Map<ResourceLocation, IExplosionCraftingRecipe> explosionCraftingRecipes;
    private final Map<ResourceLocation, IRefineryRecipe> refineryRecipes;
    private final Map<ResourceLocation, IAssemblyRecipe> assemblyLaserRecipes;
    private final Map<ResourceLocation, IAssemblyRecipe> assemblyDrillRecipes;
    private final Map<ResourceLocation, IAssemblyRecipe> assemblyLaserDrillRecipes;

    public PacketSyncRecipes(Map<ResourceLocation, IPressureChamberRecipe> pressureChamberRecipes, Map<ResourceLocation, IThermopneumaticProcessingPlantRecipe> thermopneumaticProcessingPlantRecipes, Map<ResourceLocation, IHeatFrameCoolingRecipe> heatFrameCoolingRecipes, Map<ResourceLocation, IExplosionCraftingRecipe> explosionCraftingRecipes, Map<ResourceLocation, IRefineryRecipe> refineryRecipes, Map<ResourceLocation, IAssemblyRecipe> assemblyLaserRecipes, Map<ResourceLocation, IAssemblyRecipe> assemblyDrillRecipes, Map<ResourceLocation, IAssemblyRecipe> assemblyLaserDrillRecipes) {
        this.pressureChamberRecipes = pressureChamberRecipes;
        this.thermopneumaticProcessingPlantRecipes = thermopneumaticProcessingPlantRecipes;
        this.heatFrameCoolingRecipes = heatFrameCoolingRecipes;
        this.explosionCraftingRecipes = explosionCraftingRecipes;
        this.refineryRecipes = refineryRecipes;
        this.assemblyLaserRecipes = assemblyLaserRecipes;
        this.assemblyDrillRecipes = assemblyDrillRecipes;
        this.assemblyLaserDrillRecipes = assemblyLaserDrillRecipes;
    }

    PacketSyncRecipes(PacketBuffer buf) {
        int pressureCount = buf.func_150792_a();
        this.pressureChamberRecipes = Stream.generate(() -> (IPressureChamberRecipe)ModCraftingHelper.readRecipe(buf)).limit(pressureCount).collect(Collectors.toMap(IModRecipe::getId, r -> r));
        int tppCount = buf.func_150792_a();
        this.thermopneumaticProcessingPlantRecipes = Stream.generate(() -> (IThermopneumaticProcessingPlantRecipe)ModCraftingHelper.readRecipe(buf)).limit(tppCount).collect(Collectors.toMap(IModRecipe::getId, r -> r));
        int hfcCount = buf.func_150792_a();
        this.heatFrameCoolingRecipes = Stream.generate(() -> (IHeatFrameCoolingRecipe)ModCraftingHelper.readRecipe(buf)).limit(hfcCount).collect(Collectors.toMap(IModRecipe::getId, r -> r));
        int expCount = buf.func_150792_a();
        this.explosionCraftingRecipes = Stream.generate(() -> (IExplosionCraftingRecipe)ModCraftingHelper.readRecipe(buf)).limit(expCount).collect(Collectors.toMap(IModRecipe::getId, r -> r));
        int refineryCount = buf.func_150792_a();
        this.refineryRecipes = Stream.generate(() -> (IRefineryRecipe)ModCraftingHelper.readRecipe(buf)).limit(refineryCount).collect(Collectors.toMap(IModRecipe::getId, r -> r));
        Supplier<IAssemblyRecipe> supplier = () -> (IAssemblyRecipe)ModCraftingHelper.readRecipe(buf);
        int assLaser = buf.func_150792_a();
        this.assemblyLaserRecipes = Stream.generate(supplier).limit(assLaser).collect(Collectors.toMap(IModRecipe::getId, r -> r));
        int assDrill = buf.func_150792_a();
        this.assemblyDrillRecipes = Stream.generate(supplier).limit(assDrill).collect(Collectors.toMap(IModRecipe::getId, r -> r));
        int assLaserDill = buf.func_150792_a();
        this.assemblyLaserDrillRecipes = Stream.generate(supplier).limit(assLaserDill).collect(Collectors.toMap(IModRecipe::getId, r -> r));
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_150787_b(this.pressureChamberRecipes.size());
        for (IPressureChamberRecipe iPressureChamberRecipe : this.pressureChamberRecipes.values()) {
            ModCraftingHelper.writeRecipe(iPressureChamberRecipe, buf);
        }
        buf.func_150787_b(this.thermopneumaticProcessingPlantRecipes.size());
        for (IThermopneumaticProcessingPlantRecipe iThermopneumaticProcessingPlantRecipe : this.thermopneumaticProcessingPlantRecipes.values()) {
            ModCraftingHelper.writeRecipe(iThermopneumaticProcessingPlantRecipe, buf);
        }
        buf.func_150787_b(this.heatFrameCoolingRecipes.size());
        for (IHeatFrameCoolingRecipe iHeatFrameCoolingRecipe : this.heatFrameCoolingRecipes.values()) {
            ModCraftingHelper.writeRecipe(iHeatFrameCoolingRecipe, buf);
        }
        buf.func_150787_b(this.explosionCraftingRecipes.size());
        for (IExplosionCraftingRecipe iExplosionCraftingRecipe : this.explosionCraftingRecipes.values()) {
            ModCraftingHelper.writeRecipe(iExplosionCraftingRecipe, buf);
        }
        buf.func_150787_b(this.refineryRecipes.size());
        for (IRefineryRecipe iRefineryRecipe : this.refineryRecipes.values()) {
            ModCraftingHelper.writeRecipe(iRefineryRecipe, buf);
        }
        buf.func_150787_b(this.assemblyLaserRecipes.size());
        for (IAssemblyRecipe iAssemblyRecipe : this.assemblyLaserRecipes.values()) {
            ModCraftingHelper.getSerializer(iAssemblyRecipe).write(buf, iAssemblyRecipe);
        }
        buf.func_150787_b(this.assemblyDrillRecipes.size());
        for (IAssemblyRecipe iAssemblyRecipe : this.assemblyDrillRecipes.values()) {
            ModCraftingHelper.getSerializer(iAssemblyRecipe).write(buf, iAssemblyRecipe);
        }
        buf.func_150787_b(this.assemblyLaserDrillRecipes.size());
        for (IAssemblyRecipe iAssemblyRecipe : this.assemblyLaserDrillRecipes.values()) {
            ModCraftingHelper.writeRecipe(iAssemblyRecipe, buf);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PneumaticCraftRecipes.pressureChamberRecipes = this.pressureChamberRecipes;
            PneumaticCraftRecipes.thermopneumaticProcessingPlantRecipes = this.thermopneumaticProcessingPlantRecipes;
            PneumaticCraftRecipes.heatFrameCoolingRecipes = this.heatFrameCoolingRecipes;
            PneumaticCraftRecipes.explosionCraftingRecipes = this.explosionCraftingRecipes;
            PneumaticCraftRecipes.refineryRecipes = this.refineryRecipes;
            PneumaticCraftRecipes.assemblyLaserRecipes = this.assemblyLaserRecipes;
            PneumaticCraftRecipes.assemblyDrillRecipes = this.assemblyDrillRecipes;
            PneumaticCraftRecipes.assemblyLaserDrillRecipes = this.assemblyLaserDrillRecipes;
        });
        ctx.get().setPacketHandled(true);
    }
}

